/*
 * Decompiled with CFR 0.152.
 */
package org.talend.ci.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.talend.ci.util.Utils;
import org.talend.jobbuilder.JobBuilder;
import org.talend.jobbuilder.model.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VersionUtils {
    private static final String RECORD_SEPERATOR = ",";
    private static final String PRE_TALEND_PATCH = "talend.patch";
    private static final String enclosure = "\n*****************************************************\n";
    private Log logger;

    public static VersionUtils create(Log logger) {
        VersionUtils versionUtils = new VersionUtils();
        versionUtils.logger = logger;
        return versionUtils;
    }

    public void checkCompatiable(JobBuilder mojo, String cmdlineWorkspace, String productPath) throws MojoExecutionException {
        File workspace = new File(cmdlineWorkspace);
        Map<String, String[]> proj2Versions = Collections.synchronizedMap(new HashMap());
        Stream.of(workspace.listFiles(File::isDirectory)).forEach(file -> {
            File talendProjectFile = new File((File)file, "talend.project");
            if (talendProjectFile.isFile() && talendProjectFile.exists()) {
                try {
                    String[] bv = this.getProjectVersion((File)file);
                    proj2Versions.put(file.getName(), bv);
                }
                catch (Exception e) {
                    this.logger.error((CharSequence)e.getMessage());
                }
            }
        });
        this.checkCompatiable(mojo, proj2Versions, productPath);
    }

    public String[] getProjectVersion(File file) {
        String projectBrandingVersion = this.getProjectVersionWithBranding(file);
        String[] bv = this.splitProductVersionAndBranding(projectBrandingVersion);
        return bv;
    }

    public void checkCompatiable(JobBuilder mojo, Map<String, String[]> proj2Versions, String productPath) throws MojoExecutionException {
        String ppath;
        MavenSession s = mojo.session;
        String[] productVersion = null;
        this.logger.info((CharSequence)("user props: " + s.getUserProperties().toString() + ", sys props: " + s.getSystemProperties().toString() + ", proj2Versions: " + proj2Versions.toString() + ", productPath: " + productPath));
        String prop_productPath = productPath;
        if (s.getUserProperties().contains("product.path")) {
            prop_productPath = s.getUserProperties().getProperty("product.path");
        }
        if (new File(ppath = Paths.get(prop_productPath, ".eclipseproduct").toAbsolutePath().toString()).exists()) {
            try {
                productVersion = this.getProductVersion(ppath, mojo);
            }
            catch (IOException e) {
                this.logger.error((CharSequence)e.getMessage());
            }
        } else {
            productVersion = new String[2];
            productVersion[1] = "0.0.0";
        }
        Version prodVersion = new Version(productVersion[1]);
        HashMap<String, Version> greaterThanStudioMap = new HashMap<String, Version>();
        for (String proj : proj2Versions.keySet()) {
            Version projVersion = new Version(proj2Versions.get(proj)[1]);
            if (projVersion.compareTo(prodVersion) <= 0) continue;
            greaterThanStudioMap.put(proj, projVersion);
        }
        if (greaterThanStudioMap.size() > 0) {
            String prop_p2update = s.getUserProperties().getProperty("patch.path");
            if (s.getUserProperties().containsKey("talend.studio.p2.update")) {
                prop_p2update = s.getUserProperties().getProperty("talend.studio.p2.update");
            }
            if (StringUtils.isEmpty((String)prop_p2update)) {
                prop_p2update = s.getSystemProperties().getProperty("patch.path");
                if (s.getSystemProperties().containsKey("talend.studio.p2.update")) {
                    prop_p2update = s.getSystemProperties().getProperty("talend.studio.p2.update");
                }
            }
            if (StringUtils.isEmpty((String)prop_p2update)) {
                this.logger.error((CharSequence)"prop_p2update is empty!");
            }
            String higestMonthly = "";
            if (StringUtils.isNotBlank((String)prop_p2update)) {
                Map<String, String> p2updateVersions = this.getP2updateVersions(prop_p2update.split(RECORD_SEPERATOR), mojo);
                this.logger.info((CharSequence)("size of p2updateVersions: " + p2updateVersions.size()));
                Version higestInUpdate = null;
                for (String p2updateVersion : p2updateVersions.keySet()) {
                    if (p2updateVersion == null) continue;
                    Version updateVersion = new Version(p2updateVersion);
                    if (higestInUpdate != null && updateVersion.compareTo(higestInUpdate) <= 0) continue;
                    higestInUpdate = updateVersion;
                    higestMonthly = p2updateVersions.get(p2updateVersion);
                }
                if (higestInUpdate != null) {
                    Iterator iterator = greaterThanStudioMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        Version version = (Version)greaterThanStudioMap.get(iterator.next());
                        if (version.compareTo(higestInUpdate) > 0) continue;
                        iterator.remove();
                    }
                }
            }
            if (greaterThanStudioMap.size() > 0) {
                String talendcmdVersion = productVersion[1];
                if (StringUtils.isEmpty((String)talendcmdVersion)) {
                    talendcmdVersion = higestMonthly;
                }
                throw new MojoExecutionException("\n*****************************************************\nThe Talend Commandline version " + talendcmdVersion + " is older than project version. Use -Dtalend.studio.p2.update to change the update URL to match or supersede the project version and try again." + enclosure);
            }
        }
    }

    private Map<String, String> getP2updateVersions(String[] p2Uris, JobBuilder mojo) throws MojoExecutionException {
        HashMap<String, String> p2updateVersions = new HashMap<String, String>();
        for (String p2uri : p2Uris) {
            Serializable prop;
            if (p2uri.startsWith("http")) {
                if (!p2uri.endsWith("/")) {
                    p2uri = p2uri + "/";
                }
                try {
                    URLConnection conn = new URL(p2uri).toURI().resolve("patch.properties").toURL().openConnection();
                    String credentials = Utils.getBasicAuthCredentials(p2uri, mojo.getP2UserAndPwd(p2uri), mojo.getLog());
                    if (!StringUtils.isEmpty((String)credentials)) {
                        conn.addRequestProperty("Authorization", "Basic " + credentials);
                    }
                    InputStream openStream = conn.getInputStream();
                    prop = new Properties();
                    ((Properties)prop).load(openStream);
                    p2updateVersions.put(((Properties)prop).getProperty("product.version"), ((Properties)prop).getProperty("patch.name"));
                }
                catch (IOException | URISyntaxException ioe) {
                    this.logger.error((CharSequence)ioe.getMessage());
                }
                continue;
            }
            File updatefile = new File(p2uri);
            if (updatefile.isDirectory()) {
                File patchProps = updatefile.toPath().resolve("patch.properties").toFile();
                try {
                    BufferedReader reader = Files.newBufferedReader(patchProps.toPath(), StandardCharsets.UTF_8);
                    prop = null;
                    try {
                        Properties prop2 = new Properties();
                        prop2.load(reader);
                        p2updateVersions.put(prop2.getProperty("product.version"), prop2.getProperty("patch.name"));
                    }
                    catch (Throwable throwable) {
                        prop = throwable;
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            if (prop != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)prop).addSuppressed(throwable);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    this.logger.error((CharSequence)ioe.getMessage());
                }
                continue;
            }
            if (!updatefile.isFile() || !p2uri.endsWith("zip")) continue;
            try (ZipFile zipfile = new ZipFile(updatefile);
                 InputStream openStream = zipfile.getInputStream(zipfile.getEntry("patch.properties"));){
                Properties prop3 = new Properties();
                prop3.load(openStream);
                p2updateVersions.put(prop3.getProperty("product.version"), prop3.getProperty("patch.name"));
            }
            catch (IOException e) {
                this.logger.error((CharSequence)e.getMessage());
            }
        }
        return p2updateVersions;
    }

    public String buildMessage(File projectFile) {
        String monthly = "";
        String branding = "";
        String version = "";
        monthly = this.getMonthlyVersion(projectFile);
        String brandingVersion = this.getProjectVersionWithBranding(projectFile);
        String[] bv = this.splitProductVersionAndBranding(brandingVersion);
        branding = bv[0];
        version = bv[1];
        return VersionUtils.buildPatternMsg(projectFile.getName(), branding, monthly, version);
    }

    public String getMonthlyVersion(File projFile) {
        String monthlyPatch = "";
        File preffile = projFile.toPath().resolve(".settings").resolve("org.talend.core.tis.prefs").toFile();
        if (preffile.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(preffile.toPath(), StandardCharsets.UTF_8);){
                Properties prop = new Properties();
                prop.load(reader);
                monthlyPatch = prop.getProperty("last.patch");
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
        return monthlyPatch;
    }

    public String getProjectVersionWithBranding(File projFile) {
        NodeList children;
        String fullProductVersion = "";
        File talendProjectFile = new File(projFile, "talend.project");
        Document document = null;
        if (talendProjectFile.exists()) {
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                document = builder.parse(talendProjectFile);
            }
            catch (Exception e) {
                this.logger.error((CharSequence)("Failed to parse " + talendProjectFile), (Throwable)e);
            }
        }
        if (document != null && (children = document.getElementsByTagName("TalendProperties:Project")).getLength() > 0) {
            Element projItem = (Element)children.item(0);
            fullProductVersion = projItem.getAttribute("productVersion");
        }
        return fullProductVersion;
    }

    public String[] splitProductVersionAndBranding(String fullProductVersion) {
        String branding;
        StringBuffer versionStr = new StringBuffer();
        if (fullProductVersion != null) {
            String[] splitStr = fullProductVersion.split("-");
            Pattern pattern = Pattern.compile("((\\d+\\.){2}\\d.*)");
            boolean find = false;
            for (String str : splitStr) {
                if (find) {
                    versionStr.append("-").append(str);
                    continue;
                }
                Matcher matcher = pattern.matcher(str);
                if (!matcher.find()) continue;
                find = true;
                versionStr.append(str);
            }
        }
        if ((branding = fullProductVersion.replace(versionStr.toString(), "")).endsWith("-")) {
            branding = branding.substring(0, branding.length() - 1);
        }
        return new String[]{branding, versionStr.toString()};
    }

    public String[] getProductVersion(String eclipseProduct, JobBuilder mojo) throws IOException, MojoExecutionException {
        String[] productVersion = new String[2];
        File eclipseProductFile = new File(eclipseProduct);
        if (eclipseProduct != null && eclipseProductFile.exists()) {
            File cmdInstallPathFile;
            File file;
            try (FileInputStream in = new FileInputStream(eclipseProductFile);){
                Properties prop = new Properties();
                prop.load(in);
                String productFileVersion = prop.getProperty("version");
                if (productFileVersion != null && !"".equals(productFileVersion)) {
                    productVersion[1] = productFileVersion;
                }
                Set<Object> keySet = prop.keySet();
                for (Object key : keySet) {
                    String property;
                    String patchKey = key.toString();
                    if (!patchKey.startsWith(PRE_TALEND_PATCH) || !(property = prop.getProperty(patchKey)).contains(productFileVersion)) continue;
                    String[] values = property.split(RECORD_SEPERATOR);
                    productVersion[0] = values[1];
                }
            }
            if (productVersion[0] == null && (file = (cmdInstallPathFile = new File(eclipseProduct).getParentFile()).toPath().resolve("configuration").resolve(".settings").resolve("org.talend.studiolite.p2.core.prefs").toFile()).exists()) {
                try (FileInputStream in = new FileInputStream(file);){
                    Properties prop = new Properties();
                    prop.load(in);
                    String talendUpdateSite = prop.getProperty("talendUpdateSite");
                    if (StringUtils.isNotBlank((String)talendUpdateSite)) {
                        String file2 = new URL(talendUpdateSite).getFile();
                        Map<String, String> p2updateVersions = this.getP2updateVersions(new String[]{file2}, mojo);
                        productVersion[0] = p2updateVersions.get(productVersion[1]);
                    }
                }
            }
        }
        return productVersion;
    }

    public static String buildPatternMsg(String projectName, String branding, String monthly, String version) {
        return projectName + " (" + branding + " | " + monthly + " | " + version + ")";
    }
}

