/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commons.utils.threading.lockerbykey;

import java.util.ArrayList;
import java.util.List;
import org.talend.commons.utils.StringUtils;
import org.talend.commons.utils.threading.lockerbykey.CustomReentrantLock;
import org.talend.commons.utils.threading.lockerbykey.LockerValueHandler;

public class LockerValue<VKP> {
    private CustomReentrantLock lock;
    private VKP key;
    private List<LockerValueHandler> handlers;
    private StackTraceElement[] stackTraceOfLocker;
    private long lockedTime;

    public LockerValue(VKP key, boolean fair) {
        this.lock = new CustomReentrantLock(fair);
        this.key = key;
    }

    public String toString() {
        return StringUtils.replacePrms("LockerValue: key={0}, lock={1}", String.valueOf(this.key), this.lock.toString());
    }

    public VKP getKey() {
        return this.key;
    }

    public CustomReentrantLock getLock() {
        return this.lock;
    }

    public synchronized void addHandler(LockerValueHandler handler) {
        if (this.handlers == null) {
            this.handlers = new ArrayList<LockerValueHandler>();
        }
        this.handlers.add(handler);
    }

    public synchronized LockerValueHandler getHandler() {
        if (this.handlers != null && this.handlers.size() > 0) {
            LockerValueHandler lockerValueHandler = this.handlers.get(0);
            return lockerValueHandler;
        }
        return null;
    }

    public synchronized LockerValueHandler getHandlerAndRemove() {
        if (this.handlers != null && this.handlers.size() > 0) {
            LockerValueHandler lockerValueHandler = this.handlers.get(0);
            this.handlers.remove(0);
            return lockerValueHandler;
        }
        return null;
    }

    public StackTraceElement[] getStackTraceOfLocker() {
        return this.stackTraceOfLocker;
    }

    public void setStackTraceOfLocker(StackTraceElement[] stackTraceElements) {
        this.stackTraceOfLocker = stackTraceElements;
    }

    public long getLockedTime() {
        return this.lockedTime;
    }

    public void setLockedTime(long lockedTime) {
        this.lockedTime = lockedTime;
    }
}

