/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class JavaVersion
implements Comparable<JavaVersion> {
    private static final Logger LOGGER = Logger.getLogger(JavaVersion.class.getCanonicalName());
    private int major;
    private int minor;
    private int buildNumber;
    private int security;

    public JavaVersion(String v) {
        this.parseVersion(v);
    }

    @Override
    public int compareTo(JavaVersion o) {
        if (this.major - o.major == 0) {
            if (this.minor - o.minor == 0) {
                if (this.buildNumber - o.buildNumber == 0) {
                    return this.security - o.security;
                }
                return this.buildNumber - o.buildNumber;
            }
            return this.minor - o.minor;
        }
        return this.major - o.major;
    }

    private String normalizeVersion(String v) {
        if ((v = v.replaceAll("[^\\d._]", "")).isEmpty()) {
            v = "0";
        }
        return v;
    }

    private void parseVersion(String v) {
        if (v == null || v.isEmpty()) {
            return;
        }
        String[] version = v.split("[\\._]");
        try {
            this.major = Integer.parseInt(this.normalizeVersion(version[0]));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Major version parse error of " + v, e);
        }
        if (version.length > 1 && !StringUtils.isEmpty((CharSequence)version[1])) {
            try {
                this.minor = Integer.parseInt(this.normalizeVersion(version[1]));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Minor version parse error of " + v, e);
            }
        }
        if (version.length > 2 && !StringUtils.isEmpty((CharSequence)version[2])) {
            try {
                this.buildNumber = Integer.parseInt(this.normalizeVersion(version[2]));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Build number parse error of " + v, e);
            }
        }
        if (version.length > 3 && !StringUtils.isEmpty((CharSequence)version[3])) {
            String securityNumber = version[3];
            for (int i = 0; i < securityNumber.length(); ++i) {
                char c = securityNumber.charAt(i);
                if (c <= '9' && c >= '0') continue;
                securityNumber = securityNumber.substring(0, i);
                break;
            }
            try {
                this.security = Integer.parseInt(securityNumber);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Security version parse error of " + v, e);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = result * 31 + this.major;
        result = result * 31 + this.minor;
        result = result * 31 + this.buildNumber;
        result = result * 31 + this.security;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaVersion)) {
            return false;
        }
        JavaVersion that = (JavaVersion)obj;
        return this.compareTo(that) == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.major);
        sb.append(".");
        sb.append(this.minor);
        sb.append(".");
        sb.append(this.buildNumber);
        if (this.security > 0) {
            sb.append("_");
            sb.append(this.security);
        }
        return sb.toString();
    }
}

