/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.dates;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    protected static Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String PATTERN_1 = "MM/dd/yyyy";
    public static final String PATTERN_2 = "yyyy-MM-dd hh:mm:ss";
    public static final String PATTERN_3 = "yyyy-MM-dd";
    public static final String PATTERN_4 = "MM/dd/yyyy HH:mm";
    public static final String PATTERN_5 = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_6 = "yyyyMMddHHmmss";
    public static final String PATTERN_7 = "hh:mm:ss";
    public static final String UTC = "UTC";

    private DateUtils() {
    }

    public static Date parse(String pattern, String dateText) throws ParseException {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        date = sdf.parse(dateText);
        return date;
    }

    public static String getCurrentDate(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(new Date());
    }

    public static String formatTimeStamp(String pattern, long date) {
        if (pattern == null || pattern.length() == 0) {
            pattern = PATTERN_6;
        }
        GregorianCalendar nowDate = new GregorianCalendar();
        nowDate.setTimeInMillis(date);
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(nowDate.getTime());
    }

    public static Date convert2StandardTime(Date localDate) {
        Date result = localDate;
        SimpleDateFormat dateFormat = new SimpleDateFormat(PATTERN_5);
        dateFormat.setTimeZone(TimeZone.getTimeZone(UTC));
        String dateStr = dateFormat.format(localDate);
        try {
            dateFormat.setTimeZone(TimeZone.getDefault());
            result = dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static Date getDateWithoutTime(Date utcExecutionDate) {
        Date calendarDate = utcExecutionDate;
        try {
            calendarDate = DateUtils.parse(PATTERN_3, DateUtils.formatTimeStamp(PATTERN_3, calendarDate.getTime()));
        }
        catch (ParseException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return calendarDate;
    }

    public static DateFormat createDateFormater(int dataType) {
        SimpleDateFormat ret;
        switch (dataType) {
            case 92: {
                ret = new SimpleDateFormat("HH:mm:ss");
                break;
            }
            case 93: {
                ret = new SimpleDateFormat(PATTERN_5);
                break;
            }
            default: {
                ret = new SimpleDateFormat(PATTERN_3);
            }
        }
        return ret;
    }
}

