/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.utils.properties.PropertiesReloader;
import org.talend.utils.properties.TypedProperties;

public final class PropertiesLoader {
    private static Logger log = LoggerFactory.getLogger(PropertiesLoader.class);
    public static final String MY_PROP_KEY = "talend_props";
    private static final String PROPERTIES_FILENAME = System.getProperty("talend_props");
    private static final String USAGE = "Try with -Dtalend_props=file.properties with file.properties a relative or absolute file path.";
    private static final String QUOTE = "'";
    private static TypedProperties curProp;

    private static Properties convertToProperties(Dictionary config) {
        Enumeration keys = config.keys();
        Properties props = new Properties();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            props.setProperty(key, (String)config.get(key));
        }
        return props;
    }

    public static void setConfig(Dictionary config) {
        Properties prop = PropertiesLoader.convertToProperties(config);
        curProp = new TypedProperties(prop);
    }

    private static String quotedAbsolutePath(File in) {
        return in == null ? QUOTE : QUOTE + in.getAbsolutePath() + QUOTE;
    }

    public static synchronized TypedProperties getProperties() {
        if (curProp == null) {
            curProp = PropertiesLoader.initialize();
        }
        return curProp;
    }

    public static synchronized TypedProperties getProperties(Class<?> clazz, String propertiesFilename) {
        TypedProperties prop = new TypedProperties();
        InputStream inStream = clazz.getClassLoader().getResourceAsStream(propertiesFilename);
        if (inStream == null) {
            inStream = clazz.getResourceAsStream(propertiesFilename);
        }
        if (inStream == null) {
            log.error("Properties file not found: " + propertiesFilename);
        } else {
            try {
                prop.load(inStream);
            }
            catch (IOException e) {
                log.error("Properties file " + propertiesFilename + " not found: " + e.getMessage());
            }
        }
        return prop;
    }

    public static synchronized void setProperties(Class<?> clazz, String propertiesFilename, String key, String oldValue, String newValue) {
        if (oldValue.equals(newValue)) {
            return;
        }
        try {
            PropertiesReloader.setProperties(clazz, propertiesFilename, key, oldValue, newValue);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static synchronized TypedProperties initialize() {
        Properties sysProp = System.getProperties();
        TypedProperties prop = new TypedProperties(sysProp);
        if (PROPERTIES_FILENAME == null || PROPERTIES_FILENAME.length() == 0) {
            log.warn("Warning: no properties file name given in JVM arguments.Try with -Dtalend_props=file.properties with file.properties a relative or absolute file path.");
        } else {
            PropertiesLoader.initialize(prop, new File(PROPERTIES_FILENAME));
        }
        return prop;
    }

    public static synchronized boolean initialize(TypedProperties prop, File in) {
        boolean ok = true;
        try {
            if (in.exists()) {
                log.info("Loading Properties from file: " + PropertiesLoader.quotedAbsolutePath(in));
            } else {
                ok = false;
                log.info("Given file for properties does not exist: " + PropertiesLoader.quotedAbsolutePath(in));
            }
            String filename = in.getAbsolutePath();
            boolean bl = ok = ok && PropertiesLoader.loadPropertiesLow(filename, prop);
            if (!ok) {
                log.warn("Warning: Problem when loading properties from file " + filename);
            }
        }
        catch (Exception e) {
            ok = false;
            log.error(USAGE);
            log.error("ERROR: could not load properties file=" + PropertiesLoader.quoted(in.toString()), (Throwable)e);
        }
        return ok;
    }

    private static boolean loadPropertiesLow(String filename, TypedProperties prop) throws Exception {
        boolean ok = true;
        try (FileInputStream is = null;){
            try {
                is = new FileInputStream(filename);
                if (is == null) {
                    throw new Exception("ERROR: Could not load file = " + PropertiesLoader.quoted(filename));
                }
                prop.load(is);
                is.close();
                is = null;
            }
            catch (Exception e) {
                ok = false;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
                throw e;
            }
        }
        return ok;
    }

    private static String quoted(String in) {
        return in == null ? "''" : QUOTE + in + QUOTE;
    }

    private PropertiesLoader() {
    }
}

