/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.security;

import org.apache.commons.lang3.StringUtils;
import org.talend.daikon.security.CryptoHelper;
import org.talend.utils.security.StudioEncryption;

public class PasswordMigrationUtil {
    public static String decryptPassword(String pass) throws Exception {
        String cleanPass = pass;
        if (StringUtils.isNotEmpty((CharSequence)pass)) {
            if (StudioEncryption.hasEncryptionSymbol(pass)) {
                cleanPass = StudioEncryption.getStudioEncryption(StudioEncryption.EncryptionKeyName.SYSTEM).decrypt(pass);
            } else {
                try {
                    cleanPass = new CryptoHelper(CryptoHelper.PASSPHRASE).decrypt(pass);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return cleanPass;
    }

    public static String encryptPasswordIfNeeded(String pass) throws Exception {
        String cleanPass = PasswordMigrationUtil.decryptPassword(pass);
        if (cleanPass != null) {
            return StudioEncryption.getStudioEncryption(StudioEncryption.EncryptionKeyName.SYSTEM).encrypt(cleanPass);
        }
        return pass;
    }

    private PasswordMigrationUtil() {
    }
}

