/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.sql.metadata.constants;

import java.util.ArrayList;

public enum TableType {
    TABLE,
    VIEW,
    SYSTEM_TABLE,
    GLOBAL_TEMPORARY,
    LOCAL_TEMPORARY,
    ALIAS,
    CALCULATION_VIEW,
    SYNONYM;


    public String toString() {
        switch (this) {
            case SYSTEM_TABLE: {
                return "SYSTEM TABLE";
            }
            case GLOBAL_TEMPORARY: {
                return "GLOBAL TEMPORARY";
            }
            case LOCAL_TEMPORARY: {
                return "LOCAL TEMPORARY";
            }
            case CALCULATION_VIEW: {
                return "CALCULATION VIEW";
            }
        }
        return this.name();
    }

    public static String[] getTableTypes(TableType ... type) {
        if (type == null) {
            return null;
        }
        ArrayList<String> tablesTypes = new ArrayList<String>();
        TableType[] tableTypeArray = type;
        int n = type.length;
        int n2 = 0;
        while (n2 < n) {
            TableType tableType = tableTypeArray[n2];
            if (tableType == null) {
                tablesTypes.add(null);
            } else {
                tablesTypes.add(tableType.toString());
            }
            ++n2;
        }
        return tablesTypes.toArray(new String[tablesTypes.size()]);
    }
}

