/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.wsdl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.talend.utils.xml.XmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLLoader {
    public static final String DEFAULT_FILENAME = "";
    private static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    private static final String NAME_ELEMENT_SCHEMA = "schema";
    private static final String NAME_ATTRIBUTE_TARGET_NAMESPACE = "targetNamespace";
    private static final String NAME_ATTRIBUTE_SCHEMA_LOCATION = "schemaLocation";
    private static DocumentBuilder documentBuilder = null;
    private static int filenameIndex;
    private final Map<String, Collection<URL>> importedSchemas = new HashMap<String, Collection<URL>>();

    public Map<String, InputStream> load(String wsdlLocation, String filenameTemplate) throws InvocationTargetException {
        filenameIndex = 0;
        return this.load(null, wsdlLocation, filenameTemplate, new LinkedList<String>());
    }

    private Map<String, InputStream> load(URL baseURL, String wsdlLocation, String filenameTemplate, List<String> processedDefinitions) throws InvocationTargetException {
        HashMap<String, InputStream> wsdls = new HashMap<String, InputStream>();
        try {
            URL wsdlURL = WSDLLoader.getURL(baseURL, wsdlLocation);
            String absoluteWsdlLocation = wsdlURL.toExternalForm();
            Document wsdlDocument = WSDLLoader.getDocumentBuilder().parse(absoluteWsdlLocation);
            String targetNamespace = wsdlDocument.getDocumentElement().getAttribute(NAME_ATTRIBUTE_TARGET_NAMESPACE);
            if (targetNamespace == null || targetNamespace.length() == 0) {
                throw new IllegalStateException("WSDL definitions found without target namespace. ");
            }
            String definitionKey = String.valueOf(targetNamespace) + " " + absoluteWsdlLocation;
            processedDefinitions.add(definitionKey);
            NodeList schemas = wsdlDocument.getElementsByTagNameNS(XSD_NS, NAME_ELEMENT_SCHEMA);
            Element[] schemaElements = new Element[schemas.getLength()];
            int index = 0;
            while (index < schemas.getLength()) {
                schemaElements[index] = (Element)schemas.item(index);
                ++index;
            }
            Element[] elementArray = schemaElements;
            int n = schemaElements.length;
            int n2 = 0;
            while (n2 < n) {
                Element schema = elementArray[n2];
                this.importedSchemas.put(schema.getAttribute(NAME_ATTRIBUTE_TARGET_NAMESPACE), new HashSet());
                this.loadSchemas(schema, schema, wsdlURL);
                ++n2;
            }
            NodeList imports = wsdlDocument.getElementsByTagNameNS(WSDL_NS, "import");
            int index2 = 0;
            while (index2 < imports.getLength()) {
                Element wsdlImport = (Element)imports.item(index2);
                String namespace = wsdlImport.getAttribute("namespace");
                String location = wsdlImport.getAttribute("location");
                String absoluteLocation = WSDLLoader.getURL(baseURL, location).toExternalForm();
                String importKey = String.valueOf(namespace) + " " + absoluteLocation;
                if (processedDefinitions.contains(importKey)) {
                    wsdlImport.getParentNode().removeChild(wsdlImport);
                } else {
                    String fileName = String.format(filenameTemplate, filenameIndex++);
                    Map<String, InputStream> importedWsdls = new WSDLLoader().load(wsdlURL, location, filenameTemplate, processedDefinitions);
                    wsdlImport.setAttribute("location", fileName);
                    wsdls.put(fileName, importedWsdls.remove(DEFAULT_FILENAME));
                    wsdls.putAll(importedWsdls);
                }
                ++index2;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DOMSource xmlSource = new DOMSource(wsdlDocument);
            StreamResult outputTarget = new StreamResult(outputStream);
            XmlUtils.getXmlSecureTransform().transform(xmlSource, outputTarget);
            wsdls.put(DEFAULT_FILENAME, new ByteArrayInputStream(outputStream.toByteArray()));
            HashMap<String, InputStream> hashMap = wsdls;
            return hashMap;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "Error occured while processing schemas");
        }
        finally {
            this.importedSchemas.clear();
        }
    }

    private static URL getURL(URL contextURL, String spec) throws MalformedURLException {
        try {
            return new URL(contextURL, spec);
        }
        catch (MalformedURLException e) {
            File tempFile = new File(spec);
            if (contextURL == null || contextURL != null && tempFile.isAbsolute()) {
                return tempFile.toURI().toURL();
            }
            throw e;
        }
    }

    private void loadSchemas(Element ownerSchemaNode, Element schemaNode, URL ownerFile) throws InvocationTargetException, IOException {
        HashMap<String, String> prefixMapping = new HashMap<String, String>();
        Node childNode = schemaNode.getFirstChild();
        while (childNode != null) {
            Node nextNode = childNode.getNextSibling();
            if (childNode.getNodeType() == 1 && XSD_NS.equals(childNode.getNamespaceURI())) {
                String schemaLocation;
                if ("import".equals(childNode.getLocalName())) {
                    Element importElement;
                    block35: {
                        importElement = (Element)childNode;
                        schemaLocation = importElement.getAttribute(NAME_ATTRIBUTE_SCHEMA_LOCATION);
                        String schemaNS = importElement.getAttribute("namespace");
                        if (schemaLocation != null && schemaLocation.length() != 0 && schemaNS != null && schemaNS.length() != 0) {
                            try {
                                URL schemaURL = WSDLLoader.getURL(ownerFile, schemaLocation);
                                if (!this.importedSchemas.containsKey(schemaNS)) {
                                    Element schemaImported = (Element)ownerSchemaNode.getOwnerDocument().importNode(WSDLLoader.loadSchema(schemaURL, false), true);
                                    ownerSchemaNode.getParentNode().insertBefore(schemaImported, ownerSchemaNode);
                                    HashSet<URL> urls = new HashSet<URL>();
                                    urls.add(schemaURL);
                                    this.importedSchemas.put(schemaNS, urls);
                                    this.loadSchemas(schemaImported, schemaImported, schemaURL);
                                    break block35;
                                }
                                if (!this.importedSchemas.get(schemaNS).add(schemaURL)) break block35;
                                NodeList nl = ((Element)ownerSchemaNode.getParentNode()).getElementsByTagNameNS(XSD_NS, NAME_ELEMENT_SCHEMA);
                                int i = 0;
                                while (i < nl.getLength()) {
                                    Element schema = (Element)nl.item(i);
                                    if (schemaNS.equals(schema.getAttribute(NAME_ATTRIBUTE_TARGET_NAMESPACE))) {
                                        Element schemaElement = WSDLLoader.loadSchema(schemaURL, true);
                                        this.loadSchemas(schema, schemaElement, schemaURL);
                                        Node refChild = WSDLLoader.getInsertLocation(schema.getLastChild());
                                        Node child = schemaElement.getFirstChild();
                                        while (child != null) {
                                            Node next = child.getNextSibling();
                                            child = schema.getOwnerDocument().importNode(child, true);
                                            schema.insertBefore(child, refChild);
                                            child = next;
                                        }
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            catch (InvocationTargetException e) {
                                throw e;
                            }
                            catch (IOException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e, "Unexpected error while loading external schema file: " + e.getMessage());
                            }
                        }
                    }
                    if (importElement != null) {
                        importElement.removeAttribute(NAME_ATTRIBUTE_SCHEMA_LOCATION);
                        importElement.getParentNode().insertBefore(importElement, WSDLLoader.getInsertLocation(importElement));
                    }
                } else if ("include".equals(childNode.getLocalName())) {
                    Element includeElement = (Element)childNode;
                    schemaLocation = includeElement.getAttribute(NAME_ATTRIBUTE_SCHEMA_LOCATION);
                    if (schemaLocation == null || schemaLocation.length() == 0) {
                        String errMsg = "The schema include is incorrect: schemaLocation = [" + schemaLocation + "]";
                        throw new InvocationTargetException(new Exception(errMsg));
                    }
                    try {
                        URL schemaURL = WSDLLoader.getURL(ownerFile, schemaLocation);
                        String schemaNamespace = ownerSchemaNode.getAttribute(NAME_ATTRIBUTE_TARGET_NAMESPACE);
                        if (this.importedSchemas.get(schemaNamespace).add(schemaURL)) {
                            Element schemaIncluded = WSDLLoader.loadSchema(schemaURL, true);
                            String includeNamespace = schemaIncluded.getAttribute(NAME_ATTRIBUTE_TARGET_NAMESPACE);
                            if (includeNamespace != null && includeNamespace.length() != 0 && !schemaNamespace.equals(includeNamespace)) {
                                String errMsg = "The schema include is incorrect: namespaces are not equals";
                                throw new InvocationTargetException(new Exception(errMsg));
                            }
                            this.loadSchemas(ownerSchemaNode, schemaIncluded, schemaURL);
                            NamedNodeMap nnm = schemaIncluded.getAttributes();
                            int i = 0;
                            while (i < nnm.getLength()) {
                                Node attr = nnm.item(i);
                                String attrNamespace = attr.getNamespaceURI();
                                String attrLocalName = attr.getLocalName();
                                String attrValueNew = attr.getNodeValue();
                                String attrValueOld = WSDLLoader.getAttributeValue(schemaNode, attrNamespace, attrLocalName);
                                if (attrValueOld != null) {
                                    if (XMLNS_NS.equals(attrNamespace) && !attrValueNew.equals(attrValueOld)) {
                                        String prefixNew = WSDLLoader.getPrefix(schemaNode, attrValueNew);
                                        if (prefixNew == null) {
                                            prefixNew = WSDLLoader.generatePrefix(schemaIncluded, attrLocalName);
                                            schemaNode.setAttributeNS(XMLNS_NS, "xmlns:" + prefixNew, attrValueNew);
                                        }
                                        prefixMapping.put(attrLocalName, prefixNew);
                                    }
                                } else {
                                    String attrName = attr.getNodeName();
                                    if (XMLNS_NS.equals(attrNamespace)) {
                                        String prefixNew = WSDLLoader.getPrefix(schemaNode, attrValueNew);
                                        if (prefixNew != null) {
                                            prefixMapping.put(attrLocalName, prefixNew);
                                        } else {
                                            schemaNode.setAttributeNS(XMLNS_NS, attrName, attrValueNew);
                                        }
                                    } else {
                                        schemaNode.setAttributeNS(attrNamespace, attrName, attrValueNew);
                                    }
                                }
                                ++i;
                            }
                            Node firstIncludedNode = null;
                            Node child = schemaIncluded.getFirstChild();
                            while (child != null) {
                                Node next = child.getNextSibling();
                                child = schemaNode.getOwnerDocument().importNode(child, true);
                                if (child.getNodeType() == 1) {
                                    WSDLLoader.fixPrefixes((Element)child, prefixMapping);
                                }
                                child = schemaNode.insertBefore(child, includeElement);
                                if (firstIncludedNode == null) {
                                    firstIncludedNode = child;
                                }
                                child = next;
                            }
                            if (firstIncludedNode != null) {
                                nextNode = firstIncludedNode;
                            }
                        }
                    }
                    catch (InvocationTargetException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e, "Unexpected error while loading external schema file: " + e.getMessage());
                    }
                    includeElement.getParentNode().removeChild(includeElement);
                }
            }
            childNode = nextNode;
        }
    }

    private static final String generatePrefix(Element element, String initialPrefix) {
        String prefix = initialPrefix;
        int index = 0;
        while (WSDLLoader.getAttributeValue(element, XMLNS_NS, prefix) != null) {
            prefix = String.valueOf(initialPrefix) + index;
            ++index;
        }
        return prefix;
    }

    private static final String getPrefix(Element element, String namespace) {
        NamedNodeMap nnm = element.getAttributes();
        int i = 0;
        while (i < nnm.getLength()) {
            Node attr = nnm.item(i);
            if (XMLNS_NS.equals(attr.getNamespaceURI()) && namespace.equals(attr.getNodeValue())) {
                return attr.getLocalName();
            }
            ++i;
        }
        return null;
    }

    private static final String getAttributeValue(Element element, String namespace, String localName) {
        Attr attr = element.getAttributeNodeNS(namespace, localName);
        return attr != null ? attr.getNodeValue() : null;
    }

    private static final void fixPrefixes(Element element, Map<String, String> prefixMapping) {
        NamedNodeMap nnm = element.getAttributes();
        String prefix = element.getPrefix();
        String prefixNew = prefixMapping.get(prefix);
        if (prefixNew != null) {
            if ("xmlns".equals(prefixNew)) {
                prefixNew = null;
            }
            element.setPrefix(prefixNew);
        }
        int i = 0;
        while (i < nnm.getLength()) {
            Node attr = nnm.item(i);
            String value = attr.getNodeValue();
            if (value != null) {
                int index = value.indexOf(58);
                if (index != -1) {
                    String prefixOld = value.substring(0, index);
                    prefixNew = prefixMapping.get(prefixOld);
                    if (prefixNew != null) {
                        if ("xmlns".equals(prefixNew)) {
                            attr.setNodeValue(value.substring(index + 1));
                        } else {
                            attr.setNodeValue(String.valueOf(prefixNew) + ':' + value.substring(index + 1));
                        }
                    }
                } else {
                    String name;
                    prefixNew = prefixMapping.get("xmlns");
                    if (prefixNew != null && ("type".equals(name = attr.getLocalName()) || "base".equals(name) || "ref".equals(name))) {
                        attr.setNodeValue(String.valueOf(prefixNew) + ':' + value);
                    }
                }
            }
            ++i;
        }
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                WSDLLoader.fixPrefixes((Element)child, prefixMapping);
            }
            child = child.getNextSibling();
        }
    }

    private static final Element loadSchema(URL schemaFile, boolean cleanup) throws IOException, SAXException, ParserConfigurationException {
        try (InputStream is = null;){
            is = schemaFile.openStream();
            Element schemaElement = WSDLLoader.getDocumentBuilder().parse(is).getDocumentElement();
            if (cleanup) {
                WSDLLoader.cleanupSchemaElement(schemaElement);
            }
            Element element = schemaElement;
            return element;
        }
    }

    private static final void cleanupSchemaElement(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            Node next = node.getNextSibling();
            if (8 == node.getNodeType()) {
                element.removeChild(node);
            } else if (1 == node.getNodeType()) {
                Element child = (Element)node;
                if (XSD_NS.equals(child.getNamespaceURI()) && "annotation".equals(child.getLocalName())) {
                    element.removeChild(child);
                } else {
                    WSDLLoader.cleanupSchemaElement(child);
                }
            }
            node = next;
        }
    }

    private static Node getInsertLocation(Node currentNode) {
        Node refChild = currentNode.getPreviousSibling();
        while (refChild != null) {
            if (refChild.getNodeType() == 1 && XSD_NS.equals(refChild.getNamespaceURI()) && "import".equals(refChild.getLocalName())) {
                refChild = refChild.getNextSibling();
                break;
            }
            refChild = refChild.getPreviousSibling();
        }
        if (refChild == null) {
            refChild = currentNode.getParentNode().getFirstChild();
            while (refChild.getNodeType() != 1) {
                refChild = refChild.getNextSibling();
            }
        }
        return refChild;
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (documentBuilder == null) {
            DocumentBuilderFactory factory = XmlUtils.getSecureDocumentBuilderFactory(false);
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            documentBuilder = factory.newDocumentBuilder();
        }
        return documentBuilder;
    }
}

