/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command.extension;

import org.talend.commandline.client.command.extension.AbstractServerCommand;
import org.talend.commandline.client.util.CommandStringBuilder;

public class ChangeMavenVersionCommand
extends AbstractServerCommand {
    private String newMavenVersion;
    private boolean snapshot;
    private boolean subjobs;
    private String itemFilter;

    public ChangeMavenVersionCommand() {
    }

    public ChangeMavenVersionCommand(String newMavenVersion, boolean snapshot, boolean subjobs, String itemFilter) {
        this.newMavenVersion = newMavenVersion;
        this.snapshot = snapshot;
        this.subjobs = subjobs;
        this.itemFilter = itemFilter;
    }

    @Override
    public String writeToString() {
        CommandStringBuilder builder = new CommandStringBuilder("changeMavenVersion");
        builder.addArgument(this.getNewMavenVersion());
        if (this.isSnapshot()) {
            builder.addOption("ss");
        }
        if (this.isSubjobs()) {
            builder.addOption("sj");
        }
        if (this.getItemFilter() != null) {
            builder.addOptionWithArgument("if", this.getItemFilter());
        }
        return builder.toString();
    }

    public String getNewMavenVersion() {
        return (String)this.getValue("MAVEN_VERSION");
    }

    public boolean isSnapshot() {
        return this.getBooleanValue("SNAPSHOT");
    }

    public boolean isSubjobs() {
        return this.getBooleanValue("SUBJOBS");
    }

    public String getItemFilter() {
        return (String)this.getValue("ITEM_FILTER");
    }
}

