/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.talend.ci.util.Utils;
import org.talend.jobbuilder.JobBuilder;
import org.talend.jobbuilder.model.Constants;
import org.talend.jobbuilder.model.ERuntimeError;

abstract class Run {
    JobBuilder mojo;
    FileWriter logWriter;
    volatile boolean commandExit = false;
    Log logger;

    Run(JobBuilder mojo) {
        this.mojo = mojo;
        this.logger = mojo.getLog();
    }

    Result run() throws MojoFailureException, MojoExecutionException {
        try {
            Result result = this.doRun();
            return result;
        }
        finally {
            try {
                if (this.logWriter != null) {
                    this.logWriter.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Throwable)e);
            }
        }
    }

    abstract Result doRun() throws MojoFailureException, MojoExecutionException;

    abstract List<ERuntimeError> getErrorsToCheck();

    abstract String getApplication();

    File getExecDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    List<String> getExecutionCommand() throws MojoFailureException {
        String mavenSettingFile;
        String forceOnline;
        if (this.mojo.launcherPath == null) {
            File pluginsFolder = new File(this.mojo.productPath, "plugins");
            Pattern pattern = Pattern.compile("org.eclipse.equinox.launcher_.+\\.jar");
            File[] plugins = pluginsFolder.listFiles();
            if (plugins != null) {
                for (File plugin : plugins) {
                    if (!pattern.matcher(plugin.getName()).matches()) continue;
                    this.mojo.launcherPath = plugin.getAbsolutePath();
                    break;
                }
            }
            if (this.mojo.launcherPath == null) {
                throw new MojoFailureException("Can not find equinox launcher!");
            }
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("java");
        this.initProxyParams(commandList);
        this.addAdditionalProperties(this.mojo.jvmArguments, commandList);
        String basedir = this.mojo.session.getLocalRepository().getBasedir();
        commandList.add("-Dmaven.local.repository=" + basedir);
        commandList.add("-Dtalend.component.manager.m2.repository=" + basedir);
        commandList.add("-Dci.mode=true");
        commandList.add("-Dorg.eclipse.ecf.provider.filetransfer.excludeContributors=org.eclipse.ecf.provider.filetransfer.httpclientjava");
        this.addArrangedProperties("install", true, commandList);
        this.addArrangedProperties("studio", true, commandList);
        this.addArrangedProperties("talend", false, commandList);
        if (this.mojo.session.getCurrentProject() != null && this.mojo.session.getCurrentProject().getActiveProfiles() != null) {
            boolean isCloudPublishOnly = false;
            String serviceUrl = this.mojo.session.getUserProperties().getProperty("service.url");
            String cloudToken = this.mojo.session.getUserProperties().getProperty("cloud.token");
            if (!StringUtils.isEmpty(cloudToken) && !StringUtils.isEmpty(serviceUrl)) {
                isCloudPublishOnly = true;
            }
            List profiles = this.mojo.session.getCurrentProject().getActiveProfiles();
            for (Profile p : profiles) {
                if (!StringUtils.equals(p.getId(), "cloud-publisher")) continue;
                isCloudPublishOnly = true;
                break;
            }
            if (isCloudPublishOnly) {
                for (Profile p : profiles) {
                    if (!StringUtils.equals(p.getId(), "docker") && !StringUtils.equals(p.getId(), "nexus")) continue;
                    isCloudPublishOnly = false;
                    break;
                }
            }
            if (isCloudPublishOnly) {
                this.mojo.getLog().info((CharSequence)"publishing to cloud only");
                commandList.add(String.format("-D%s=true", "publish.cloud"));
            }
        }
        if (StringUtils.isBlank(forceOnline = this.mojo.session.getUserProperties().getProperty("studio.forceMavenOnline"))) {
            commandList.add("-DforceMavenOnline=true");
        }
        if ((StringUtils.isBlank(forceOnline) || Boolean.valueOf(forceOnline).booleanValue()) && (mavenSettingFile = Utils.getMavenSettingsFile(this.mojo.session)) != null) {
            commandList.add("-Dmaven.settings=" + mavenSettingFile);
        }
        if (this.mojo.debug) {
            commandList.add("-Xdebug");
            commandList.add("-Djava.compiler=NONE");
            commandList.add("-agentlib:jdwp=server=y,transport=dt_socket,suspend=y,address=*:9195");
        }
        this.mojo.appendLiteP2Patch(commandList);
        this.mojo.appendMavenRepo(commandList);
        commandList.add("-classpath");
        commandList.add(this.mojo.launcherPath);
        commandList.add("org.eclipse.core.launcher.Main");
        commandList.add("-application");
        commandList.add(this.getApplication());
        commandList.add("-consolelog");
        if (!StringUtils.isEmpty(this.mojo.keyRingPath)) {
            commandList.add("-eclipse.keyring");
            commandList.add(this.mojo.keyRingPath);
        }
        if (!StringUtils.isEmpty(this.mojo.masterKeyPath)) {
            commandList.add("-eclipse.password");
            commandList.add(this.mojo.masterKeyPath);
        }
        if (!StringUtils.isEmpty(this.mojo.eclipseDebug)) {
            commandList.add("-debug");
            commandList.add(this.mojo.eclipseDebug);
        }
        commandList.add("-data");
        commandList.add(this.mojo.commandlineWorkspace);
        return commandList;
    }

    private String getMavenSettingsFile() {
        String envSettings;
        String args = this.mojo.session.getSystemProperties().getProperty("env.MAVEN_CMD_LINE_ARGS");
        if (StringUtils.isNotBlank(args)) {
            List<String> argLines = Arrays.asList(args.split("\\s+"));
            for (int i = 0; i < argLines.size(); ++i) {
                String arg = argLines.get(i);
                if (arg.equals("-s") || arg.equals("--settings")) {
                    return argLines.get(i + 1);
                }
                if (!arg.startsWith("-s=") && !arg.startsWith("--settings=")) continue;
                return StringUtils.substringAfter(arg, "=");
            }
        }
        if ((envSettings = this.mojo.session.getSystemProperties().getProperty("env.MAVEN_SETTINS")) != null) {
            return envSettings;
        }
        return null;
    }

    protected void initProxyParams(List<String> commandList) {
        commandList.add("-Dtalend.studio.proxy.enableSystemProxyByDefault=" + Boolean.valueOf(this.mojo.defaultEnableSystemProxy).toString());
        if (!this.mojo.useProxyFromMvnCmd) {
            return;
        }
        String httpProxyHost = System.getProperty("http.proxyHost");
        String httpProxyPort = System.getProperty("http.proxyPort");
        if (StringUtils.isNotBlank(httpProxyHost) && StringUtils.isNotBlank(httpProxyPort)) {
            String httpUser = System.getProperty("http.proxyUser");
            String httpPassword = System.getProperty("http.proxyPassword");
            String httpNonProxyHosts = System.getProperty("http.nonProxyHosts");
            commandList.add("-Dhttp.proxyHost=" + httpProxyHost);
            commandList.add("-Dhttp.proxyPort=" + httpProxyPort);
            if (StringUtils.isNotBlank(httpUser)) {
                commandList.add("-Dhttp.proxyUser=" + httpUser);
                if (StringUtils.isNotBlank(httpPassword)) {
                    commandList.add("-Dhttp.proxyPassword=" + httpPassword);
                }
            }
            if (StringUtils.isNotBlank(httpNonProxyHosts)) {
                commandList.add("-Dhttp.nonProxyHosts=" + httpNonProxyHosts);
            }
        }
        String httpsProxyHost = System.getProperty("https.proxyHost");
        String httpsProxyPort = System.getProperty("https.proxyPort");
        if (StringUtils.isNotBlank(httpsProxyHost) && StringUtils.isNotBlank(httpsProxyPort)) {
            String httpsUser = System.getProperty("https.proxyUser");
            String httpsPassword = System.getProperty("https.proxyPassword");
            String httpsNonProxyHosts = System.getProperty("https.nonProxyHosts");
            commandList.add("-Dhttps.proxyHost=" + httpsProxyHost);
            commandList.add("-Dhttps.proxyPort=" + httpsProxyPort);
            if (StringUtils.isNotBlank(httpsUser)) {
                commandList.add("-Dhttps.proxyUser=" + httpsUser);
                if (StringUtils.isNotBlank(httpsPassword)) {
                    commandList.add("-Dhttps.proxyPassword=" + httpsPassword);
                }
            }
            if (StringUtils.isNotBlank(httpsNonProxyHosts)) {
                commandList.add("-Dhttps.nonProxyHosts=" + httpsNonProxyHosts);
            }
        }
        String socksProxyHost = System.getProperty("socksProxyHost");
        String socksProxyPort = System.getProperty("socksProxyPort");
        if (StringUtils.isNotBlank(socksProxyHost) && StringUtils.isNotBlank(socksProxyPort)) {
            String socksProxyPassword;
            String socksProxyUser = System.getProperty("socksProxyUser");
            if (socksProxyUser == null) {
                socksProxyUser = System.getProperty("java.net.socks.username");
            }
            if ((socksProxyPassword = System.getProperty("socksProxyPassword")) == null) {
                socksProxyPassword = System.getProperty("java.net.socks.password");
            }
            commandList.add("-DsocksProxyHost=" + socksProxyHost);
            commandList.add("-DsocksProxyPort=" + socksProxyPort);
            if (StringUtils.isNotBlank(socksProxyUser)) {
                commandList.add("-DsocksProxyUser=" + socksProxyUser);
                if (StringUtils.isNotBlank(socksProxyPassword)) {
                    commandList.add("-DsocksProxyPassword=" + socksProxyPassword);
                }
            }
        }
        commandList.add("-Dtalend.studio.proxy.applySystemProps=true");
    }

    private void addCiBuilderVersion(List<String> commandList) {
        PluginDescriptor desc = (PluginDescriptor)this.mojo.getPluginContext().get("pluginDescriptor");
        if (desc != null && desc.getVersion() != null) {
            String builder_version = desc.getVersion();
            commandList.add("-Dci.builder.version=" + builder_version);
        }
    }

    protected boolean needJavaInternalAccess() {
        return true;
    }

    void addAdditionalProperties(String propertyGroup, List<String> commandList) {
        if (propertyGroup != null && propertyGroup.length() > 0) {
            Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(propertyGroup);
            while (m.find()) {
                commandList.add(m.group(1));
            }
            if (this.needJavaInternalAccess()) {
                Constants.JAVA17_ARGS.forEach(java17Arg -> commandList.add((String)java17Arg));
            }
            this.addCiBuilderVersion(commandList);
        }
    }

    void addArrangedProperties(String prefix, boolean removePrefix, List<String> commandList) {
        String prefixField = prefix + ".";
        this.mojo.session.getUserProperties().entrySet().stream().filter(e -> e.getKey().toString().startsWith(prefixField)).filter(e -> !JobBuilder.EXCLUDE_PROPERTIES.contains(e.getKey().toString())).forEach(e -> commandList.add("-D" + (removePrefix ? StringUtils.substringAfter(e.getKey().toString(), prefixField) : e.getKey().toString()) + "=" + e.getValue()));
    }

    void initLogFile() throws MojoFailureException {
        try {
            File logFile = new File(this.mojo.commandlineWorkspace + "/ci-builder.log");
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            if (logFile.length() > 0xA00000L) {
                logFile.delete();
                logFile.createNewFile();
            }
            this.logWriter = new FileWriter(logFile, true);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to init log file.", (Throwable)e);
        }
    }

    static enum Result {
        SUCCESS,
        SKIPPED;

    }

    class RuntimeExecutor {
        private static final String LOG_ERROR = "ERROR";
        private static final String LOG_OUTPUT = "OUTPUT";
        private static final int EXIT_OK = 0;
        private static final int EXIT_CI_RESTART = 191;
        private Process process;
        private List<String> command;
        private Map<String, ERuntimeError> errorsToCheck;

        RuntimeExecutor(Run runner) throws MojoFailureException {
            this.command = runner.getExecutionCommand();
            this.errorsToCheck = runner.getErrorsToCheck().stream().collect(Collectors.toMap(ERuntimeError::getOriginalError, Function.identity()));
        }

        int exec() {
            if (this.command != null && !this.command.isEmpty()) {
                try {
                    Run.this.logger.info((CharSequence)"");
                    ArrayList<String> logCmd = new ArrayList<String>(this.command);
                    try {
                        for (int i = 0; i < logCmd.size(); ++i) {
                            String cmd = (String)logCmd.get(i);
                            if (!cmd.contains("-Dhttp.proxyPassword=") && !cmd.contains("-Dhttps.proxyPassword=") && !cmd.contains("-DsocksProxyPassword=") && !cmd.contains("-Djava.net.socks.password=")) continue;
                            logCmd.set(i, cmd.split("=")[0] + "=***");
                        }
                    }
                    catch (Throwable e) {
                        Run.this.logger.error(e);
                    }
                    Run.this.logger.info((CharSequence)("Exec " + String.join((CharSequence)" ", logCmd)));
                    this.process = Runtime.getRuntime().exec(this.command.toArray(new String[0]), null, Run.this.getExecDir());
                    new Thread(() -> this.run(this.process.getErrorStream(), LOG_ERROR)).start();
                    new Thread(() -> this.run(this.process.getInputStream(), LOG_OUTPUT)).start();
                    int returnValue = this.process.waitFor();
                    if (returnValue != 0 && returnValue != 191) {
                        this.process = null;
                        this.exit();
                    }
                    return returnValue;
                }
                catch (Exception e) {
                    Run.this.logger.error((Throwable)e);
                }
            }
            return -1;
        }

        private void run(InputStream in, String type) {
            try {
                Long tick = null;
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String line = null;
                while ((line = br.readLine()) != null) {
                    tick = this.checkErrors(line, tick);
                    switch (type) {
                        case "OUTPUT": {
                            Run.this.logger.info((CharSequence)line.replace("[INFO]", ""));
                            break;
                        }
                        case "ERROR": {
                            Run.this.logger.error((CharSequence)line.replace("[ERROR]", ""));
                        }
                    }
                    if (Run.this.logWriter == null) continue;
                    Run.this.logWriter.write(type + ">" + line + Constants.LINE);
                    Run.this.logWriter.flush();
                }
            }
            catch (IOException e) {
                Run.this.logger.error((Throwable)e);
            }
        }

        private Long checkErrors(String line, Long tick) {
            ERuntimeError error;
            if (this.errorsToCheck == null || this.errorsToCheck.isEmpty()) {
                return null;
            }
            if (tick == null && (error = this.errorsToCheck.get(line)) != null) {
                if (!error.isDelay()) {
                    Run.this.logger.error((CharSequence)(error.getFriendlyError() != null ? error.getFriendlyError() : error.getOriginalError()));
                    this.exit();
                }
                Long start = tick = Long.valueOf(System.currentTimeMillis());
                new Thread(() -> {
                    while (true) {
                        if (System.currentTimeMillis() - start <= 2000L) {
                            continue;
                        }
                        this.exit();
                    }
                }).start();
                return tick;
            }
            return null;
        }

        List<String> getCommand() {
            return this.command;
        }

        private void exit() {
            if (this.process != null && this.process.isAlive()) {
                Run.this.logger.info((CharSequence)"Terminating sub process...");
                this.process.destroy();
            }
            Run.this.logger.info((CharSequence)"A fatal error has occured, exiting...");
            System.exit(1);
        }
    }
}

