/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.string;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.talend.utils.sugars.ReturnCode;

public final class StringUtilities {
    private StringUtilities() {
    }

    public static List<String> tokenize(String input, String delimiters) {
        ArrayList<String> stringArray = new ArrayList<String>();
        if (input == null) {
            return stringArray;
        }
        if (delimiters == null) {
            return stringArray;
        }
        StringTokenizer t = new StringTokenizer(input, delimiters);
        while (t.hasMoreTokens()) {
            stringArray.add(t.nextToken());
        }
        return stringArray;
    }

    public static ReturnCode checkBalancedParenthesis(String input, char openingBlock, char closingBlock) {
        int i;
        int level = 0;
        for (i = 0; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (currentChar == openingBlock) {
                ++level;
            } else if (currentChar == closingBlock) {
                --level;
            }
            if (level >= 0) continue;
            return new ReturnCode("too many " + closingBlock + " at position " + i, false);
        }
        if (level < 0) {
            return new ReturnCode("too many " + closingBlock + " at position " + i, false);
        }
        if (level > 0) {
            return new ReturnCode("too many " + openingBlock + " at position " + i, false);
        }
        return new ReturnCode();
    }

    public static String getRandomString(int length) {
        String str = "abcdefghigklmnopkrstuvwxyzABCDEFGHIGKLMNOPQRSTUVWXYZ0123456789";
        SecureRandom random = new SecureRandom();
        StringBuilder sf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(str.length());
            sf.append(str.charAt(number));
        }
        return sf.toString();
    }

    public static String removeEndingString(String fullStr, String endingStr) {
        String newStr = fullStr;
        while (0 < newStr.length() && newStr.endsWith(endingStr)) {
            newStr = newStr.substring(0, newStr.length() - endingStr.length());
        }
        return newStr;
    }

    public static String removeStartingString(String fullStr, String startingStr) {
        String newStr = fullStr;
        while (0 < newStr.length() && newStr.startsWith(startingStr)) {
            newStr = newStr.substring(startingStr.length());
        }
        return newStr;
    }
}

