/*
 * Decompiled with CFR 0.152.
 */
package uniserv.cliserv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import uniserv.cliserv.GatewayBufferedReader;
import uniserv.cliserv.GatewayInternalException;
import uniserv.cliserv.NoSuchArgException;
import uniserv.cliserv.Uniresult;

public class GenClient {
    private Socket gatewayConnection = null;
    private PrintWriter out = null;
    private GatewayBufferedReader in = null;
    private InputStream is = null;
    private int session = 0;
    private Vector<String> arguments;
    private boolean debug = false;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    private String version = "R2.2.0 V000";
    private int ignoreUnknownArguments = 0;
    private Logger logger = Logger.getLogger("uniserv.cliserv");
    public static final int IGNORE_UNKNOWN_ARGUMENTS = 1;
    public static final int UNISTR = 0;
    public static final int UNICSTR = 1;
    public static final int UNILONG = 2;
    public static final int UNISHORT = 3;
    public static final int UNIBYTE = 4;
    public static final int UNIABS = 0;
    public static final int UNIREL = 1;
    public static final int UNI_OK = 0;
    public static final int UNI_ERR = 1;
    public static final int UNI_WARN = 2;
    public static final int UNI_BREAK = 3;
    public static final int UNI_MSG = 4;
    public static final int UNIRESULT_S_FLAG = 1;
    public static final int UNI_FALSE = 0;
    public static final int UNI_TRUE = 1;
    public static final int UNI_FIRST = 0;
    public static final int UNI_NEXT = 1;
    public static final String PAR_CONV_UPPER = "par_conv_upper";
    public static final String PAR_CONV_SPECIAL = "par_conv_special";
    public static final String PAR_CONV_ALNUM = "par_conv_alnum";
    public static final int UNI_NO_ERROR = 0;
    public static final int UNI_INVALID_SESSION_HANDLE = 1;
    public static final int UNI_INVALID_REQUEST_HANDLE = 2;
    public static final int UNI_INVALID_STATE = 3;
    public static final int UNI_INVALID_ADDRESS = 4;
    public static final int UNI_INVALID_OPEN_ARG = 10;
    public static final int UNI_NO_SERVICE_NAME = 11;
    public static final int UNI_MULTIPLE_SERVICE_NAME = 12;
    public static final int UNI_MULTIPLE_SERVICEHOST_NAME = 13;
    public static final int UNI_NO_SERVICEHOST_NAME = 14;
    public static final int UNI_INVALID_SERVICE_NAME = 15;
    public static final int UNI_SERVER_INIT_ERROR = 16;
    public static final int UNI_MULTIPLE_SUFFIX_NAME = 17;
    public static final int UNI_INVALID_PARAM = 20;
    public static final int UNI_INVALID_ARG = 21;
    public static final int UNI_INVALID_VALUE = 22;
    public static final int UNI_NOT_ENOUGH_SPACE = 23;
    public static final int UNI_INVALID_DATA_TYPE = 24;
    public static final int UNI_INVALID_UNICSTR = 25;
    public static final int UNI_INVALID_PARAM_TYPE = 26;
    public static final int UNI_INVALID_LENGTH = 27;
    public static final int UNI_INVALID_ARG_HANDLE = 28;
    public static final int UNI_LONG_VALUE_TOO_LARGE = 29;
    public static final int UNI_INVALID_MODE = 30;
    public static final int UNI_INVALID_CURSOR_POS = 31;
    public static final int UNI_UNKNOWN_LANGUAGE = 40;
    public static final int UNI_UNKNOWN_ERRORINFO = 41;
    public static final int UNI_INVALID_REQUEST = 42;
    public static final int UNI_OPEN_REQUESTS = 43;
    public static final int UNI_SERVICE_UNKNOWN = 50;
    public static final int UNI_HOSTNAME_UNKNOWN = 51;
    public static final int UNI_SERVER_NOT_RESPONDING = 52;
    public static final int UNI_LSERV_SERVICE_UNKNOWN = 53;
    public static final int UNI_LSERV_ENV_NOT_FOUND = 54;
    public static final int UNI_LSERV_HOSTNAME_UNKNOWN = 55;
    public static final int UNI_LSERV_NOT_RESPONDING = 56;
    public static final int UNI_INVALID_WINSOCK_DLL = 57;
    public static final int UNI_CONFIG_FILE_NOT_FOUND = 58;
    public static final int UNI_INCOMPATIBLE_RELEASE = 59;
    public static final int UNI_INCOMPATIBLE_VERSION = 59;
    public static final int UNI_PATH_ENV_NOT_FOUND = 60;
    public static final int UNI_NO_LICENSE = 70;
    public static final int UNI_LICENSE_FILE_NOT_FOUND = 71;
    public static final int UNI_LICENSE_INFO_NOT_AVAILABLE = 72;
    public static final int UNI_CHECKSUM_ERROR = 73;
    public static final int UNI_LICENSE_EXPIRED = 74;
    public static final int UNI_LICENSE_ENV_VAR_NOT_FOUND = 75;
    public static final int UNI_LICENSE_FILE_SYNTAX_ERROR = 76;
    public static final int UNI_LICENSE_SECTION_NOT_FOUND = 77;
    public static final int UNI_DEMO_LICENSE_EXPIRED = 78;
    public static final int UNI_SYSTEM_TIME_CHANGED = 79;
    public static final int UNI_NO_MEMORY = 100;
    public static final int UNI_CLIENT_SERVER_OUT_OF_SYNC = 101;
    public static final int UNI_WSASTARTUP_ERROR = 102;
    public static final int UNI_COMPRESS_ERROR = 103;
    public static final int UNI_DECOMPRESS_ERROR = 104;
    public static final int UNI_SOCKET_CREATE_ERROR = 110;
    public static final int UNI_SOCKET_ACCEPT_ERROR = 111;
    public static final int UNI_SOCKET_SELECT_ERROR = 112;
    public static final int UNI_SOCKET_LISTEN_ERROR = 113;
    public static final int UNI_SOCKET_READ_ERROR = 114;
    public static final int UNI_SOCKET_WRITE_ERROR = 115;
    public static final int UNI_SOCKET_BIND_ERROR = 116;
    public static final int UNI_SOCKET_CLOSE_ERROR = 117;
    public static final int UNI_WRITE_ERROR = 122;
    public static final int UNI_READ_ERROR = 123;
    public static final int UNI_LSERV_CONNECT_ERROR = 130;
    public static final int UNI_LSERV_WRITE_ERROR = 131;
    public static final int UNI_LSERV_READ_ERROR = 132;
    public static final int UNI_LSERV_SOCKET_CLOSE_ERROR = 133;
    public static final int UNI_PACKET_TOO_LARGE = 140;
    public static final int UNI_NO_PACKET_SPACE = 141;
    public static final int UNI_SERVER_ALREADY_ACTIVE = 142;
    public static final int UNI_SOCKET_TIMEOUT_ERROR = 143;
    public static final int UNI_NO_SERVICES_STARTED = 144;
    public static final int UNI_NO_VALID_LICENSES = 145;
    public static final int UNI_REGISTRY_ERROR = 146;
    public static final int UNI_CONVERT_TABLE_OPEN_ERROR = 150;
    public static final int UNI_INVALID_CONVTAB_SYNTAX = 151;
    public static final int UNI_END_OF_LIST = 900;
    public static final int UNI_INVALID_FIRST_NEXT = 901;
    public static final int UNI_INVALID_REQUEST_SELECTION = 902;
    public static final int UNI_INVALID_IN_OUT_ARG = 903;
    public static final int UNI_INVALID_COMPONENT_NAME = 904;
    public static final int END_OF_LIST = -1;
    public static final int MIN_CS_ERROR_NUMBER = 0;
    public static final int MAX_CS_ERROR_NUMBER = 999;
    public static final int INVALID_FUNCTION = 7201;
    public static final int INVALID_ARG_LIST = 7202;
    public static final int ARG_TABLE_OVERFLOW = 7203;
    public static final int INVALID_SESSION_ID = 7205;
    public static final int MISSING_REQUST_TYPE = 7206;
    public static final int INVALID_ARGUMENT = 7207;
    public static final int REQUEST_UNKNOWN = 7209;

    public GenClient() {
        this.debug = false;
        this.ignoreUnknownArguments = 0;
    }

    public GenClient(boolean debugOn) {
        this.debug = debugOn;
    }

    public GenClient(int ignoreUnknownArguments) {
        this.ignoreUnknownArguments = ignoreUnknownArguments == 1 ? ignoreUnknownArguments : 0;
    }

    private void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    private void parseOpenResult(String result, Uniresult uniresult) throws GatewayInternalException {
        int index1 = result.indexOf(";");
        if (index1 == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;session=;");
        }
        int indextmp = result.indexOf("=");
        if (indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;session=;");
        }
        uniresult.setRetType(new Integer(result.substring(indextmp + 1, index1)));
        int index2 = result.indexOf(";", index1 + 1);
        if (index2 == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;session=;");
        }
        indextmp = result.indexOf("=", index1 + 1);
        if (indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;session=;");
        }
        uniresult.setRetInfo(new Integer(result.substring(indextmp + 1, index2)));
        if (uniresult.getRetType() != 1) {
            int index3 = result.indexOf(";", index2 + 1);
            if (index3 == -1) {
                throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;session=;");
            }
            indextmp = result.indexOf("=", index2 + 1);
            if (indextmp == -1) {
                throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;session=;");
            }
            this.session = new Integer(result.substring(indextmp + 1, index3));
        } else {
            this.session = 0;
        }
        this.arguments = new Vector();
    }

    private void parseExceResult(String result, Uniresult uniresult) throws GatewayInternalException {
        int index1 = result.indexOf(";");
        if (index1 == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;count=;");
        }
        int indextmp = result.indexOf("=");
        if (indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;count=;");
        }
        uniresult.setRetType(new Integer(result.substring(indextmp + 1, index1)));
        int index2 = result.indexOf(";", index1 + 1);
        if (index2 == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;count=;");
        }
        indextmp = result.indexOf("=", index1 + 1);
        if (indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;count=;");
        }
        uniresult.setRetInfo(new Integer(result.substring(indextmp + 1, index2)));
        if (uniresult.getRetType() != 1) {
            int index3 = result.indexOf(";", index2 + 1);
            if (index3 == -1) {
                throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;count=;");
            }
            indextmp = result.indexOf("=", index2 + 1);
            if (indextmp == -1) {
                throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;count=;");
            }
            uniresult.setRetCount(new Integer(result.substring(indextmp + 1, index3)));
        }
        this.arguments.removeAllElements();
    }

    private void parseGetArgResult(String oresult, Uniresult uniresult, StringBuffer value) throws NoSuchArgException, GatewayInternalException {
        String result = this.dequote(oresult);
        int index1 = result.indexOf(";");
        int indextmp = result.indexOf("=");
        if (index1 == -1 || indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;arg=;");
        }
        uniresult.setRetType(new Integer(result.substring(indextmp + 1, index1)));
        int index2 = result.indexOf(";", index1 + 1);
        indextmp = result.indexOf("=", index1 + 1);
        if (index2 == -1 || indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;arg=;");
        }
        uniresult.setRetInfo(new Integer(result.substring(indextmp + 1, index2)));
        if (uniresult.getRetInfo() == 21) {
            int index3 = result.indexOf(";", index2 + 1);
            indextmp = result.indexOf("=", index2 + 1);
            if (index3 == -1 || indextmp == -1) {
                throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;ret_arg=");
            }
            throw new NoSuchArgException(result.substring(indextmp + 1, index3));
        }
        if (uniresult.getRetType() != 1) {
            int index3 = result.indexOf(";", index2 + 1);
            indextmp = result.indexOf("=", index2 + 1);
            if (index3 == -1 || indextmp == -1) {
                throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;arg=;");
            }
            value.setLength(0);
            value.append(result.substring(indextmp + 1, index3).replace('\u0080', ';').replace('{', '\n').replace('\u0081', '{'));
            if (this.ignoreUnknownArguments == 1 && "?!?".equals(value.toString())) {
                value.setLength(0);
                value.append("");
            }
        }
    }

    private void parseGetArgsResult(String oresult, Uniresult uniresult, Hashtable<String, String> yourResult) throws NoSuchArgException, GatewayInternalException {
        String result = this.dequote(oresult);
        int index1 = result.indexOf(";");
        int indextmp = result.indexOf("=");
        if (index1 == -1 || indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;arg=;");
        }
        uniresult.setRetType(new Integer(result.substring(indextmp + 1, index1)));
        int index2 = result.indexOf(";", index1 + 1);
        indextmp = result.indexOf("=", index1 + 1);
        if (index2 == -1 || indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;arg=;");
        }
        uniresult.setRetInfo(new Integer(result.substring(indextmp + 1, index2)));
        if (uniresult.getRetInfo() == 21) {
            int index3 = result.indexOf(";", index2 + 1);
            indextmp = result.indexOf("=", index2 + 1);
            if (index3 == -1 || indextmp == -1) {
                throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;ret_arg=");
            }
            throw new NoSuchArgException(result.substring(indextmp + 1, index3));
        }
        if (uniresult.getRetType() != 1) {
            yourResult.clear();
            int index3 = result.indexOf(";", index2 + 1);
            while (index3 != -1) {
                indextmp = result.indexOf("=", index2 + 1);
                if (indextmp == -1) {
                    throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;arg=;");
                }
                String tmparg = result.substring(index2 + 1, indextmp);
                String arg = tmparg.substring(1);
                String value = result.substring(indextmp + 1, index3).replace('\u0080', ';').replace('{', '\n').replace('\u0081', '{');
                if (this.ignoreUnknownArguments == 1 && "?!?".equals(value)) {
                    value = "";
                }
                yourResult.put(arg, value);
                index2 = index3;
                index3 = result.indexOf(";", index2 + 1);
            }
        }
    }

    private void parseGetAllArgsResult(String oresult, Uniresult uniresult, Hashtable<String, String>[] yourResult) throws NoSuchArgException, GatewayInternalException {
        String result = this.dequote(oresult);
        int index1 = result.indexOf(";");
        int indextmp = result.indexOf("=");
        if (index1 == -1 || indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;arg=;");
        }
        uniresult.setRetType(new Integer(result.substring(indextmp + 1, index1)));
        int index2 = result.indexOf(";", index1 + 1);
        indextmp = result.indexOf("=", index1 + 1);
        if (index2 == -1 || indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;arg=;");
        }
        uniresult.setRetInfo(new Integer(result.substring(indextmp + 1, index2)));
        if (uniresult.getRetInfo() == 21) {
            int index3 = result.indexOf(";", index2 + 1);
            indextmp = result.indexOf("=", index2 + 1);
            if (index3 == -1 || indextmp == -1) {
                throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;ret_arg=");
            }
            throw new NoSuchArgException(result.substring(indextmp + 1, index3));
        }
        if (uniresult.getRetType() != 1) {
            int index3 = result.indexOf(";", index2 + 1);
            indextmp = result.indexOf("=", index2 + 1);
            if (index3 == -1 || indextmp == -1) {
                throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;fields=;arg=;");
            }
            int field = new Integer(result.substring(indextmp + 1, index3));
            int index4 = result.indexOf(";", index3 + 1);
            yourResult[0] = new Hashtable();
            int i = 0;
            int j = 0;
            while (index4 != -1) {
                indextmp = result.indexOf("=", index3 + 1);
                if (indextmp == -1) {
                    throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;arg=;");
                }
                String tmparg = result.substring(index3 + 1, indextmp);
                String arg = tmparg.substring(1);
                String value = result.substring(indextmp + 1, index4).replace('\u0080', ';').replace('{', '\n').replace('\u0081', '{');
                if (this.ignoreUnknownArguments == 1 && "?!?".equals(value)) {
                    value = "";
                }
                yourResult[i].put(arg, value);
                index3 = index4;
                index4 = result.indexOf(";", index3 + 1);
                if (++j != field) continue;
                j = 0;
                if (yourResult.length <= ++i) break;
                yourResult[i] = new Hashtable();
            }
        }
    }

    private void parseSimpleResult(String result, Uniresult uniresult) throws GatewayInternalException {
        int index1 = result.indexOf(";");
        if (index1 == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;");
        }
        int indextmp = result.indexOf("=");
        if (indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;");
        }
        uniresult.setRetType(new Integer(result.substring(indextmp + 1, index1)));
        int index2 = result.indexOf(";", index1 + 1);
        if (index2 == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;");
        }
        indextmp = result.indexOf("=", index1 + 1);
        if (indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;");
        }
        uniresult.setRetInfo(new Integer(result.substring(indextmp + 1, index2)));
    }

    private void parseLicenseResult(String oresult, Uniresult uniresult, StringBuffer license) throws GatewayInternalException {
        String result = this.dequote(oresult);
        int index1 = result.indexOf(";");
        int indextmp = result.indexOf("=");
        if (index1 == -1 || indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;license=;");
        }
        uniresult.setRetType(new Integer(result.substring(indextmp + 1, index1)));
        int index2 = result.indexOf(";", index1 + 1);
        indextmp = result.indexOf("=", index1 + 1);
        if (index2 == -1 || indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;license=;");
        }
        uniresult.setRetInfo(new Integer(result.substring(indextmp + 1, index2)));
        if (uniresult.getRetType() != 1) {
            int index3 = result.indexOf(";", index2 + 1);
            indextmp = result.indexOf("=", index2 + 1);
            if (index3 == -1 || indextmp == -1) {
                throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;license=;");
            }
            license.setLength(0);
            license.append(result.substring(indextmp + 1, index3).replace('\u0080', ';').replace('{', '\n'));
        }
        if (uniresult.getRetType() == 1 && uniresult.getRetInfo() == 7201) {
            throw new GatewayInternalException("Version missmatch. The serevr side should be updated to the version 1.23-002.\nThis server does not support the functions getLicence and getErrorMsg properly.");
        }
    }

    private void parseVersionResult(String oresult, Uniresult uniresult, StringBuffer versionNr, StringBuffer version) throws GatewayInternalException {
        String result = this.dequote(oresult);
        int index1 = result.indexOf(";");
        int indextmp = result.indexOf("=");
        if (index1 == -1 || indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;nr=;str=;");
        }
        uniresult.setRetType(new Integer(result.substring(indextmp + 1, index1)));
        int index2 = result.indexOf(";", index1 + 1);
        indextmp = result.indexOf("=", index1 + 1);
        if (index2 == -1 || indextmp == -1) {
            throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;nr=;str=;");
        }
        uniresult.setRetInfo(new Integer(result.substring(indextmp + 1, index2)));
        if (uniresult.getRetType() != 1) {
            int index3 = result.indexOf(";", index2 + 1);
            indextmp = result.indexOf("=", index2 + 1);
            if (index3 == -1 || indextmp == -1) {
                throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;nr=;str=;");
            }
            versionNr.setLength(0);
            versionNr.append(result.substring(indextmp + 1, index3).replace('\u0080', ';').replace('{', '\n'));
            int index4 = result.indexOf(";", index3 + 1);
            indextmp = result.indexOf("=", index3 + 1);
            if (index4 == -1 || indextmp == -1) {
                throw new GatewayInternalException("Got:" + result + "Expected:type=;info=;nr=;str=;");
            }
            version.setLength(0);
            version.append("Java Interface ").append(this.version).append("\n");
            version.append(result.substring(indextmp + 1, index4).replace('\u0080', ';').replace('{', '\n'));
        }
    }

    /*
     * Unable to fully structure code
     */
    private String quote(String s) {
        block4: {
            try {
                myString = s.replace("\\", "\\\\").replace("\n", "\\\n").replace(";", "\\;");
                break block4;
            }
            catch (NoSuchMethodError e) {
                sb = new StringBuffer();
                i = 0;
                ** while (i < s.length())
            }
lbl-1000:
            // 1 sources

            {
                if (s.charAt(i) == ';' || s.charAt(i) == '\n' || s.charAt(i) == '\\') {
                    sb.append('\\');
                }
                sb.append(s.charAt(i));
                ++i;
                continue;
            }
lbl15:
            // 1 sources

            myString = sb.toString();
        }
        return myString;
    }

    /*
     * Unable to fully structure code
     */
    private String dequote(String s) {
        block10: {
            try {
                myString = s.replace("\\;", "\u0080").replace("\\{", "\u0081").replace("\\\\", "\\");
                break block10;
            }
            catch (NoSuchMethodError e) {
                index = s.indexOf("\\");
                if (index == -1) {
                    return s;
                }
                myString = s.substring(0, index);
                i = index;
                ** while (i < s.length())
            }
lbl-1000:
            // 1 sources

            {
                if (s.charAt(i) == '\\' && s.charAt(i + 1) == ';') {
                    myString = String.valueOf(myString) + '\u0080';
                    ++i;
                } else if (s.charAt(i) == '\\' && s.charAt(i + 1) == '{') {
                    myString = String.valueOf(myString) + '\u0081';
                    ++i;
                } else if (s.charAt(i) == '\\' && s.charAt(i + 1) == '\\') {
                    myString = String.valueOf(myString) + '\\';
                    ++i;
                } else {
                    myString = String.valueOf(myString) + s.charAt(i);
                }
                ++i;
                continue;
            }
        }
        return myString;
    }

    public Uniresult open(String host, int port, String service) throws IOException, GatewayInternalException {
        String fromServer;
        String toSend;
        Uniresult uniresult = new Uniresult();
        String envBatchUser = System.getenv("UNISERV_BATCH_USER");
        if (envBatchUser != null && "1".equals(envBatchUser)) {
            return this.open(host, port, service, true);
        }
        try {
            if (this.session != 0) {
                this.close();
            }
        }
        catch (IOException e) {
            this.logger.log(Level.INFO, "open: there was already one opened session; but no valid TCP/IP connection;close of the old session failed.");
        }
        this.gatewayConnection = new Socket(host, port);
        if (this.readTimeout != -1) {
            this.gatewayConnection.setSoTimeout(this.readTimeout);
        }
        this.out = new PrintWriter((Writer)new OutputStreamWriter(this.gatewayConnection.getOutputStream(), "UTF-8"), true);
        this.in = new GatewayBufferedReader(new InputStreamReader(this.gatewayConnection.getInputStream(), "UTF-8"));
        if (service.indexOf(".") == -1) {
            toSend = "open:service=" + this.quote(service) + ";servicehost=localhost\n";
        } else {
            String realService = service.substring(0, service.indexOf("."));
            String suffix = service.substring(service.indexOf(".") + 1, service.length());
            toSend = "open:service=" + this.quote(realService) + ";servicehost=localhost;suffix=" + this.quote(suffix) + "\n";
        }
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "open: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?!");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        this.parseOpenResult(fromServer, uniresult);
        if (uniresult.getRetType() == 0) {
            this.logger.log(Level.INFO, "open: connected to host: " + host + " port: " + port + " service: " + service + "; server session id: " + this.session);
        } else {
            this.logger.log(Level.SEVERE, "open failed: host: " + host + " port: " + port + " service: " + service + "; retType: " + uniresult.getRetType() + " retInfo: " + uniresult.getRetInfo());
        }
        return uniresult;
    }

    public Uniresult open(String host, int port, String service, boolean batch) throws IOException, GatewayInternalException {
        String fromServer;
        String toSend;
        Uniresult uniresult = new Uniresult();
        try {
            if (this.session != 0) {
                this.close();
            }
        }
        catch (IOException e) {
            this.logger.log(Level.INFO, "open: there was already one opened session; but no valid TCP/IP connection;close of the old session failed.");
        }
        this.gatewayConnection = new Socket(host, port);
        if (this.readTimeout != -1) {
            this.gatewayConnection.setSoTimeout(this.readTimeout);
        }
        this.out = new PrintWriter((Writer)new OutputStreamWriter(this.gatewayConnection.getOutputStream(), "UTF-8"), true);
        this.in = new GatewayBufferedReader(new InputStreamReader(this.gatewayConnection.getInputStream(), "UTF-8"));
        if (service.indexOf(".") == -1) {
            toSend = "open:service=" + this.quote(service) + ";servicehost=localhost";
        } else {
            String realService = service.substring(0, service.indexOf("."));
            String suffix = service.substring(service.indexOf(".") + 1, service.length());
            toSend = "open:service=" + this.quote(realService) + ";servicehost=localhost;suffix=" + this.quote(suffix);
        }
        if (batch) {
            toSend = String.valueOf(toSend) + ";batch=yes";
        }
        toSend = String.valueOf(toSend) + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "open: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?!");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        this.parseOpenResult(fromServer, uniresult);
        if (uniresult.getRetType() == 0) {
            if (batch) {
                this.logger.log(Level.INFO, "open (batch-mode): connected to host: " + host + " port: " + port + " service: " + service + "; server session id: " + this.session);
            } else {
                this.logger.log(Level.INFO, "open: connected to host: " + host + " port: " + port + " service: " + service + "; server session id: " + this.session);
            }
        } else if (batch) {
            this.logger.log(Level.SEVERE, "open (batch-mode) failed: host: " + host + " port: " + port + " service: " + service + "; retType: " + uniresult.getRetType() + " retInfo: " + uniresult.getRetInfo());
        } else {
            this.logger.log(Level.SEVERE, "open failed: host: " + host + " port: " + port + " service: " + service + "; retType: " + uniresult.getRetType() + " retInfo: " + uniresult.getRetInfo());
        }
        return uniresult;
    }

    public void close() throws IOException {
        String fromServer;
        String toSend = "close:session=" + this.session + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "close: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        toSend = "disconnect\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        this.out.close();
        this.in.close();
        this.gatewayConnection.close();
        this.logger.log(Level.INFO, "TCP/IP connection and server session (" + this.session + ") closed");
        this.session = 0;
    }

    public Uniresult commit() throws IOException, GatewayInternalException {
        String fromServer;
        String toSend = "commit:session=" + this.session + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "commit: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        Uniresult uniresult = new Uniresult();
        this.parseSimpleResult(fromServer, uniresult);
        return uniresult;
    }

    public Uniresult rollback() throws IOException, GatewayInternalException {
        String fromServer;
        Uniresult uniresult = new Uniresult();
        String toSend = "rollback:session=" + this.session + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "rollback: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        this.parseSimpleResult(fromServer, uniresult);
        return uniresult;
    }

    public Uniresult prepare() throws IOException, GatewayInternalException {
        String fromServer;
        Uniresult uniresult = new Uniresult();
        String toSend = "prepare:session=" + this.session + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "prepare: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        this.parseSimpleResult(fromServer, uniresult);
        return uniresult;
    }

    public void setArg(String arg, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        StringBuffer sb = arg.startsWith("par_") ? new StringBuffer().append(arg).append("=").append(this.quote(value)) : new StringBuffer().append("u").append(arg).append("=").append(this.quote(value));
        this.arguments.addElement(sb.toString());
    }

    public void setArg(Hashtable<String, String> h) {
        StringBuffer sb = new StringBuffer();
        Enumeration<String> e = h.keys();
        while (e.hasMoreElements()) {
            String arg = e.nextElement();
            String value = h.get(arg);
            if (value == null || value.length() == 0) continue;
            if (arg.startsWith("par_")) {
                sb.append(arg).append("=").append(this.quote(value));
            } else {
                sb.append("u").append(arg).append("=").append(this.quote(value));
            }
            this.arguments.addElement(sb.toString());
            sb.delete(0, sb.length());
        }
    }

    public Uniresult getArg(String arg, StringBuffer value) throws NoSuchArgException, IOException, GatewayInternalException {
        String fromServer;
        Uniresult uniresult = new Uniresult();
        String toSend = "fetch:session=" + this.session;
        if (this.ignoreUnknownArguments == 1) {
            toSend = String.valueOf(toSend) + ";ignore_unknown=1";
        }
        toSend = String.valueOf(toSend) + ";u" + arg + "=?\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "getArg: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        this.parseGetArgResult(fromServer, uniresult, value);
        return uniresult;
    }

    public Uniresult getArg(String arg, StringBuffer value, int cursor) throws NoSuchArgException, IOException, GatewayInternalException {
        String fromServer;
        Uniresult uniresult = new Uniresult();
        String toSend = "fetch:session=" + this.session;
        if (this.ignoreUnknownArguments == 1) {
            toSend = String.valueOf(toSend) + ";ignore_unknown=1";
        }
        toSend = String.valueOf(toSend) + ";u" + arg + "=?;cursor=" + cursor + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "getArg: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        this.parseGetArgResult(fromServer, uniresult, value);
        return uniresult;
    }

    public Uniresult getArg(Vector<String> v, Hashtable<String, String> h) throws NoSuchArgException, IOException, GatewayInternalException {
        String fromServer;
        Uniresult uniresult = new Uniresult();
        String toSend = "fetch:session=" + this.session;
        if (this.ignoreUnknownArguments == 1) {
            toSend = String.valueOf(toSend) + ";ignore_unknown=1";
        }
        Enumeration<String> e = v.elements();
        while (e.hasMoreElements()) {
            toSend = String.valueOf(toSend) + ";u";
            String arg = e.nextElement();
            toSend = String.valueOf(toSend) + arg + "=?";
        }
        toSend = String.valueOf(toSend) + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "getArg: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        this.parseGetArgsResult(fromServer, uniresult, h);
        return uniresult;
    }

    public Uniresult getArg(Vector<String> v, Hashtable<String, String> h, int cursor) throws NoSuchArgException, IOException, GatewayInternalException {
        String fromServer;
        Uniresult uniresult = new Uniresult();
        String toSend = "fetch:session=" + this.session;
        if (this.ignoreUnknownArguments == 1) {
            toSend = String.valueOf(toSend) + ";ignore_unknown=1";
        }
        Enumeration<String> e = v.elements();
        while (e.hasMoreElements()) {
            toSend = String.valueOf(toSend) + ";u";
            String arg = e.nextElement();
            toSend = String.valueOf(toSend) + arg + "=?";
        }
        toSend = String.valueOf(toSend) + ";cursor=" + cursor + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "getArg: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        this.parseGetArgsResult(fromServer, uniresult, h);
        return uniresult;
    }

    public Uniresult getAllArgList(Vector<String> v, Hashtable<String, String>[] h, int count) throws NoSuchArgException, IOException, GatewayInternalException {
        String fromServer;
        Uniresult uniresult = new Uniresult();
        String toSend = "fetch_all:session=" + this.session + ";count=" + count;
        if (this.ignoreUnknownArguments == 1) {
            toSend = String.valueOf(toSend) + ";ignore_unknown=1";
        }
        Enumeration<String> e = v.elements();
        while (e.hasMoreElements()) {
            toSend = String.valueOf(toSend) + ";u";
            String arg = e.nextElement();
            toSend = String.valueOf(toSend) + arg + "=?";
        }
        toSend = String.valueOf(toSend) + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "getAllArgList: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        this.parseGetAllArgsResult(fromServer, uniresult, h);
        return uniresult;
    }

    public Uniresult execRequest(String requestType) throws IOException, GatewayInternalException {
        String fromServer;
        String toSend = "exec:session=" + this.session + ";request_type=" + this.quote(requestType);
        if (this.ignoreUnknownArguments == 1) {
            toSend = String.valueOf(toSend) + ";ignore_unknown=1";
        }
        Enumeration<String> e = this.arguments.elements();
        while (e.hasMoreElements()) {
            toSend = String.valueOf(toSend) + ";";
            toSend = String.valueOf(toSend) + e.nextElement();
        }
        this.arguments.removeAllElements();
        toSend = String.valueOf(toSend) + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "execRequest: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        Uniresult uniresult = new Uniresult();
        this.parseExceResult(fromServer, uniresult);
        return uniresult;
    }

    public Uniresult execRequest(int inSelectPos) throws IOException, GatewayInternalException {
        String fromServer;
        String toSend = "exec:session=" + this.session + ";in_select_pos=" + inSelectPos + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "execRequest: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        Uniresult uniresult = new Uniresult();
        this.parseExceResult(fromServer, uniresult);
        return uniresult;
    }

    public Uniresult execRequest() throws IOException, GatewayInternalException {
        String fromServer;
        String toSend = "exec:session=" + this.session;
        if (this.ignoreUnknownArguments == 1) {
            toSend = String.valueOf(toSend) + ";ignore_unknown=1";
        }
        Enumeration<String> e = this.arguments.elements();
        while (e.hasMoreElements()) {
            toSend = String.valueOf(toSend) + ";";
            toSend = String.valueOf(toSend) + e.nextElement();
        }
        this.arguments.removeAllElements();
        toSend = String.valueOf(toSend) + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "execRequest: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        Uniresult uniresult = new Uniresult();
        this.parseExceResult(fromServer, uniresult);
        return uniresult;
    }

    public Uniresult getVersion(StringBuffer versionNr, StringBuffer version) throws IOException, GatewayInternalException {
        String fromServer;
        String toSend = "version:session=" + this.session + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "getVersion: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        Uniresult uniresult = new Uniresult();
        this.parseVersionResult(fromServer, uniresult, versionNr, version);
        return uniresult;
    }

    public Uniresult getLicense(StringBuffer license) throws IOException, GatewayInternalException {
        String fromServer;
        String toSend = "ulicense:session=" + this.session + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "getLicense: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        Uniresult uniresult = new Uniresult();
        try {
            this.parseLicenseResult(fromServer, uniresult, license);
        }
        catch (GatewayInternalException e) {
            uniresult = this.getISO8859License(license);
        }
        return uniresult;
    }

    private Uniresult getISO8859License(StringBuffer license) throws IOException, GatewayInternalException {
        Uniresult uniresult = new Uniresult();
        String toSend = "license:session=" + this.session + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        this.is = this.gatewayConnection.getInputStream();
        GatewayBufferedReader inIso8859_1 = new GatewayBufferedReader(new InputStreamReader(this.is, "ISO-8859-1"));
        String fromServer = inIso8859_1.readLine();
        if (fromServer == null) {
            this.logger.log(Level.SEVERE, "getLicense: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.is = this.gatewayConnection.getInputStream();
        this.in = new GatewayBufferedReader(new InputStreamReader(this.is, "UTF-8"));
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        this.parseLicenseResult(fromServer, uniresult, license);
        return uniresult;
    }

    public Uniresult getErrorMsg(int errorType, int errorInfo, String lang, StringBuffer msg) throws IOException, GatewayInternalException {
        String fromServer;
        String toSend = "uerror:session=" + this.session + ";type=" + errorType + ";info=" + errorInfo + ";lang=" + lang + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        if ((fromServer = this.in.readLine()) == null) {
            this.logger.log(Level.SEVERE, "getErrorMsg: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        Uniresult uniresult = new Uniresult();
        try {
            this.parseLicenseResult(fromServer, uniresult, msg);
        }
        catch (GatewayInternalException e) {
            uniresult = this.getISO8859ErrorMsg(errorType, errorInfo, lang, msg);
        }
        return uniresult;
    }

    private Uniresult getISO8859ErrorMsg(int errorType, int errorInfo, String lang, StringBuffer msg) throws IOException, GatewayInternalException {
        String toSend = "error:session=" + this.session + ";type=" + errorType + ";info=" + errorInfo + ";lang=" + lang + "\n";
        this.out.print(toSend);
        this.out.flush();
        this.logger.log(Level.FINE, "toSend: " + toSend);
        if (this.debug) {
            System.out.println("toSend: " + toSend);
        }
        this.is = this.gatewayConnection.getInputStream();
        GatewayBufferedReader in_iso8859_1 = new GatewayBufferedReader(new InputStreamReader(this.is, "ISO-8859-1"));
        String fromServer = in_iso8859_1.readLine();
        if (fromServer == null) {
            this.logger.log(Level.SEVERE, "geterrorMsg: Server said unexpected good bye?!");
            throw new IOException("Server said unexpected good bye?");
        }
        this.is = this.gatewayConnection.getInputStream();
        this.in = new GatewayBufferedReader(new InputStreamReader(this.is, "UTF-8"));
        this.logger.log(Level.FINE, "received: " + fromServer);
        if (this.debug) {
            System.out.println("received: " + fromServer);
        }
        Uniresult uniresult = new Uniresult();
        this.parseLicenseResult(fromServer, uniresult, msg);
        return uniresult;
    }
}

