/*
 * Decompiled with CFR 0.152.
 */
package uniserv.cliserv.mail;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import uniserv.cliserv.GatewayInternalException;
import uniserv.cliserv.GenClient;
import uniserv.cliserv.NoSuchArgException;
import uniserv.cliserv.Uniresult;
import uniserv.cliserv.mail.DuplicateListHandler;
import uniserv.cliserv.mail.MailErrorHandler;
import uniserv.cliserv.mail.MailException;

public class MailClient
extends GenClient {
    private String myLanguage = "D";
    private int myWarningCode = 0;
    private String myWarning = "";

    public MailClient() {
    }

    public MailClient(String host, int port, String service) throws IOException, GatewayInternalException, MailException {
        super(1);
        Uniresult myUniresult = super.open(host, port, service);
        if (myUniresult.getRetType() != 0) {
            StringBuffer msg = new StringBuffer();
            super.getErrorMsg(myUniresult.getRetType(), myUniresult.getRetInfo(), this.myLanguage, msg);
            throw new MailException(msg.toString());
        }
    }

    public void setLanguage(String language) {
        if ("D".equals(language) || "E".equals(language) || "F".equals(language)) {
            this.myLanguage = language;
        }
    }

    public void setNameLine(String nameLine) {
        super.setArg("in_name_line", nameLine);
    }

    public void setStreetLine(String streetLine) {
        super.setArg("in_str_line", streetLine);
    }

    public void setCity(String city) {
        super.setArg("in_city", city);
    }

    public void setZip(String zip) {
        super.setArg("in_zip", zip);
    }

    public void setCountry(String country) {
        super.setArg("in_country_code", country);
    }

    public void setDbref(String dbref) {
        super.setArg("in_dbref", dbref);
    }

    public void setPhone(String phone) {
        super.setArg("in_phone", phone);
    }

    public void setDate(String date) {
        super.setArg("in_date", date);
    }

    public int getWarningCode() {
        return this.myWarningCode;
    }

    public String getWarning() {
        return this.myWarning;
    }

    public void mailSearch(DuplicateListHandler duplicateList, MailErrorHandler error) throws IOException, GatewayInternalException, MailException {
        Uniresult myUniresult = super.execRequest("mail_search");
        int myType = myUniresult.getRetType();
        int myInfo = myUniresult.getRetInfo();
        int myCount = myUniresult.getRetCount();
        if (myType == 0 || myType == 2) {
            if (myType == 2) {
                this.myWarningCode = myInfo;
                StringBuffer eMsg = new StringBuffer();
                super.getErrorMsg(myType, myInfo, this.myLanguage, eMsg);
                this.myWarning = eMsg.toString();
            }
            if (myCount > 0) {
                Vector<String> listArgs = new Vector<String>();
                String[] columnNames = new String[13];
                listArgs.add("out_dbref");
                columnNames[0] = "out_dbref";
                listArgs.add("out_mval");
                columnNames[1] = "out_mval";
                listArgs.add("out_mvals");
                columnNames[2] = "out_mvals";
                listArgs.add("out_data");
                columnNames[3] = "out_data";
                listArgs.add("out_evalue_tab");
                columnNames[4] = "out_evalue_tab";
                listArgs.add("out_free");
                columnNames[5] = "out_free";
                listArgs.add("out_free2");
                columnNames[6] = "out_free2";
                listArgs.add("out_free3");
                columnNames[7] = "out_free3";
                listArgs.add("out_free4");
                columnNames[8] = "out_free4";
                listArgs.add("out_free5");
                columnNames[9] = "out_free5";
                listArgs.add("out_free6");
                columnNames[10] = "out_free6";
                listArgs.add("out_free7");
                columnNames[11] = "out_free7";
                listArgs.add("out_index");
                columnNames[12] = "out_index";
                String[][] duplicates = new String[myCount][13];
                try {
                    int i = 0;
                    while (i < myCount) {
                        Hashtable<String, String> listArgsValues = new Hashtable<String, String>();
                        super.getArg(listArgs, listArgsValues, i);
                        int j = 0;
                        Enumeration<String> t = listArgs.elements();
                        while (t.hasMoreElements()) {
                            String arg = t.nextElement();
                            String value = listArgsValues.get(arg);
                            duplicates[i][j++] = value;
                        }
                        ++i;
                    }
                }
                catch (NoSuchArgException e) {
                    throw new MailException(e.getMessage());
                }
                int action = duplicateList.handleDuplicateList(duplicates, columnNames);
            } else {
                duplicateList.noDuplicates();
            }
        } else {
            this.errorOccured(error, myType, myInfo);
        }
    }

    public int mailSearchInsert(DuplicateListHandler duplicateList, MailErrorHandler error) throws IOException, GatewayInternalException, MailException {
        Uniresult myUniresult = super.execRequest("mail_search_insert");
        int myType = myUniresult.getRetType();
        int myInfo = myUniresult.getRetInfo();
        int myCount = myUniresult.getRetCount();
        if (myType == 2 && myInfo == 2019) {
            if (myCount > 0) {
                Vector<String> listArgs = new Vector<String>();
                String[] columnNames = new String[13];
                listArgs.add("out_dbref");
                columnNames[0] = "out_dbref";
                listArgs.add("out_mval");
                columnNames[1] = "out_mval";
                listArgs.add("out_mvals");
                columnNames[2] = "out_mvals";
                listArgs.add("out_data");
                columnNames[3] = "out_data";
                listArgs.add("out_evalue_tab");
                columnNames[4] = "out_evalue_tab";
                listArgs.add("out_free");
                columnNames[5] = "out_free";
                listArgs.add("out_free2");
                columnNames[6] = "out_free2";
                listArgs.add("out_free3");
                columnNames[7] = "out_free3";
                listArgs.add("out_free4");
                columnNames[8] = "out_free4";
                listArgs.add("out_free5");
                columnNames[9] = "out_free5";
                listArgs.add("out_free6");
                columnNames[10] = "out_free6";
                listArgs.add("out_free7");
                columnNames[11] = "out_free7";
                listArgs.add("out_index");
                columnNames[12] = "out_index";
                String[][] duplicates = new String[myCount][13];
                try {
                    int i = 0;
                    while (i < myCount) {
                        Hashtable<String, String> listArgsValues = new Hashtable<String, String>();
                        super.getArg(listArgs, listArgsValues, i);
                        int j = 0;
                        Enumeration<String> t = listArgs.elements();
                        while (t.hasMoreElements()) {
                            String arg = t.nextElement();
                            String value = listArgsValues.get(arg);
                            duplicates[i][j++] = value;
                        }
                        ++i;
                    }
                }
                catch (NoSuchArgException e) {
                    throw new MailException(e.getMessage());
                }
                int action = duplicateList.handleDuplicateList(duplicates, columnNames);
                return 2;
            }
            duplicateList.noDuplicates();
            return 1;
        }
        if (myType == 0 || myType == 2) {
            if (myType == 2) {
                this.myWarningCode = myInfo;
                StringBuffer eMsg = new StringBuffer();
                super.getErrorMsg(myType, myInfo, this.myLanguage, eMsg);
                this.myWarning = eMsg.toString();
            }
            return 0;
        }
        this.errorOccured(error, myType, myInfo);
        return 1;
    }

    public int mailInsert(MailErrorHandler error) throws IOException, GatewayInternalException, MailException {
        Uniresult myUniresult = super.execRequest("mail_insert");
        int myType = myUniresult.getRetType();
        int myInfo = myUniresult.getRetInfo();
        if (myType == 0 || myType == 2) {
            if (myType == 2) {
                this.myWarningCode = myInfo;
                StringBuffer eMsg = new StringBuffer();
                super.getErrorMsg(myType, myInfo, this.myLanguage, eMsg);
                this.myWarning = eMsg.toString();
            }
            return 0;
        }
        this.errorOccured(error, myType, myInfo);
        return 1;
    }

    public int mailDelete(MailErrorHandler error) throws IOException, GatewayInternalException, MailException {
        Uniresult myUniresult = super.execRequest("mail_delete");
        int myType = myUniresult.getRetType();
        int myInfo = myUniresult.getRetInfo();
        if (myType == 0 || myType == 2) {
            if (myType == 2) {
                this.myWarningCode = myInfo;
                StringBuffer eMsg = new StringBuffer();
                super.getErrorMsg(myType, myInfo, this.myLanguage, eMsg);
                this.myWarning = eMsg.toString();
            }
            return 0;
        }
        this.errorOccured(error, myType, myInfo);
        return 1;
    }

    public int mailUpdate(MailErrorHandler error) throws IOException, GatewayInternalException, MailException {
        Uniresult myUniresult = super.execRequest("mail_update");
        int myType = myUniresult.getRetType();
        int myInfo = myUniresult.getRetInfo();
        if (myType == 0 || myType == 2) {
            if (myType == 2) {
                this.myWarningCode = myInfo;
                StringBuffer eMsg = new StringBuffer();
                super.getErrorMsg(myType, myInfo, this.myLanguage, eMsg);
                this.myWarning = eMsg.toString();
            }
            return 0;
        }
        this.errorOccured(error, myType, myInfo);
        return 1;
    }

    public void finish() throws IOException, GatewayInternalException {
        super.close();
    }

    public void mailLoadBegin() throws IOException, GatewayInternalException, MailException {
        Uniresult myUniresult = super.execRequest("mail_load_begin");
        int myType = myUniresult.getRetType();
        int myInfo = myUniresult.getRetInfo();
        if (myType == 0 || myType == 2) {
            if (myType == 2) {
                this.myWarningCode = myInfo;
                StringBuffer eMsg = new StringBuffer();
                super.getErrorMsg(myType, myInfo, this.myLanguage, eMsg);
                this.myWarning = eMsg.toString();
            }
            return;
        }
        StringBuffer eMsg = new StringBuffer();
        super.getErrorMsg(myType, myInfo, this.myLanguage, eMsg);
        throw new MailException(eMsg.toString());
    }

    public void mailLoadEnd() throws IOException, GatewayInternalException, MailException {
        Uniresult myUniresult = super.execRequest("mail_load_end");
        int myType = myUniresult.getRetType();
        int myInfo = myUniresult.getRetInfo();
        if (myType == 0 || myType == 2) {
            if (myType == 2) {
                this.myWarningCode = myInfo;
                StringBuffer eMsg = new StringBuffer();
                super.getErrorMsg(myType, myInfo, this.myLanguage, eMsg);
                this.myWarning = eMsg.toString();
            }
            return;
        }
        StringBuffer eMsg = new StringBuffer();
        super.getErrorMsg(myType, myInfo, this.myLanguage, eMsg);
        throw new MailException(eMsg.toString());
    }

    public int mailLoadInsert(MailErrorHandler error) throws IOException, GatewayInternalException, MailException {
        Uniresult myUniresult = super.execRequest("mail_load_insert");
        int myType = myUniresult.getRetType();
        int myInfo = myUniresult.getRetInfo();
        if (myType == 0 || myType == 2) {
            if (myType == 2) {
                this.myWarningCode = myInfo;
                StringBuffer eMsg = new StringBuffer();
                super.getErrorMsg(myType, myInfo, this.myLanguage, eMsg);
                this.myWarning = eMsg.toString();
            }
            return 0;
        }
        this.errorOccured(error, myType, myInfo);
        return 1;
    }

    private void errorOccured(MailErrorHandler errorHandler, int type, int info) throws MailException, IOException, GatewayInternalException {
        StringBuffer eMsg = new StringBuffer();
        super.getErrorMsg(type, info, this.myLanguage, eMsg);
        switch (info) {
            case 2007: 
            case 2014: 
            case 2016: 
            case 2017: 
            case 2020: 
            case 2022: 
            case 2023: 
            case 2028: 
            case 2029: 
            case 2030: 
            case 2031: 
            case 2032: 
            case 2033: 
            case 2036: 
            case 2042: 
            case 2044: 
            case 2047: 
            case 2055: {
                throw new MailException(eMsg.toString());
            }
        }
        errorHandler.handleError(type, info, eMsg.toString());
    }
}

