/*
 * Decompiled with CFR 0.152.
 */
package com.talend.compress.zip;

import com.talend.compress.zip.IntegrityUtil;
import com.talend.compress.zip.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javax.crypto.CipherInputStream;
import net.lingala.zip4j.model.FileHeader;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class Unzip {
    private boolean needPassword = false;
    private boolean useZip4jDecryption = false;
    private String password = null;
    private boolean checkArchive = false;
    private boolean verbose = false;
    private boolean extractPath = true;
    private Util util = null;
    private String sourceZip;
    private String targetDir;
    private String encording;

    public void setNeedPassword(boolean needPassword) {
        this.needPassword = needPassword;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCheckArchive(boolean checkArchive) {
        this.checkArchive = checkArchive;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setExtractPath(boolean extractPath) {
        this.extractPath = extractPath;
    }

    public void setUtil(Util util) {
        this.util = util;
    }

    public void setSourceZip(String sourceZip) {
        this.sourceZip = sourceZip;
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }

    public void setUseZip4jDecryption(boolean useZip4jDecryption) {
        this.useZip4jDecryption = useZip4jDecryption;
    }

    public void setEncording(String encording) {
        this.encording = encording;
    }

    public Unzip(String sourceZip, String targetDir) {
        this.sourceZip = sourceZip;
        this.targetDir = targetDir;
    }

    public void doUnzip() throws Exception {
        System.out.println("Processing archive " + this.sourceZip + ", please wait...");
        System.out.println();
        if (this.needPassword) {
            if (this.useZip4jDecryption) {
                this.doUnzipWithAes();
            } else {
                this.doUnzipWithDecryption();
            }
        } else {
            this.doUnzipWithoutDecryption();
        }
        System.out.println();
        System.out.println("Process finished");
    }

    public void doUnzipWithAes() throws Exception {
        File file = new File(this.sourceZip);
        if (this.password == null || "".equals(this.password)) {
            Thread.sleep(1000L);
            throw new RuntimeException("Please enter the password and try again..");
        }
        net.lingala.zip4j.ZipFile zipFile = new net.lingala.zip4j.ZipFile(this.sourceZip, this.password.toCharArray());
        if (this.encording != null) {
            zipFile.setCharset(Charset.forName(this.encording));
        }
        if (this.checkArchive && !zipFile.isValidZipFile()) {
            throw new RuntimeException("The file " + this.sourceZip + " is corrupted, process terminated...");
        }
        List fileHeaderList = zipFile.getFileHeaders();
        if (fileHeaderList == null) {
            return;
        }
        for (int i = 0; i < fileHeaderList.size(); ++i) {
            FileHeader fileHeader = (FileHeader)fileHeaderList.get(i);
            String filename = fileHeader.getFileName();
            if (this.verbose) {
                System.out.println("Source file  : " + filename);
            }
            if (!this.extractPath) {
                filename = filename.replaceAll("\\\\", "/");
                filename = filename.substring(filename.lastIndexOf(47) + 1);
            }
            zipFile.extractFile(fileHeader, this.targetDir, filename);
            this.util.addUnzippedFiles(this.targetDir, filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnzipWithDecryption() throws Exception {
        File file = new File(this.sourceZip);
        if (this.password == null || "".equals(this.password)) {
            Thread.sleep(1000L);
            throw new RuntimeException("Please enter the password and try again..");
        }
        if (this.checkArchive && !IntegrityUtil.isEncryptedZipValid(file, this.password)) {
            throw new RuntimeException("The file " + this.sourceZip + " is corrupted, process terminated...");
        }
        try (InputStream is = null;){
            ZipArchiveEntry entry;
            is = new FileInputStream(this.sourceZip);
            is = new CipherInputStream(is, IntegrityUtil.createCipher(2, this.password));
            ZipArchiveInputStream input = new ZipArchiveInputStream((InputStream)new BufferedInputStream(is), Optional.ofNullable(this.encording).orElse("UTF8"));
            while ((entry = input.getNextZipEntry()) != null) {
                if (this.verbose) {
                    System.out.println("Source file  : " + entry.getName());
                }
                boolean isDirectory = entry.isDirectory();
                String filename = entry.getName();
                this.util.output(this.targetDir, filename, isDirectory, (InputStream)input);
                this.applyLastModifiedTime(entry, filename);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnzipWithoutDecryption() throws Exception {
        if (this.checkArchive && !IntegrityUtil.isZipValid(new File(this.sourceZip))) {
            Thread.sleep(1000L);
            throw new RuntimeException("The file " + this.sourceZip + " is corrupted, process terminated...");
        }
        Thread.sleep(1000L);
        try (ZipFile zip = null;){
            zip = new ZipFile(this.sourceZip, Optional.ofNullable(this.encording).orElse("UTF8"));
            Enumeration enuFiles = zip.getEntries();
            InputStream is = null;
            while (enuFiles.hasMoreElements()) {
                boolean isDirectory;
                ZipArchiveEntry entry = (ZipArchiveEntry)enuFiles.nextElement();
                if (this.verbose) {
                    System.out.println("Source file  : " + entry.getName());
                }
                if (!(isDirectory = entry.isDirectory())) {
                    is = zip.getInputStream(entry);
                }
                String filename = entry.getName();
                this.util.output(this.targetDir, filename, isDirectory, is);
                this.applyLastModifiedTime(entry, filename);
            }
        }
    }

    private void applyLastModifiedTime(ZipArchiveEntry entry, String filename) {
        if (this.extractPath) {
            File f = new File(this.targetDir + "/" + filename);
            f.setLastModified(entry.getTime());
        } else {
            File unzippedFile = new File(this.targetDir + this.util.getEntryName(filename));
            unzippedFile.setLastModified(entry.getTime());
        }
    }
}

