/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.logging.event.layout;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.talend.daikon.logging.event.field.LayoutFields;

public final class LayoutUtils {
    public static void addMDC(Map<String, String> mdc, JSONObject userFieldsEvent, JSONObject logstashEvent) {
        for (Map.Entry<String, String> entry : mdc.entrySet()) {
            if (LayoutUtils.isSleuthField(entry.getKey())) {
                logstashEvent.put((Object)entry.getKey(), (Object)entry.getValue());
                continue;
            }
            userFieldsEvent.put((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    public static String dateFormat(long timestamp) {
        return LayoutFields.DATETIME_TIME_FORMAT.format(timestamp);
    }

    public static void addUserFields(String data, JSONObject userFieldsEvent) {
        if (null != data) {
            String[] pairs;
            for (String pair : pairs = data.split(",")) {
                String[] userField = pair.split(":", 2);
                if (userField[0] == null) continue;
                String key = userField[0];
                String val = userField[1];
                userFieldsEvent.put((Object)key, (Object)val);
            }
        }
    }

    public static void addUserFields(Map<String, String> additionalLogAttributes, JSONObject userFieldsEvent) {
        for (Map.Entry<String, String> entry : additionalLogAttributes.entrySet()) {
            userFieldsEvent.put((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    public static boolean isSleuthField(String fieldName) {
        return "service".equals(fieldName) || "X-B3-SpanId".equals(fieldName) || "X-B3-TraceId".equals(fieldName) || "X-Span-Export".equals(fieldName);
    }

    public static Map<String, String> processMDCMetaFields(Map<String, String> existingMdc, JSONObject logstashEvent, Map<String, String> metaFields) {
        LinkedHashMap<String, String> mdc = new LinkedHashMap<String, String>(existingMdc);
        if (metaFields == null) {
            return mdc;
        }
        for (Map.Entry<String, String> field : metaFields.entrySet()) {
            if (!mdc.containsKey(field.getKey())) continue;
            String val = (String)mdc.remove(field.getKey());
            logstashEvent.put((Object)field.getValue(), (Object)val);
        }
        return mdc;
    }

    private LayoutUtils() {
    }
}

