/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.logging.event.layout;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.apache.log4j.Layout;
import org.apache.log4j.pattern.ThrowableInformationPatternConverter;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.talend.daikon.logging.event.field.HostData;
import org.talend.daikon.logging.event.field.LayoutFields;
import org.talend.daikon.logging.event.layout.LayoutUtils;

public class Log4jJSONLayout
extends Layout {
    private boolean locationInfo;
    private boolean hostInfo;
    private String customUserFields;
    private boolean ignoreThrowable;
    private Map<String, String> metaFields = new HashMap<String, String>();

    public Log4jJSONLayout() {
        this(false, true);
    }

    public Log4jJSONLayout(boolean locationInfo, boolean hostInfo) {
        this.locationInfo = locationInfo;
        this.hostInfo = hostInfo;
    }

    public void setMetaFields(Map<String, String> metaFields) {
        this.metaFields = new HashMap<String, String>(metaFields);
    }

    public String format(LoggingEvent loggingEvent) {
        JSONObject logstashEvent = new JSONObject();
        JSONObject userFieldsEvent = new JSONObject();
        HostData host = new HostData();
        String ndc = loggingEvent.getNDC();
        if (this.getUserFields() != null) {
            String userFlds = this.getUserFields();
            LayoutUtils.addUserFields(userFlds, userFieldsEvent);
        }
        Map<String, String> mdc = LayoutUtils.processMDCMetaFields(loggingEvent.getProperties(), logstashEvent, this.metaFields);
        logstashEvent.put((Object)"@version", (Object)LayoutFields.VERSION_VALUE);
        logstashEvent.put((Object)"logTimestamp", (Object)LayoutUtils.dateFormat(loggingEvent.getTimeStamp()));
        logstashEvent.put((Object)"agentTimestamp", (Object)LayoutUtils.dateFormat(new Date().getTime()));
        if (ndc != null) {
            logstashEvent.put((Object)"NDC", (Object)ndc);
        }
        logstashEvent.put((Object)"severity", (Object)loggingEvent.getLevel().toString());
        logstashEvent.put((Object)"threadName", (Object)loggingEvent.getThreadName());
        logstashEvent.put((Object)"logMessage", (Object)loggingEvent.getRenderedMessage());
        this.handleThrown(logstashEvent, loggingEvent);
        JSONObject logSourceEvent = this.createLogSourceEvent(loggingEvent, host);
        logstashEvent.put((Object)"logSource", (Object)logSourceEvent);
        LayoutUtils.addMDC(mdc, userFieldsEvent, logstashEvent);
        if (!userFieldsEvent.isEmpty()) {
            logstashEvent.put((Object)"customInfo", (Object)userFieldsEvent);
        }
        return logstashEvent.toString() + "\n";
    }

    public boolean ignoresThrowable() {
        return this.ignoreThrowable;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public void setHostInfo(boolean hostInfo) {
        this.hostInfo = hostInfo;
    }

    public boolean getHostInfo() {
        return this.hostInfo;
    }

    public String getUserFields() {
        return this.customUserFields;
    }

    public void setUserFields(String userFields) {
        this.customUserFields = userFields;
    }

    public void activateOptions() {
    }

    private JSONObject createLogSourceEvent(LoggingEvent loggingEvent, HostData host) {
        JSONObject logSourceEvent = new JSONObject();
        if (this.locationInfo) {
            LocationInfo info = loggingEvent.getLocationInformation();
            logSourceEvent.put((Object)"file.name", (Object)info.getFileName());
            logSourceEvent.put((Object)"line.number", (Object)info.getLineNumber());
            logSourceEvent.put((Object)"class.name", (Object)info.getClassName());
            logSourceEvent.put((Object)"method.name", (Object)info.getMethodName());
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            String jvmName = runtimeBean.getName();
            logSourceEvent.put((Object)"process.id", (Object)Long.valueOf(jvmName.split("@")[0]));
        }
        logSourceEvent.put((Object)"logger.name", (Object)loggingEvent.getLoggerName());
        if (this.hostInfo) {
            logSourceEvent.put((Object)"host.name", (Object)host.getHostName());
            logSourceEvent.put((Object)"host.address", (Object)host.getHostAddress());
        }
        return logSourceEvent;
    }

    private void handleThrown(JSONObject logstashEvent, LoggingEvent loggingEvent) {
        if (loggingEvent.getThrowableInformation() != null) {
            ThrowableInformation throwableInformation = loggingEvent.getThrowableInformation();
            if (throwableInformation.getThrowable().getClass().getCanonicalName() != null) {
                logstashEvent.put((Object)"exceptionClass", (Object)throwableInformation.getThrowable().getClass().getCanonicalName());
            }
            if (throwableInformation.getThrowable().getMessage() != null) {
                logstashEvent.put((Object)"exceptionMessage", (Object)throwableInformation.getThrowable().getMessage());
            }
            this.createStackTraceEvent(logstashEvent, loggingEvent, throwableInformation);
        }
    }

    private void createStackTraceEvent(JSONObject logstashEvent, LoggingEvent loggingEvent, ThrowableInformation throwableInformation) {
        if (throwableInformation.getThrowableStrRep() != null) {
            String[] options = new String[]{"full"};
            ThrowableInformationPatternConverter converter = ThrowableInformationPatternConverter.newInstance((String[])options);
            StringBuffer sb = new StringBuffer();
            converter.format(loggingEvent, sb);
            String stackTrace = sb.toString();
            logstashEvent.put((Object)"stackTrace", (Object)stackTrace);
        }
    }
}

