/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.logging.user;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.talend.daikon.logging.user.RequestUserActivityContext;

public class RequestUserActivityFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestUserActivityFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String userActivityId = httpServletRequest.getHeader("X-talend-user-activity-id");
        if (StringUtils.isEmpty((String)userActivityId)) {
            userActivityId = UUID.randomUUID().toString();
        }
        RequestUserActivityContext.getCurrent().setCorrelationId(userActivityId);
        MDC.put((String)"user-activity-id", (String)userActivityId);
        LOGGER.debug("userActivityId ={} request={}", (Object)userActivityId, (Object)httpServletRequest.getPathInfo());
        try {
            chain.doFilter((ServletRequest)httpServletRequest, response);
        }
        finally {
            MDC.remove((String)"user-activity-id");
            RequestUserActivityContext.clearCurrent();
        }
    }

    public void destroy() {
    }
}

