/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.derby.starter;

import java.net.InetAddress;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.derby.drda.NetworkServerControl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkActivator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkActivator.class);
    private static final String DERBY_PORT_PROPERTY = "org.talend.esb.derby.port";
    private static final int DEFAULT_PORT = 1527;
    private static final String PORT_FALLBACK_MESSAGE = "System property org.talend.esb.derby.port not set, using default port 1527. ";
    private static final String PORT_ERROR_MESSAGE = "System property org.talend.esb.derby.port has an illegal port value of {}, using default port 1527. ";
    private static final String PORT_CONFIGURED_MESSAGE = "System property org.talend.esb.derby.port is applied, setting Derby port to {}. ";
    private NetworkServerControl server;

    public void start(BundleContext context) throws Exception {
        LOG.info("Starting internal Derby DB...");
        this.server = new NetworkServerControl(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}), NetworkActivator.resolveDerbyPort());
        this.server.start(null);
        DriverManager.getConnection(NetworkActivator.getDerbyJDBC_Create("db"));
    }

    public void stop(BundleContext context) throws Exception {
        block2: {
            LOG.info("Stopping internal Derby DB...");
            try {
                DriverManager.getConnection(NetworkActivator.getDerbyJDBC_Shutdown("db"));
            }
            catch (SQLException e) {
                if ("08006".equals(e.getSQLState())) break block2;
                LOG.error("Exception during db shutdown. ", (Throwable)e);
            }
        }
        this.server.shutdown();
    }

    private static String getDerbyJDBC_Create(String databaseName) {
        return "jdbc:derby:" + databaseName + ";create=true";
    }

    private static String getDerbyJDBC_Shutdown(String databaseName) {
        return "jdbc:derby:" + databaseName + ";shutdown=true";
    }

    private static int resolveDerbyPort() {
        Integer value = Integer.getInteger(DERBY_PORT_PROPERTY);
        if (value == null) {
            LOG.info(PORT_FALLBACK_MESSAGE);
            return 1527;
        }
        int result = value;
        if (result < 1 || result > 65535) {
            LOG.warn(PORT_ERROR_MESSAGE, (Object)result);
            return 1527;
        }
        LOG.info(PORT_CONFIGURED_MESSAGE, (Object)result);
        return result;
    }
}

