/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.derby.starter;

import java.sql.Connection;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkActivator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkActivator.class);

    public void start(BundleContext context) throws Exception {
        LOG.info("Starting internal Derby DB...");
        EmbeddedDataSource dds = new EmbeddedDataSource();
        dds.setDatabaseName("db");
        dds.setCreateDatabase("create");
        Connection c = dds.getConnection();
        c.close();
    }

    public void stop(BundleContext context) throws Exception {
        LOG.info("Stopping internal Derby DB...");
        EmbeddedDataSource dds = new EmbeddedDataSource();
        dds.setDatabaseName("db");
        dds.setShutdownDatabase("shutdown");
        try {
            Connection c = dds.getConnection();
            c.close();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage());
        }
    }
}

