/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.locator.commands;

import javax.xml.namespace.QName;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.talend.esb.locator.completer.EndpointAddressCompleter;
import org.talend.esb.locator.completer.FullServiceNameCompleter;
import org.talend.esb.locator.tracker.ServiceLocatorTracker;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.client.ServiceLocatorException;

@Command(scope="tlocator", name="register", description="Registers endpoint at Service Locator.\n\n\u001b[1;37mEXAMPLE\u001b[0m\n\ttlocator:register -p \"{http://my.company.com/my-service-namespace}MyServiceName\" http://my.server.com:8040/services/MyServiceName\n\ttlocator:register MyServiceName http://another.server.com:8040/services/MyServiceName")
@Service
public class RegisterOperation
implements Action {
    @Option(name="-p", aliases={"--persistent"}, required=false, description="Endpoint will be registered as always online. No heardbeat will be required.", multiValued=false)
    boolean persistent;
    @Argument(index=0, name="serviceName", description="Service name for endpoint to be added. Must be fully qualified if adding a new / unknown service name. For adding an endpoint to a known service name local part of service name is sufficient.", required=true, multiValued=false)
    @Completion(value=FullServiceNameCompleter.class)
    String service;
    @Argument(index=1, name="URL", description="Endpoint address to be registered at Service Locator", required=true, multiValued=false)
    @Completion(value=EndpointAddressCompleter.class)
    String endpoint;
    @Reference
    private ServiceLocator sl;

    public Object execute() throws Exception {
        ServiceLocatorTracker slt = ServiceLocatorTracker.getInstance(this.sl);
        System.out.println();
        try {
            QName serviceName = slt.getServiceName(this.service);
            this.sl.register(serviceName, this.endpoint, this.persistent);
            System.out.println("Endpoint has been registered at Service Locator");
            slt.updateServiceList();
        }
        catch (ServiceLocatorException e) {
            System.err.println(e.getMessage());
        }
        System.out.println();
        return null;
    }
}

