/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.talend.esb.servicelocator.client.SLProperties;

public class SLPropertiesImpl
implements SLProperties {
    public static final SLProperties EMPTY_PROPERTIES = new SLPropertiesImpl();
    private static final long serialVersionUID = -3527977700696163706L;
    private Map<String, Collection<String>> properties = new LinkedHashMap<String, Collection<String>>();

    public void addProperty(String name, String ... values) {
        ArrayList<String> valueList = new ArrayList<String>();
        for (String value : values) {
            valueList.add(value.trim());
        }
        this.properties.put(name.trim(), valueList);
    }

    public void addProperty(String name, Iterable<String> values) {
        ArrayList<String> valueList = new ArrayList<String>();
        for (String value : values) {
            valueList.add(value.trim());
        }
        this.properties.put(name.trim(), valueList);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public Collection<String> getValues(String name) {
        return this.properties.get(name);
    }

    @Override
    public boolean includesValues(String name, String ... values) {
        return this.includesValues(name, Arrays.asList(values));
    }

    @Override
    public boolean includesValues(String name, Collection<String> values) {
        Collection<String> propValues = this.properties.get(name);
        if (propValues == null) {
            return false;
        }
        return propValues.containsAll(values);
    }
}

