/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.talend.esb.servicelocator.client.BindingType;
import org.talend.esb.servicelocator.client.SLEndpoint;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.SLPropertiesImpl;
import org.talend.esb.servicelocator.client.SimpleEndpoint;
import org.talend.esb.servicelocator.client.TransportType;
import org.talend.esb.servicelocator.client.internal.JaxbContextHandler;
import org.talend.esb.servicelocator.client.internal.SLPropertiesConverter;
import org.talend.esb.servicelocator.client.internal.endpoint.EndpointDataType;
import org.talend.esb.servicelocator.client.internal.endpoint.ObjectFactory;
import org.talend.esb.servicelocator.client.internal.endpoint.ServiceLocatorPropertiesType;
import org.talend.esb.servicelocator.client.ws.addressing.EndpointReferenceType;
import org.talend.esb.servicelocator.client.ws.addressing.MetadataType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SLEndpointProvider
extends SimpleEndpoint
implements SLEndpoint {
    private static final Logger LOG = Logger.getLogger(SLEndpointProvider.class.getName());
    private static final ObjectFactory SL_OBJECT_FACTORY = new ObjectFactory();
    private static final String SERVICE_LOCATOR_PROPERTIES_NS = "http://talend.org/schemas/esb/locator/content/20011/11";
    private static final String SERVICE_LOCATOR_PROPERTIES_LN = "ServiceLocatorProperties";
    private final long lastTimeStarted;
    private final long lastTimeStopped;
    private final boolean isLive;

    public SLEndpointProvider(QName serviceName, EndpointDataType endpointData, boolean live) {
        super(serviceName, null, SLEndpointProvider.extractBinding(endpointData), SLEndpointProvider.extractTransport(endpointData), null);
        EndpointReferenceType epr = this.toEndPointReference(endpointData.getEndpointReference());
        this.init(SLEndpointProvider.extractAddress(epr), this.extractProperties(epr));
        this.lastTimeStarted = endpointData.getLastTimeStarted();
        this.lastTimeStopped = endpointData.getLastTimeStopped();
        this.isLive = live;
    }

    @Override
    public long getLastTimeStarted() {
        return this.lastTimeStarted;
    }

    @Override
    public long getLastTimeStopped() {
        return this.lastTimeStopped;
    }

    @Override
    public boolean isLive() {
        return this.isLive;
    }

    private EndpointReferenceType toEndPointReference(Element root) {
        EndpointReferenceType epr = null;
        if (root != null) {
            try {
                JAXBContext jc = JaxbContextHandler.getAddressingContext();
                JAXBElement eprElem = (JAXBElement)jc.createUnmarshaller().unmarshal((Node)root);
                epr = (EndpointReferenceType)eprElem.getValue();
            }
            catch (JAXBException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Failed to deserialize endpoint reference", e);
                }
            }
        } else {
            LOG.log(Level.SEVERE, "No endpoint reference found in content");
        }
        return epr != null ? epr : new EndpointReferenceType();
    }

    private static String extractAddress(EndpointReferenceType epr) {
        return epr.getAddress() != null ? epr.getAddress().getValue() : null;
    }

    private static BindingType extractBinding(EndpointDataType epd) {
        return epd.getBinding() != null ? BindingType.fromValue(epd.getBinding().value()) : null;
    }

    private static TransportType extractTransport(EndpointDataType epd) {
        return epd.getTransport() != null ? TransportType.fromValue(epd.getTransport().value()) : null;
    }

    private SLProperties extractProperties(EndpointReferenceType epr) {
        MetadataType metadata = epr.getMetadata();
        if (metadata != null) {
            List<Object> metaAny = metadata.getAny();
            for (Object any : metaAny) {
                Element root;
                if (!(any instanceof Element) || !SLEndpointProvider.isServiceLocatorProperties(root = (Element)any)) continue;
                ServiceLocatorPropertiesType slp = this.toServiceLocatorProperties(root);
                return SLPropertiesConverter.toSLProperties(slp);
            }
        }
        return new SLPropertiesImpl();
    }

    private ServiceLocatorPropertiesType toServiceLocatorProperties(Element root) {
        try {
            JAXBContext jc = JaxbContextHandler.getEndpointContext();
            JAXBElement slp = (JAXBElement)jc.createUnmarshaller().unmarshal((Node)root);
            return (ServiceLocatorPropertiesType)slp.getValue();
        }
        catch (JAXBException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to deserialize service locator properties", e);
            }
            return SL_OBJECT_FACTORY.createServiceLocatorPropertiesType();
        }
    }

    private static boolean isServiceLocatorProperties(Element elem) {
        return SERVICE_LOCATOR_PROPERTIES_LN.equals(elem.getLocalName()) && SERVICE_LOCATOR_PROPERTIES_NS.equals(elem.getNamespaceURI());
    }
}

