/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal;

import java.util.logging.Level;
import java.util.logging.Logger;

public class NodePath {
    public static final char SEPARATOR = '/';
    private static final Logger LOG = Logger.getLogger(NodePath.class.getPackage().getName());
    private String path;

    public NodePath(String ... pathSegments) {
        if (pathSegments == null || pathSegments.length == 0) {
            LOG.log(Level.SEVERE, "At least one path segment must be defined.");
            throw new IllegalArgumentException("At least one path segment must be defined.");
        }
        StringBuffer rawPath = new StringBuffer();
        for (String pathSegment : pathSegments) {
            this.checkValidPathSegment(pathSegment);
            String encodedPathSegment = NodePath.encode(pathSegment);
            rawPath.append('/').append(encodedPathSegment);
        }
        this.path = rawPath.toString();
    }

    protected NodePath(NodePath parentPath, String childPathSegment) {
        this.checkValidPathSegment(childPathSegment);
        this.path = parentPath.path + "/" + NodePath.encode(childPathSegment);
    }

    protected NodePath(NodePath parentPath, String childPathSegment, boolean encoded) {
        this.checkValidPathSegment(childPathSegment);
        String encodedChildPathSegment = encoded ? childPathSegment : NodePath.encode(childPathSegment);
        this.path = parentPath.path + "/" + encodedChildPathSegment;
    }

    public NodePath child(String childNodeName) {
        return new NodePath(this, childNodeName);
    }

    protected NodePath child(String childNodeName, boolean encoded) {
        return new NodePath(this, childNodeName, encoded);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodePath)) {
            return false;
        }
        return this.path.equals(((NodePath)obj).path);
    }

    public String getNodeName() {
        int index = this.path.lastIndexOf(47);
        return NodePath.decode(this.path.substring(index + 1));
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }

    private void checkValidPathSegment(String pathSegment) {
        if (pathSegment == null || pathSegment.isEmpty()) {
            throw new IllegalArgumentException("Path segments must not be null and not empty.");
        }
    }

    public static String encode(String raw) {
        String encoded = raw.replace("%", "%2A");
        encoded = encoded.replace("/", "%2F");
        return encoded;
    }

    public static String decode(String encoded) {
        String raw = encoded.replace("%2F", "/");
        raw = raw.replace("%2A", "%");
        return raw;
    }
}

