/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.beans;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Endpoint;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.springframework.beans.factory.InitializingBean;
import org.talend.esb.mep.requestcallback.beans.JmsUriConfiguration;
import org.talend.esb.mep.requestcallback.feature.CallContext;
import org.talend.esb.mep.requestcallback.feature.Configuration;

public class JmsUriConfigurator
implements InitializingBean {
    private static final Logger LOGGER = LogUtils.getL7dLogger(JmsUriConfigurator.class);
    private QName serviceName;
    private QName endpointName;
    private String configurationPrefix;
    private String workPrefix;
    private Configuration configuration;
    private String presetJmsAddress;
    private String variant;
    private String defaultVariant;
    private String destinationName;
    private String defaultDestinationName;
    private Map<?, ?> parameters;
    private Map<?, ?> defaultParameters;
    private String jmsAddress;
    private JmsUriConfiguration.UriEncoding encodeURI = JmsUriConfiguration.UriEncoding.PARTIAL;

    public static JmsUriConfigurator create(Endpoint endpoint) {
        if (!(endpoint instanceof EndpointImpl)) {
            return null;
        }
        EndpointImpl ep = (EndpointImpl)endpoint;
        QName serviceName = ep.getServiceName();
        if (serviceName == null) {
            return null;
        }
        QName endpointName = ep.getEndpointName();
        String portName = endpointName == null ? null : endpointName.getLocalPart();
        JmsUriConfigurator result = new JmsUriConfigurator();
        result.setConfigurationPrefix(portName);
        result.setServiceName(serviceName);
        return result;
    }

    public static JmsUriConfigurator create(JaxWsServerFactoryBean factory) {
        if (factory == null) {
            return null;
        }
        QName serviceName = factory.getServiceName();
        if (serviceName == null) {
            return null;
        }
        QName endpointName = factory.getEndpointName();
        String portName = endpointName == null ? null : endpointName.getLocalPart();
        JmsUriConfigurator result = new JmsUriConfigurator();
        result.setConfigurationPrefix(portName);
        result.setServiceName(serviceName);
        return result;
    }

    public static JmsUriConfigurator create(Dispatch<?> dispatch) {
        String endpointAddress;
        QName endpointName;
        QName serviceName;
        if (!(dispatch instanceof DispatchImpl)) {
            return null;
        }
        DispatchImpl dsp = (DispatchImpl)dispatch;
        Client cl = dsp.getClient();
        try {
            serviceName = cl.getEndpoint().getService().getName();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Exception caught: ", e);
            }
            return null;
        }
        if (serviceName == null) {
            return null;
        }
        try {
            EndpointInfo endpointInfo = cl.getEndpoint().getEndpointInfo();
            endpointName = endpointInfo.getName();
            endpointAddress = endpointInfo.getAddress();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Exception caught: ", e);
            }
            Object endpointInfo = null;
            endpointName = null;
            endpointAddress = null;
        }
        String portName = endpointName == null ? null : endpointName.getLocalPart();
        JmsUriConfigurator result = new JmsUriConfigurator();
        result.setConfigurationPrefix(portName);
        result.setServiceName(serviceName);
        if (endpointAddress != null && endpointAddress.startsWith("jms:")) {
            result.setPresetJmsAddress(endpointAddress);
        }
        return result;
    }

    public <T> Dispatch<T> configureDispatch(Dispatch<T> dispatch) {
        if (!(dispatch instanceof DispatchImpl) || this.serviceName == null && this.configuration == null) {
            return null;
        }
        DispatchImpl di = (DispatchImpl)dispatch;
        Client cl = di.getClient();
        try {
            String jmsAddr = this.getJmsAddress();
            cl.getRequestContext().put(Message.ENDPOINT_ADDRESS, jmsAddr);
            cl.getEndpoint().getEndpointInfo().setAddress(jmsAddr);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Exception caught: ", e);
            }
            return null;
        }
        return dispatch;
    }

    public String getPresetJmsAddress() {
        return this.presetJmsAddress;
    }

    public void setPresetJmsAddress(String presetJmsAddress) {
        this.presetJmsAddress = presetJmsAddress;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getDefaultVariant() {
        return this.defaultVariant;
    }

    public void setDefaultVariant(String defaultVariant) {
        this.defaultVariant = defaultVariant;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getDefaultDestinationName() {
        return this.defaultDestinationName;
    }

    public void setDefaultDestinationName(String defaultDestinationName) {
        this.defaultDestinationName = defaultDestinationName;
    }

    public Map<?, ?> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<?, ?> parameters) {
        this.parameters = parameters;
    }

    public Map<?, ?> getDefaultParameters() {
        return this.defaultParameters;
    }

    public void setDefaultParameters(Map<?, ?> defaultParameters) {
        this.defaultParameters = defaultParameters;
    }

    public String getJmsAddress() {
        if (this.jmsAddress == null) {
            this.jmsAddress = this.createJmsAddress();
        }
        return this.jmsAddress;
    }

    public String resetJmsAddress() {
        String result = this.jmsAddress;
        this.jmsAddress = null;
        return result;
    }

    public JmsUriConfiguration createJmsUriConfiguration() {
        if (this.configuration == null) {
            this.configuration = CallContext.resolveConfiguration(this.serviceName);
        }
        JmsUriConfiguration jmsConfig = new JmsUriConfiguration();
        String prop = this.getProperty("encodeURI");
        if (JmsUriConfigurator.nonzero(prop)) {
            try {
                this.setEncodeURI(prop);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        jmsConfig.setUriEncode(this.encodeURI);
        if (JmsUriConfigurator.nonzero(this.defaultVariant)) {
            jmsConfig.setVariant(this.defaultVariant);
        }
        if (JmsUriConfigurator.nonzero(this.defaultDestinationName)) {
            jmsConfig.setDestinationName(this.defaultDestinationName);
        }
        JmsUriConfigurator.copyParams(this.defaultParameters, jmsConfig);
        prop = this.getProperty("jmsAddress");
        if (JmsUriConfigurator.nonzero(prop)) {
            jmsConfig.applyJmsUri(prop);
        }
        if (JmsUriConfigurator.nonzero(prop = this.getProperty("variant"))) {
            jmsConfig.setVariant(prop);
        }
        if (JmsUriConfigurator.nonzero(prop = this.getProperty("destinationName"))) {
            jmsConfig.setDestinationName(prop);
        }
        this.addConfigParamsTo(jmsConfig);
        if (JmsUriConfigurator.nonzero(this.presetJmsAddress)) {
            jmsConfig.applyJmsUri(this.presetJmsAddress);
        }
        if (JmsUriConfigurator.nonzero(this.variant)) {
            jmsConfig.setVariant(this.variant);
        }
        if (JmsUriConfigurator.nonzero(this.destinationName)) {
            jmsConfig.setDestinationName(this.destinationName);
        }
        JmsUriConfigurator.copyParams(this.parameters, jmsConfig);
        return jmsConfig;
    }

    public String createJmsAddress() {
        return this.createJmsUriConfiguration().toString();
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = JmsUriConfigurator.validQName(serviceName);
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = JmsUriConfigurator.validQName(serviceName);
    }

    public QName getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = JmsUriConfigurator.validQName(endpointName);
        this.setConfigurationPrefix();
    }

    public void setEndpointName(QName endpointName) {
        this.endpointName = JmsUriConfigurator.validQName(endpointName);
        this.setConfigurationPrefix();
    }

    public String getConfigurationPrefix() {
        return this.configurationPrefix;
    }

    public void setConfigurationPrefix(String configurationPrefix) {
        this.configurationPrefix = configurationPrefix;
        this.workPrefix = JmsUriConfigurator.nonzero(configurationPrefix) ? configurationPrefix + "." : null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isEncodeURI() {
        return this.encodeURI != JmsUriConfiguration.UriEncoding.NONE;
    }

    public void setEncodeURI(boolean encodeURIValue) {
        this.encodeURI = encodeURIValue ? JmsUriConfiguration.UriEncoding.PARTIAL : JmsUriConfiguration.UriEncoding.NONE;
    }

    public void setEncodeURI(String encodeURIValue) {
        this.encodeURI = JmsUriConfiguration.toUriEncoding(encodeURIValue);
    }

    public void afterPropertiesSet() throws Exception {
        this.jmsAddress = this.createJmsAddress();
    }

    private void setConfigurationPrefix() {
        this.setConfigurationPrefix(this.endpointName == null ? null : this.endpointName.getLocalPart());
    }

    private String getProperty(String key) {
        String result = null;
        if (this.workPrefix != null) {
            result = this.configuration.getProperty(this.workPrefix + key);
        }
        return result == null ? this.configuration.getProperty(key) : result;
    }

    private void addConfigParamsTo(JmsUriConfiguration target) {
        if (JmsUriConfigurator.nonzero(this.configuration)) {
            NavigableMap<String, String> params = target.getParameters();
            LinkedList<String> excludes = new LinkedList<String>();
            excludes.add("variant");
            excludes.add("destinationName");
            excludes.add("jmsAddress");
            excludes.add("nonJmsAddress");
            excludes.add("encodeURI");
            if (this.workPrefix != null) {
                excludes.add(this.workPrefix + "variant");
                excludes.add(this.workPrefix + "destinationName");
                excludes.add(this.workPrefix + "jmsAddress");
                excludes.add(this.workPrefix + "nonJmsAddress");
                excludes.add(this.workPrefix + "encodeURI");
            }
            for (Map.Entry e : this.configuration.entrySet()) {
                String key;
                Object value = e.getValue();
                if (value == null || (key = this.validKey((String)e.getKey(), excludes)) == null) continue;
                params.put(key, value.toString());
            }
        }
    }

    private String validKey(String sample, List<String> excludes) {
        if (sample == null || sample.length() == 0) {
            return null;
        }
        for (String exclude : excludes) {
            if (!sample.equals(exclude)) continue;
            return null;
        }
        int ndx = sample.indexOf(46);
        if (ndx < 0) {
            return sample;
        }
        if (this.workPrefix != null && sample.startsWith(this.workPrefix)) {
            String s = sample.substring(this.workPrefix.length());
            int n = s.indexOf(46);
            if (n >= 0) {
                return null;
            }
            excludes.add(s);
            return s;
        }
        return null;
    }

    private static void copyParams(Map<?, ?> source, JmsUriConfiguration target) {
        if (JmsUriConfigurator.nonzero(source)) {
            NavigableMap<String, String> params = target.getParameters();
            for (Map.Entry<?, ?> e : source.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(key instanceof String) || value == null) continue;
                params.put((String)key, value.toString());
            }
        }
    }

    private static boolean nonzero(String string) {
        return string != null && string.length() > 0;
    }

    private static boolean nonzero(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    private static QName validQName(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("{")) {
            int ndx = value.indexOf(125, 1);
            if (ndx < 0) {
                return null;
            }
            return new QName(value.substring(1, ndx), value.substring(ndx + 1));
        }
        int cndx = value.indexOf(58);
        if (cndx < 0) {
            return new QName(value);
        }
        return new QName(value.substring(cndx + 1));
    }

    private static QName validQName(QName qname) {
        if (qname == null) {
            return null;
        }
        if (JmsUriConfigurator.nonzero(qname.getNamespaceURI())) {
            return qname;
        }
        return JmsUriConfigurator.validQName(qname.getLocalPart());
    }
}

