/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.feature;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.wsdl11.WSDLServiceFactory;
import org.talend.esb.mep.requestcallback.feature.CallContext;
import org.talend.esb.mep.requestcallback.feature.RequestCallbackFeature;
import org.talend.esb.mep.requestcallback.impl.wsdl.PLRole;
import org.talend.esb.mep.requestcallback.impl.wsdl.PLType;

public class CallbackInfo {
    private static final String SR_QUERY_PATH = "/services/registry/lookup/wsdl/";
    private static final int SR_QUERY_PATH_LEN = "/services/registry/lookup/wsdl/".length();
    private QName portTypeName = null;
    private QName callbackPortTypeName = null;
    private QName callbackServiceName = null;
    private String callbackPortName = null;
    private final String wsdlLocation;
    private String callbackWsdlLocation = null;
    private final List<OperationMapping> operationMappings = new ArrayList<OperationMapping>();

    public CallbackInfo(URL wsdlLocation) {
        this(wsdlLocation.toExternalForm());
    }

    public CallbackInfo(String wsdlLocation) {
        this(CallbackInfo.createServiceFactory(wsdlLocation).getDefinition(), wsdlLocation);
    }

    public CallbackInfo(CallbackInfo source, QName service, String port, boolean copyWsdlLocation) {
        this.portTypeName = source.portTypeName;
        this.callbackPortTypeName = source.callbackPortTypeName;
        this.callbackServiceName = service;
        this.callbackPortName = port;
        if (copyWsdlLocation) {
            this.wsdlLocation = source.wsdlLocation;
            if (service != null && service.equals(source.callbackServiceName)) {
                this.callbackWsdlLocation = source.callbackWsdlLocation;
            }
        } else {
            this.wsdlLocation = null;
        }
        this.operationMappings.addAll(source.operationMappings);
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public QName getCallbackPortTypeName() {
        return this.callbackPortTypeName;
    }

    public QName getCallbackServiceName() {
        return this.callbackServiceName;
    }

    public String getCallbackPortName() {
        return this.callbackPortName;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public List<OperationMapping> getOperationMappings() {
        return this.operationMappings;
    }

    public String getSpecificCallbackSenderWsdlLocation(String policyAlias) {
        return this.getCallbackWsdlLocation(policyAlias, true);
    }

    public String getSpecificCallbackReceiverWsdlLocation(String policyAlias) {
        return this.getCallbackWsdlLocation(policyAlias, false);
    }

    public String getEffectiveCallbackSenderWsdlLocation(String policyAlias) {
        String loc = this.getCallbackWsdlLocation(policyAlias, true);
        return loc == null ? this.wsdlLocation : loc;
    }

    public String getEffectiveCallbackReceiverWsdlLocation(String policyAlias) {
        String loc = this.getCallbackWsdlLocation(policyAlias, false);
        return loc == null ? this.wsdlLocation : loc;
    }

    private CallbackInfo(Definition definition, String wsdlLocation) {
        Map.Entry entry;
        this.wsdlLocation = wsdlLocation;
        String portTypeHint = null;
        String callbackPortTypeHint = null;
        for (Object e : definition.getExtensibilityElements()) {
            PLType pl;
            if (!(e instanceof PLType) || (pl = (PLType)((Object)e)) == null) continue;
            List<PLRole> roles = pl.getRoles();
            if (roles != null) {
                for (PLRole role : roles) {
                    String name = role.getName();
                    if ("service".equals(name)) {
                        portTypeHint = role.getPortType().getName();
                        continue;
                    }
                    if (!"callback".equals(name)) continue;
                    callbackPortTypeHint = role.getPortType().getName();
                }
            }
            if (portTypeHint == null || callbackPortTypeHint == null) continue;
            break;
        }
        if (portTypeHint == null || callbackPortTypeHint == null) {
            return;
        }
        for (Object object : definition.getPortTypes().entrySet()) {
            entry = (Map.Entry)object;
            QName portTypeName = (QName)entry.getKey();
            PortType portType = (PortType)entry.getValue();
            if (CallbackInfo.representsName(portTypeName, portTypeHint, definition)) {
                this.portTypeName = portTypeName;
                continue;
            }
            if (!CallbackInfo.representsName(portTypeName, callbackPortTypeHint, definition)) continue;
            this.callbackPortTypeName = portTypeName;
            for (Map.Entry op : portType.getOperations()) {
                Operation operation = (Operation)op;
                String partnerOpName = null;
                boolean isFault = false;
                Iterator iterator = operation.getExtensionAttributes().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry att;
                    Map.Entry attEntry = att = iterator.next();
                    QName attName = (QName)attEntry.getKey();
                    QName value = (QName)attEntry.getValue();
                    if ("partnerOperation".equals(attName.getLocalPart())) {
                        partnerOpName = value.getLocalPart();
                        continue;
                    }
                    if (!"faultOperation".equals(attName.getLocalPart())) continue;
                    isFault = "true".equalsIgnoreCase(value.getLocalPart());
                }
                if (partnerOpName == null) continue;
                this.operationMappings.add(new OperationMapping(partnerOpName, operation.getName(), isFault));
            }
        }
        if (this.callbackPortTypeName != null) {
            for (Object object : definition.getServices().entrySet()) {
                entry = (Map.Entry)object;
                QName serviceName = (QName)entry.getKey();
                Service service = (Service)entry.getValue();
                Iterator iterator = service.getPorts().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry p;
                    Map.Entry portEntry = p = iterator.next();
                    String portName = (String)portEntry.getKey();
                    Port port = (Port)portEntry.getValue();
                    Binding b = port.getBinding();
                    if (!this.callbackPortTypeName.equals(b.getPortType().getQName())) continue;
                    this.callbackServiceName = serviceName;
                    this.callbackPortName = portName;
                }
            }
        }
    }

    private String getCallbackWsdlLocation(String policyAlias, boolean isSender) {
        if (this.callbackWsdlLocation == null) {
            this.callbackWsdlLocation = CallbackInfo.callbackWsdlLocation(this.wsdlLocation, this.callbackServiceName);
        }
        if (this.callbackWsdlLocation.length() == 0) {
            return null;
        }
        Object resString = this.callbackWsdlLocation;
        resString = (String)resString + (isSender ? CallbackInfo.callbackSenderPolicyQuery(policyAlias) : CallbackInfo.callbackReceiverPolicyQuery(policyAlias));
        return resString;
    }

    private static WSDLServiceFactory createServiceFactory(String wsdlLocation) {
        Bus b = CXFBusFactory.getThreadDefaultBus();
        RequestCallbackFeature.applyWsdlExtensions(b);
        return new WSDLServiceFactory(b, wsdlLocation);
    }

    private static boolean representsName(QName fullName, String abbrevatedName, Definition definition) {
        int ndx = abbrevatedName.indexOf(58);
        if (ndx < 0) {
            return abbrevatedName.equals(fullName.getLocalPart());
        }
        String prefix = abbrevatedName.substring(0, ndx);
        String localName = abbrevatedName.substring(ndx + 1);
        String namespace = definition.getNamespace(prefix);
        if (namespace == null) {
            return false;
        }
        return namespace.equals(fullName.getNamespaceURI()) && localName.equals(fullName.getLocalPart());
    }

    private static String callbackWsdlLocation(String wsdlLocation, QName callbackService) {
        if (wsdlLocation == null || callbackService == null || !wsdlLocation.startsWith("http://") && !wsdlLocation.startsWith("https://")) {
            return "";
        }
        int ndx = wsdlLocation.indexOf(SR_QUERY_PATH);
        if (ndx < 0) {
            return "";
        }
        try {
            return wsdlLocation.substring(0, wsdlLocation.indexOf(SR_QUERY_PATH) + SR_QUERY_PATH_LEN) + URLEncoder.encode(callbackService.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected URL creation problem: ", e);
        }
    }

    private static String callbackSenderPolicyQuery(String policyAlias) {
        switch (CallContext.EFFECTIVE_POLICY_DISTRIBUTION_MODE) {
            case EXCHANGE: {
                if (policyAlias == null || policyAlias.length() == 0) {
                    return "?mergeWithPolicies=true&participant=consumer";
                }
                return "?mergeWithPolicies=true&participant=consumer&consumerPolicyAlias=" + policyAlias;
            }
            case SERVICE: {
                return "?mergeWithPolicies=true&participant=provider";
            }
        }
        throw new IllegalStateException("Invalid configuration of policy distribution mode. ");
    }

    private static String callbackReceiverPolicyQuery(String policyAlias) {
        switch (CallContext.EFFECTIVE_POLICY_DISTRIBUTION_MODE) {
            case EXCHANGE: {
                return "?mergeWithPolicies=true&participant=provider";
            }
            case SERVICE: {
                if (policyAlias == null || policyAlias.length() == 0) {
                    return "?mergeWithPolicies=true&participant=consumer";
                }
                return "?mergeWithPolicies=true&participant=consumer&consumerPolicyAlias=" + policyAlias;
            }
        }
        throw new IllegalStateException("Invalid configuration of policy distribution mode. ");
    }

    public static class OperationMapping {
        private final String requestOperation;
        private final String callbackOperation;
        private final boolean isFaultCallback;

        public OperationMapping(String requestOperation, String callbackOperation, boolean isFaultCallback) {
            this.requestOperation = requestOperation;
            this.callbackOperation = callbackOperation;
            this.isFaultCallback = isFaultCallback;
        }

        public String getRequestOperation() {
            return this.requestOperation;
        }

        public String getCallbackOperation() {
            return this.callbackOperation;
        }

        public boolean isFaultCallback() {
            return this.isFaultCallback;
        }
    }
}

