/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.talend.esb.mep.requestcallback.feature.CallContext;
import org.talend.esb.mep.requestcallback.feature.CallbackInfo;
import org.talend.esb.mep.requestcallback.feature.RequestCallbackFeature;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdProtocolHeaderCodec;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdSoapCodec;
import org.talend.esb.sam.agent.message.FlowIdHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequestCallbackInInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public RequestCallbackInInterceptor() {
        super("pre-logical");
        this.addAfter(MAPAggregator.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Header callbackHeader;
        Header callHeader = message.getHeader(RequestCallbackFeature.CALL_ID_HEADER_NAME);
        if (callHeader == null) {
            return;
        }
        Exchange e = message.getExchange();
        if (!e.isOneWay()) {
            e.setOneWay(true);
        }
        if ((callbackHeader = message.getHeader(RequestCallbackFeature.CALLBACK_ID_HEADER_NAME)) == null) {
            this.doHandleRequestSoapMessage(message, callHeader);
        } else {
            this.doHandleCallbackSoapMessage(message, callHeader, callbackHeader);
        }
    }

    private void doHandleRequestSoapMessage(SoapMessage message, Header callHeader) throws Fault {
        CallContext ctx = this.setupCallContext(message, callHeader, null);
        RequestCallbackInInterceptor.storeRequestorCertificate((Message)message, ctx);
    }

    private void doHandleCallbackSoapMessage(SoapMessage message, Header callHeader, Header callbackHeader) throws Fault {
        this.setupCallContext(message, callHeader, callbackHeader);
        RequestCallbackInInterceptor.setupFlowId(message);
    }

    private CallContext setupCallContext(SoapMessage message, Header callHeader, Header callbackHeader) throws Fault {
        AddressingProperties maps = RequestCallbackInInterceptor.getAddressingProperties(message);
        if (maps == null) {
            throw new IllegalStateException("Request-Callback enabled but no WS-Addressing headers set. ");
        }
        CallContext ctx = new CallContext();
        message.put("org.talend.esb.mep.requestcallback.CallContext", (Object)ctx);
        QName operationName = QName.valueOf(maps.getAction().getValue());
        if (!RequestCallbackInInterceptor.isGenericOperation(operationName)) {
            ctx.setOperationName(operationName);
        }
        ctx.setCallId(RequestCallbackInInterceptor.valueOf(callHeader));
        if (callbackHeader != null) {
            ctx.setCallbackId(RequestCallbackInInterceptor.valueOf(callbackHeader));
        }
        ctx.setRequestId(maps.getMessageID().getValue());
        ctx.setReplyToAddress(maps.getReplyTo().getAddress().getValue());
        ctx.setCorrelationId(RequestCallbackInInterceptor.getCorrelationId(message));
        if (callbackHeader == null) {
            RequestCallbackInInterceptor.setupFlowId(message);
        }
        RequestCallbackInInterceptor.fillCallContext(ctx, message);
        return ctx;
    }

    private static String getCorrelationId(SoapMessage message) {
        Header h = message.getHeader(RequestCallbackFeature.CORRELATION_ID_HEADER_NAME);
        if (h != null) {
            return RequestCallbackInInterceptor.valueOf(h);
        }
        return null;
    }

    private static AddressingProperties getAddressingProperties(SoapMessage message) {
        AddressingProperties maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context");
        if (maps == null) {
            maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.inbound");
        }
        return maps;
    }

    private static String valueOf(Header header) {
        Object headerObject = header.getObject();
        if (headerObject == null) {
            return null;
        }
        if (headerObject instanceof String) {
            return (String)headerObject;
        }
        if (headerObject instanceof Element) {
            return DOMUtils.getContent((Node)((Element)headerObject));
        }
        return null;
    }

    private static boolean isGenericOperation(QName operationName) {
        String name = operationName.getLocalPart();
        return name.startsWith("http://cxf.apache.org/jaxws") && name.endsWith("InvokeOneWayRequest");
    }

    public static void fillCallContext(CallContext callContext, SoapMessage message) {
        String flowId;
        if (callContext.getOperationName() == null) {
            callContext.setOperationName((QName)message.get((Object)"javax.xml.ws.wsdl.operation"));
        }
        callContext.setPortTypeName((QName)message.get((Object)"javax.xml.ws.wsdl.interface"));
        callContext.setServiceName((QName)message.get((Object)"javax.xml.ws.wsdl.service"));
        BindingInfo bi = message.getExchange().getBinding().getBindingInfo();
        callContext.setBindingId(bi == null ? "http://schemas.xmlsoap.org/wsdl/soap/" : bi.getBindingId());
        URL wsdlLocation = RequestCallbackInInterceptor.resolveCallbackWsdlLocation(callContext.getServiceName(), message);
        if (wsdlLocation != null) {
            callContext.setWsdlLocation(wsdlLocation);
        }
        if ((flowId = FlowIdHelper.getFlowId((Message)message)) != null && !flowId.isEmpty()) {
            callContext.setFlowId(flowId);
        }
    }

    private static URL resolveCallbackWsdlLocation(QName callbackService, SoapMessage message) {
        WSDLManager wsdlManager = (WSDLManager)message.getExchange().getBus().getExtension(WSDLManager.class);
        for (Map.Entry entry : wsdlManager.getDefinitions().entrySet()) {
            if (((Definition)entry.getValue()).getService(callbackService) == null) continue;
            Object key = entry.getKey();
            if (key instanceof URL) {
                return RequestCallbackInInterceptor.asCallbackWsdlURL((URL)entry.getKey());
            }
            if (!(key instanceof String)) continue;
            String loc = (String)key;
            if (loc.startsWith("file:") || loc.indexOf("://") > 0) {
                try {
                    return RequestCallbackInInterceptor.asCallbackWsdlURL(new URL(loc));
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Corrupted WSDL location URL: ", e);
                }
            }
            File wsdlFile = new File(loc);
            if (wsdlFile.exists()) {
                return RequestCallbackInInterceptor.toCallbackWsdlURL(wsdlFile);
            }
            URL classpathWsdlURL = CallContext.class.getClassLoader().getResource(loc);
            if (classpathWsdlURL != null) {
                return RequestCallbackInInterceptor.asCallbackWsdlURL(classpathWsdlURL);
            }
            return null;
        }
        return null;
    }

    private static URL asCallbackWsdlURL(URL wsdlURL) {
        if (wsdlURL == null) {
            return null;
        }
        CallbackInfo cbInfo = CallContext.createCallbackInfo(wsdlURL);
        if (cbInfo.getCallbackServiceName() == null) {
            return null;
        }
        String callbackWsdlLocation = cbInfo.getSpecificCallbackSenderWsdlLocation(null);
        try {
            return callbackWsdlLocation == null ? wsdlURL : new URL(callbackWsdlLocation);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Unexpected URL creation problem: ", e);
        }
    }

    private static URL toCallbackWsdlURL(File wsdlFile) {
        if (!wsdlFile.isFile() || !wsdlFile.canRead()) {
            throw new IllegalStateException("File " + wsdlFile.getName() + " is not a readable file. ");
        }
        try {
            URL wsdlURL = wsdlFile.toURI().toURL();
            CallbackInfo cbInfo = CallContext.createCallbackInfo(wsdlURL);
            if (cbInfo.getCallbackServiceName() == null) {
                return null;
            }
            return wsdlURL;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot create URL for WSDL file location. ", e);
        }
    }

    private static void setupFlowId(SoapMessage message) {
        Message reqMsg;
        Exchange ex;
        String flowId = FlowIdHelper.getFlowId((Message)message);
        if (flowId == null) {
            flowId = FlowIdProtocolHeaderCodec.readFlowId((Message)message);
        }
        if (flowId == null) {
            flowId = FlowIdSoapCodec.readFlowId((Message)message);
        }
        if (flowId == null && null != (ex = message.getExchange()) && null != (reqMsg = ex.getOutMessage())) {
            flowId = FlowIdHelper.getFlowId((Message)reqMsg);
        }
        if (flowId != null && !flowId.isEmpty()) {
            FlowIdHelper.setFlowId((Message)message, (String)flowId);
        }
    }

    private static void storeRequestorCertificate(Message message, CallContext callContext) {
        String encrUser = (String)SecurityUtils.getSecurityPropertyValue((String)"security.encryption.username", (Message)message);
        if ("useReqSigCert".equals(encrUser)) {
            X509Certificate reqSignCert = RequestCallbackInInterceptor.getReqSigCert(message);
            callContext.setRequestorSignatureCertificate(reqSignCert);
        }
    }

    private static X509Certificate getReqSigCert(Message message) {
        List results = CastUtils.cast((List)((List)message.getExchange().getInMessage().get((Object)"RECV_RESULTS")));
        if (results == null) {
            return null;
        }
        for (WSHandlerResult rResult : results) {
            List wsSecEngineResults = rResult.getResults();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 2) continue;
                return (X509Certificate)wser.get((Object)"x509-certificate");
            }
        }
        return null;
    }
}

