/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.feature;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.talend.esb.mep.requestcallback.feature.Configuration;
import org.talend.esb.mep.requestcallback.impl.AbstractConfiguration;
import org.talend.esb.mep.requestcallback.impl.ConfigurationImpl;
import org.talend.esb.mep.requestcallback.impl.DotOnlyNamespaceUriEncoder;
import org.talend.esb.mep.requestcallback.impl.StandardNamespaceUriEncoder;

public final class ConfigurationInitializer {
    private static final QName NULL_NAME = new QName("!NULL!");
    private static final Manager MANAGER = new Manager();

    private ConfigurationInitializer() {
    }

    public static Configuration resolveConfiguration(QName serviceName) {
        return MANAGER.resolveConfiguration(serviceName);
    }

    public Map<QName, Configuration> getConfigurations() {
        return MANAGER.getConfigurations();
    }

    public static boolean addConfigurationCreationListener(ConfigurationCreationListener listener, boolean triggerForExisting) {
        return MANAGER.addConfigurationCreationListener(listener, triggerForExisting);
    }

    public static boolean removeConfigurationCreationListener(ConfigurationCreationListener listener) {
        return MANAGER.removeConfigurationCreationListener(listener);
    }

    public static void addConfigurations(Collection<Configuration> configurations) {
        MANAGER.addConfigurations(configurations);
    }

    public static void setConfigurationNamespaceToFileEncoding(NamespaceToFileNameEncodingMode mode) {
        switch (mode) {
            case STANDARD: {
                if (!(AbstractConfiguration.getNamespaceUriEncoder() instanceof StandardNamespaceUriEncoder)) {
                    AbstractConfiguration.setNamespaceUriEncoder(new StandardNamespaceUriEncoder());
                }
                return;
            }
            case DOTONLY: {
                if (!(AbstractConfiguration.getNamespaceUriEncoder() instanceof DotOnlyNamespaceUriEncoder)) {
                    AbstractConfiguration.setNamespaceUriEncoder(new DotOnlyNamespaceUriEncoder());
                }
                return;
            }
        }
    }

    static {
        MANAGER.resolveConfiguration(null);
    }

    private static final class Manager {
        private final Map<QName, Configuration> configs = new HashMap<QName, Configuration>();
        private final List<ConfigurationCreationListener> listeners = new LinkedList<ConfigurationCreationListener>();

        public synchronized Configuration resolveConfiguration(QName serviceName) {
            QName key = serviceName == null ? NULL_NAME : serviceName;
            Configuration config = this.configs.get(key);
            if (config == null) {
                config = this.createConfiguration(serviceName);
                this.configs.put(key, config);
            }
            return config;
        }

        public Map<QName, Configuration> getConfigurations() {
            return Collections.unmodifiableMap(this.configs);
        }

        public synchronized boolean addConfigurationCreationListener(ConfigurationCreationListener listener, boolean triggerForExisting) {
            if (this.listeners.add(listener)) {
                if (triggerForExisting) {
                    for (Configuration config : this.configs.values()) {
                        listener.configurationCreated(config);
                    }
                }
                return true;
            }
            return false;
        }

        public synchronized boolean removeConfigurationCreationListener(ConfigurationCreationListener listener) {
            return this.listeners.remove(listener);
        }

        public synchronized void addConfigurations(Collection<Configuration> configurations) {
            for (Configuration configuration : configurations) {
                this.configs.put(configuration.getConfigurationName(), configuration);
            }
        }

        private Configuration createConfiguration(QName serviceName) {
            ConfigurationImpl result = new ConfigurationImpl(serviceName);
            result.refreshStaticConfiguration();
            for (ConfigurationCreationListener listener : this.listeners) {
                listener.configurationCreated(result);
            }
            return result;
        }
    }

    public static interface ConfigurationCreationListener {
        public void configurationCreated(Configuration var1);
    }

    public static enum NamespaceToFileNameEncodingMode {
        STANDARD,
        DOTONLY;

    }
}

