/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.impl;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.jms.JMSDestination;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.talend.esb.mep.requestcallback.feature.RequestCallbackFeature;

public class CallbackActionInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public CallbackActionInterceptor() {
        super("pre-logical");
        this.addBefore(SoapActionInInterceptor.SoapActionInAttemptTwoInterceptor.class.getName());
        this.addBefore(MAPAggregator.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Header callHeader = message.getHeader(RequestCallbackFeature.CALL_ID_HEADER_NAME);
        if (callHeader == null) {
            return;
        }
        this.handleAddressing(message);
        Header callbackHeader = message.getHeader(RequestCallbackFeature.CALLBACK_ID_HEADER_NAME);
        if (callbackHeader == null) {
            return;
        }
        BindingOperationInfo boi = message.getExchange().getBindingOperationInfo();
        if (boi == null) {
            return;
        }
        String action = SoapActionInInterceptor.getSoapAction((Message)message);
        if (StringUtils.isEmpty((String)action)) {
            return;
        }
        SoapOperationInfo soi = (SoapOperationInfo)boi.getExtensor(SoapOperationInfo.class);
        if (soi == null) {
            return;
        }
        if (StringUtils.isEmpty((String)soi.getAction())) {
            soi.setAction(action);
        }
    }

    private void handleAddressing(SoapMessage message) {
        AddressingProperties maps = (AddressingProperties)message.getContextualProperty("javax.xml.ws.addressing.context.inbound");
        if (maps == null) {
            return;
        }
        EndpointReferenceType rpl = maps.getReplyTo();
        if (rpl == null) {
            return;
        }
        AttributedURIType addr = rpl.getAddress();
        if (addr == null) {
            return;
        }
        String replyTo = addr.getValue();
        Exchange exchange = message.getExchange();
        if (exchange.getDestination() instanceof JMSDestination) {
            ContextUtils.storePartialResponseSent((Message)message);
            if (!exchange.isOneWay()) {
                exchange.setOneWay(true);
            }
        } else if (exchange.isOneWay()) {
            if (!"http://www.w3.org/2005/08/addressing/none".equals(replyTo)) {
                exchange.setOneWay(false);
            }
        } else if ("http://www.w3.org/2005/08/addressing/none".equals(replyTo)) {
            addr.setValue("http://www.w3.org/2005/08/addressing/anonymous");
        }
    }
}

