/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.impl.callcontext;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.talend.esb.auxiliary.storage.common.AuxiliaryObjectFactory;
import org.talend.esb.mep.requestcallback.feature.CallContext;
import org.talend.esb.mep.requestcallback.impl.callcontext.Base64Coder;

public class CallContextFactoryImpl<E>
implements AuxiliaryObjectFactory<E> {
    private static final Logger LOGGER = LogUtils.getL7dLogger(CallContextFactoryImpl.class);

    public String marshalObject(E ctx) {
        if (ctx instanceof Serializable) {
            ByteArrayOutputStream baos;
            block3: {
                baos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(ctx);
                    oos.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.FINER)) break block3;
                    LOGGER.log(Level.FINER, "Exception caught: ", e);
                }
            }
            return new String(Base64Coder.encode(baos.toByteArray()));
        }
        throw new IllegalArgumentException("Marshalled object should implement  java.io.Serializable");
    }

    public E unmarshallObject(String marshalledData) {
        block4: {
            byte[] data = Base64Coder.decode(marshalledData);
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
                Object ctx = ois.readObject();
                ois.close();
                return (E)ctx;
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Exception caught: ", e);
                }
            }
            catch (ClassNotFoundException e) {
                if (!LOGGER.isLoggable(Level.FINER)) break block4;
                LOGGER.log(Level.FINER, "Exception caught: ", e);
            }
        }
        return null;
    }

    public String createObjectKey(E ctxObj) {
        if (ctxObj instanceof CallContext) {
            CallContext ctx = (CallContext)ctxObj;
            String key = ctx.getCallId();
            return this.prettifyCallContextKey(key);
        }
        return null;
    }

    public String contentType() {
        return "application/octet-stream";
    }

    private String prettifyCallContextKey(String key) {
        return key == null ? null : key.replace(':', '-');
    }
}

