/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.feature;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.wsdl.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.wsdl.service.factory.DefaultServiceConfiguration;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.talend.esb.mep.requestcallback.feature.CallbackInfo;
import org.talend.esb.mep.requestcallback.feature.Configuration;
import org.talend.esb.mep.requestcallback.feature.ConfigurationInitializer;
import org.talend.esb.mep.requestcallback.feature.RequestCallbackFeature;
import org.talend.esb.mep.requestcallback.impl.wsdl.CallbackDefaultServiceConfiguration;

public class CallContext
implements Serializable {
    public static final String POLICY_DISTRIBUTION_MODE_CONFIG = "org.talend.esb.policy.distribution.properties";
    public static final String POLICY_DISTRIBUTION_MODE_PROPERTY = "org.talend.esb.policy.distribution.mode";
    public static final PolicyDistributionMode DEFAULT_POLICY_DISTRIBUTION_MODE = PolicyDistributionMode.EXCHANGE;
    public static final PolicyDistributionMode EFFECTIVE_POLICY_DISTRIBUTION_MODE = CallContext.effectivePolicyDistributionMode();
    private static final Logger LOGGER = LogUtils.getL7dLogger(CallContext.class);
    private static final String NULL_MEANS_ONEWAY = "jaxws.provider.interpretNullAsOneway";
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    private static final long serialVersionUID = -5024912330689208965L;
    private static final int CLASSPATH_URL_PREFIX_LENGTH = "classpath:".length();
    private QName portTypeName;
    private QName serviceName;
    private QName operationName;
    private String requestId;
    private String callId;
    private String correlationId;
    private String callbackId;
    private String replyToAddress;
    private String bindingId;
    private String flowId;
    private URL wsdlLocationURL;
    private Map<String, String> userData;
    private transient CallbackInfo callbackInfo = null;
    private static boolean logging = false;
    private static boolean serviceActivityMonitoring = false;
    private X509Certificate requestorSignatureCertificate;
    private static ClassPathXmlApplicationContext samContext = null;

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(QName portTypeName) {
        this.portTypeName = portTypeName;
        this.callbackInfo = null;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
        this.callbackInfo = null;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName operationName) {
        this.operationName = operationName;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public void setCallbackId(String callbackId) {
        this.callbackId = callbackId;
    }

    public String getReplyToAddress() {
        return this.replyToAddress;
    }

    public void setReplyToAddress(String replyToAddress) {
        this.replyToAddress = replyToAddress;
    }

    public String getBindingId() {
        return this.bindingId;
    }

    public void setBindingId(String bindingId) {
        this.bindingId = bindingId;
    }

    public String getWsdlLocation() {
        return this.wsdlLocationURL == null ? null : this.wsdlLocationURL.toExternalForm();
    }

    public void setWsdlLocation(String wsdlLocation) throws MalformedURLException {
        this.wsdlLocationURL = CallContext.toWsdlUrl(wsdlLocation);
        this.callbackInfo = null;
    }

    public void setWsdlLocation(File wsdlLocation) throws MalformedURLException {
        this.wsdlLocationURL = wsdlLocation == null ? null : wsdlLocation.toURI().toURL();
        this.callbackInfo = null;
    }

    public void setWsdlLocation(URL wsdlLocation) {
        this.setWsdlLocationURL(wsdlLocation);
    }

    public URL getWsdlLocationURL() {
        return this.wsdlLocationURL;
    }

    public void setWsdlLocationURL(URL wsdlLocationURL) {
        this.wsdlLocationURL = wsdlLocationURL;
        this.callbackInfo = null;
    }

    public CallbackInfo getCallbackInfo() {
        if (this.callbackInfo == null && this.wsdlLocationURL != null) {
            this.callbackInfo = new CallbackInfo(this.wsdlLocationURL);
        }
        return this.callbackInfo;
    }

    public Map<String, String> getUserData() {
        if (this.userData == null) {
            this.userData = new HashMap<String, String>();
        }
        return this.userData;
    }

    public boolean hasUserData() {
        return this.userData != null && !this.userData.isEmpty();
    }

    public static boolean isLogging() {
        return logging;
    }

    public static void setLogging(boolean logging) {
        CallContext.logging = logging;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public static boolean isServiceActivityMonitoring() {
        return serviceActivityMonitoring;
    }

    public static void setServiceActivityMonitoring(boolean value) {
        serviceActivityMonitoring = value;
        if (serviceActivityMonitoring && samContext == null) {
            samContext = new ClassPathXmlApplicationContext(new String[]{"/META-INF/tesb/agent-context.xml"});
        }
    }

    public X509Certificate getRequestorSignatureCertificate() {
        return this.requestorSignatureCertificate;
    }

    public void setRequestorSignatureCertificate(X509Certificate requestorSignatureCertificate) {
        this.requestorSignatureCertificate = requestorSignatureCertificate;
    }

    public <T> T createCallbackProxy(Class<T> proxyInterface) {
        JaxWsProxyFactoryBean callback = new JaxWsProxyFactoryBean();
        callback.setServiceName(this.serviceName);
        callback.setEndpointName(new QName(this.serviceName.getNamespaceURI(), this.serviceName.getLocalPart() + "Port"));
        callback.setAddress(this.replyToAddress);
        callback.setServiceClass(proxyInterface);
        List features = callback.getFeatures();
        features.add(new RequestCallbackFeature());
        if (logging) {
            features.add(new LoggingFeature());
        }
        if (serviceActivityMonitoring) {
            features.add(CallContext.getEventFeature());
        }
        HashMap<String, CallContext> properties = new HashMap<String, CallContext>();
        properties.put("org.talend.esb.mep.requestcallback.CallContext", this);
        callback.setProperties(properties);
        return (T)callback.create(proxyInterface);
    }

    public <T extends Source> Dispatch<T> createCallbackDispatch(Class<T> sourceClass, Service.Mode mode, QName operation, String soapAction, URL wsdlLocationURL, String policyAlias) {
        Dispatch dispatch;
        Service service;
        QName callbackPortName;
        QName callbackServiceName;
        block13: {
            CallbackInfo callbackInfo;
            URL wsdlURL;
            if (wsdlLocationURL == null || wsdlLocationURL.equals(this.wsdlLocationURL)) {
                wsdlURL = CallContext.integrateCallbackSenderPolicyAlias(this.wsdlLocationURL, policyAlias);
                callbackInfo = this.getCallbackInfo();
            } else {
                wsdlURL = CallContext.integrateCallbackSenderPolicyAlias(wsdlLocationURL, policyAlias);
                callbackInfo = new CallbackInfo(wsdlLocationURL);
            }
            if (callbackInfo != null) {
                QName callbackPortTypeName = CallContext.validValue(callbackInfo.getCallbackPortTypeName(), this.portTypeName.getNamespaceURI(), this.portTypeName.getLocalPart(), "Consumer");
                callbackServiceName = CallContext.validValue(callbackInfo.getCallbackServiceName(), callbackPortTypeName.getNamespaceURI(), callbackPortTypeName.getLocalPart(), "Service");
                callbackPortName = CallContext.validValue(callbackInfo.getCallbackPortName(), callbackServiceName.getNamespaceURI(), callbackPortTypeName.getLocalPart(), "Port");
            } else {
                QName callbackPortTypeName = new QName(this.portTypeName.getNamespaceURI(), this.portTypeName.getLocalPart() + "Consumer");
                callbackServiceName = new QName(callbackPortTypeName.getNamespaceURI(), callbackPortTypeName.getLocalPart() + "Service");
                callbackPortName = new QName(callbackPortTypeName.getNamespaceURI(), callbackPortTypeName.getLocalPart() + "Port");
            }
            service = null;
            if (wsdlURL != null) {
                try {
                    service = Service.create((URL)wsdlURL, (QName)callbackServiceName);
                }
                catch (WebServiceException e) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block13;
                    LOGGER.info("Service " + callbackServiceName + " is not defined in WSDL (old-style callback definition");
                    LOGGER.info("Proceeding without callback service model");
                    if (!LOGGER.isLoggable(Level.FINER)) break block13;
                    LOGGER.log(Level.FINER, "Exception caught: ", e);
                }
            }
        }
        if (service != null) {
            if (!service.getPorts().hasNext()) {
                service.addPort(callbackPortName, this.bindingId, this.replyToAddress);
            }
            dispatch = service.createDispatch(callbackPortName, sourceClass, mode);
            dispatch.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.replyToAddress);
        } else {
            service = Service.create((QName)callbackServiceName);
            service.addPort(callbackPortName, this.bindingId, this.replyToAddress);
            dispatch = service.createDispatch(callbackPortName, sourceClass, mode);
        }
        CallContext.setupDispatch(dispatch);
        Map requestContext = dispatch.getRequestContext();
        requestContext.put("org.talend.esb.mep.requestcallback.CallContext", this);
        requestContext.put("thread.local.request.context", Boolean.TRUE);
        if (operation != null) {
            requestContext.put("javax.xml.ws.wsdl.operation", operation);
            requestContext.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
            String action = soapAction == null || soapAction.length() == 0 ? operation.getLocalPart() : soapAction;
            requestContext.put("javax.xml.ws.soap.http.soapaction.uri", action);
        } else if (soapAction != null && soapAction.length() > 0) {
            requestContext.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
            requestContext.put("javax.xml.ws.soap.http.soapaction.uri", soapAction);
        }
        return dispatch;
    }

    public <T extends Source> Dispatch<T> createCallbackDispatch(Class<T> sourceClass, Service.Mode mode, QName operation, String soapAction, URL wsdlLocationURL) {
        return this.createCallbackDispatch(sourceClass, mode, operation, soapAction, wsdlLocationURL, null);
    }

    public <T extends Source> Dispatch<T> createCallbackDispatch(Class<T> sourceClass, Service.Mode mode, QName operation) {
        return this.createCallbackDispatch(sourceClass, mode, operation, null, null);
    }

    public <T extends Source> Dispatch<T> createCallbackDispatch(Class<T> sourceClass, Service.Mode mode, QName operation, String soapAction) {
        return this.createCallbackDispatch(sourceClass, mode, operation, soapAction, null);
    }

    public <T extends Source> Dispatch<T> createCallbackDispatch(Class<T> sourceClass, QName operation, URL wsdlLocation) {
        return this.createCallbackDispatch(sourceClass, Service.Mode.PAYLOAD, operation, null, wsdlLocation);
    }

    public <T extends Source> Dispatch<T> createCallbackDispatch(Class<T> sourceClass, QName operation, String soapAction, URL wsdlLocation) {
        return this.createCallbackDispatch(sourceClass, Service.Mode.PAYLOAD, operation, soapAction, wsdlLocation);
    }

    public <T extends Source> Dispatch<T> createCallbackDispatch(Class<T> sourceClass, QName operation) {
        return this.createCallbackDispatch(sourceClass, Service.Mode.PAYLOAD, operation, null, null);
    }

    public <T extends Source> Dispatch<T> createCallbackDispatch(Class<T> sourceClass, QName operation, String soapAction) {
        return this.createCallbackDispatch(sourceClass, Service.Mode.PAYLOAD, operation, soapAction, null);
    }

    public <T extends Source> Dispatch<T> createCallbackDispatch(Class<T> sourceClass) {
        return this.createCallbackDispatch(sourceClass, Service.Mode.PAYLOAD, null, null, null);
    }

    public Dispatch<StreamSource> createCallbackDispatch(QName operation) {
        return this.createCallbackDispatch(StreamSource.class, Service.Mode.PAYLOAD, operation, null, null);
    }

    public Dispatch<StreamSource> createCallbackDispatch(QName operation, String soapAction) {
        return this.createCallbackDispatch(StreamSource.class, Service.Mode.PAYLOAD, operation, soapAction, null);
    }

    public Dispatch<StreamSource> createCallbackDispatch() {
        return this.createCallbackDispatch(StreamSource.class, Service.Mode.PAYLOAD, null, null, null);
    }

    public <T extends Source> Dispatch<T> createCallbackDispatch(Class<T> sourceClass, Service.Mode mode, QName operation, URL wsdlLocationURL) {
        return this.createCallbackDispatch(sourceClass, mode, operation, null, wsdlLocationURL);
    }

    public static CallContext getCallContext(WebServiceContext wsContext) {
        return CallContext.getCallContext(wsContext.getMessageContext());
    }

    public static CallContext getCallContext(Map<?, ?> contextHolder) {
        try {
            return (CallContext)contextHolder.get("org.talend.esb.mep.requestcallback.CallContext");
        }
        catch (ClassCastException e) {
            LOGGER.warning("Ignoring CallContext value of invalid type in contextual property");
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Exception caught: ", e);
            }
            return null;
        }
    }

    public static Endpoint createCallbackEndpoint(Object implementor, String wsdlLocation) {
        return CallContext.createCallbackEndpoint(implementor, new CallbackInfo(wsdlLocation));
    }

    public static Endpoint createCallbackEndpoint(Object implementor, URL wsdlLocation) {
        return CallContext.createCallbackEndpoint(implementor, new CallbackInfo(wsdlLocation));
    }

    public static void setCallbackEndpoint(Dispatch<?> dispatch, Object callbackEndpoint) {
        dispatch.getRequestContext().put("org.talend.esb.mep.requestcallback.CallbackEndpoint", callbackEndpoint);
    }

    public static void setCallbackEndpoint(Map<String, Object> context, Object callbackEndpoint) {
        context.put("org.talend.esb.mep.requestcallback.CallbackEndpoint", callbackEndpoint);
    }

    public static void setupEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof EndpointImpl)) {
            throw new IllegalArgumentException("Only CXF JAX-WS endpoints supported. ");
        }
        EndpointImpl ep = (EndpointImpl)endpoint;
        ArrayList<RequestCallbackFeature> features = new ArrayList<RequestCallbackFeature>();
        features.add(new RequestCallbackFeature());
        if (logging) {
            features.add((RequestCallbackFeature)new LoggingFeature());
        }
        if (serviceActivityMonitoring) {
            features.add((RequestCallbackFeature)CallContext.getEventFeature());
        }
        if (ep.getFeatures() != null) {
            features.addAll(ep.getFeatures());
        }
        ep.setFeatures(features);
        ep.getProperties().put(NULL_MEANS_ONEWAY, Boolean.TRUE);
    }

    public static void setupDispatch(Dispatch<?> dispatch) {
        if (!(dispatch instanceof DispatchImpl)) {
            throw new IllegalArgumentException("Only CXF JAX-WS Dispatch supported. ");
        }
        DispatchImpl dsp = (DispatchImpl)dispatch;
        Client dispatchClient = dsp.getClient();
        Bus bus = dispatchClient.getBus();
        new RequestCallbackFeature().initialize(dispatchClient, bus);
        if (logging) {
            new LoggingFeature().initialize(dispatchClient, bus);
        }
        if (serviceActivityMonitoring) {
            CallContext.getEventFeature().initialize(dispatchClient, bus);
        }
    }

    public static void setupDispatch(Dispatch<?> dispatch, Object callbackEndpoint) {
        CallContext.setupDispatch(dispatch);
        CallContext.setCallbackEndpoint(dispatch, callbackEndpoint);
    }

    public static void setupServerFactory(JaxWsServerFactoryBean serverFactory) {
        List features = serverFactory.getFeatures();
        features.add(new RequestCallbackFeature());
        if (logging) {
            features.add(new LoggingFeature());
        }
        if (serviceActivityMonitoring) {
            features.add(CallContext.getEventFeature());
        }
        serverFactory.getProperties(true).put(NULL_MEANS_ONEWAY, Boolean.TRUE);
    }

    public <T> void setupCallbackProxy(T proxy) {
        Client client = ClientProxy.getClient(proxy);
        Bus bus = client.getBus();
        new RequestCallbackFeature().initialize(client, bus);
        if (logging) {
            new LoggingFeature().initialize(client, bus);
        }
        if (serviceActivityMonitoring) {
            CallContext.getEventFeature().initialize(client, bus);
        }
        BindingProvider bp = (BindingProvider)proxy;
        bp.getRequestContext().put("thread.local.request.context", Boolean.TRUE);
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.replyToAddress);
        bp.getRequestContext().put("org.talend.esb.mep.requestcallback.CallContext", this);
    }

    public static CallbackInfo createCallbackInfo(String wsdlLocation) {
        return new CallbackInfo(wsdlLocation);
    }

    public static CallbackInfo createCallbackInfo(URL wsdlLocationURL) {
        return new CallbackInfo(wsdlLocationURL.toExternalForm());
    }

    public static void enforceOperation(QName operationName, String soapAction, Dispatch<?> dispatch) {
        CallContext.enforceOperation(operationName, soapAction, dispatch.getRequestContext());
    }

    public static void enforceOperation(QName operationName, Dispatch<?> dispatch) {
        CallContext.enforceOperation(operationName, null, dispatch.getRequestContext());
    }

    public static void enforceOperation(QName operationName, Map<String, Object> requestContext) {
        CallContext.enforceOperation(operationName, null, requestContext);
    }

    public static void enforceOperation(QName operationName, String soapAction, Map<String, Object> requestContext) {
        if (operationName == null) {
            throw new IllegalArgumentException("Invalid operation name: (null) ");
        }
        requestContext.put("javax.xml.ws.wsdl.operation", operationName);
        requestContext.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
        String action = soapAction == null || soapAction.length() == 0 ? operationName.getLocalPart() : soapAction;
        requestContext.put("javax.xml.ws.soap.http.soapaction.uri", action);
    }

    public static Configuration resolveConfiguration(QName serviceName) {
        return ConfigurationInitializer.resolveConfiguration(serviceName);
    }

    public static Endpoint createCallbackEndpoint(Object implementor, CallbackInfo cbInfo) {
        return CallContext.createCallbackEndpoint(implementor, cbInfo, null);
    }

    public static Endpoint createCallbackEndpoint(Object implementor, CallbackInfo cbInfo, String policyAlias) {
        boolean useWsdlLocation;
        String wsdlLocation;
        QName cbInterfaceName;
        Bus bus = BusFactory.getThreadDefaultBus();
        JaxWsServerFactoryBean serverFactory = new JaxWsServerFactoryBean();
        ArrayList<RequestCallbackFeature> features = new ArrayList<RequestCallbackFeature>();
        features.add(new RequestCallbackFeature());
        if (logging) {
            features.add((RequestCallbackFeature)new LoggingFeature());
        }
        if (serviceActivityMonitoring) {
            features.add((RequestCallbackFeature)CallContext.getEventFeature());
        }
        serverFactory.setFeatures(features);
        if (cbInfo == null) {
            cbInterfaceName = null;
            wsdlLocation = null;
        } else {
            cbInterfaceName = cbInfo.getCallbackPortTypeName();
            wsdlLocation = cbInfo.getEffectiveCallbackReceiverWsdlLocation(policyAlias);
        }
        boolean bl = useWsdlLocation = wsdlLocation != null && cbInfo.getCallbackServiceName() != null && cbInfo.getCallbackPortName() != null;
        if (cbInterfaceName != null) {
            QName cbServiceName;
            QName qName = cbServiceName = cbInfo.getCallbackServiceName() == null ? new QName(cbInterfaceName.getNamespaceURI(), cbInterfaceName.getLocalPart() + "Service") : cbInfo.getCallbackServiceName();
            QName cbEndpointName = cbInfo.getCallbackServiceName() == null ? new QName(cbInterfaceName.getNamespaceURI(), cbInterfaceName.getLocalPart() + "ServicePort") : new QName(cbServiceName.getNamespaceURI(), cbInfo.getCallbackPortName() == null ? cbServiceName.getLocalPart() + "Port" : cbInfo.getCallbackPortName());
            serverFactory.setServiceName(cbServiceName);
            serverFactory.setEndpointName(cbEndpointName);
            List svcConfigs = serverFactory.getServiceFactory().getServiceConfigurations();
            ListIterator<CallbackDefaultServiceConfiguration> it = svcConfigs.listIterator();
            while (it.hasNext()) {
                AbstractServiceConfiguration cfg = (AbstractServiceConfiguration)it.next();
                if (!(cfg instanceof DefaultServiceConfiguration)) continue;
                CallbackDefaultServiceConfiguration ncfg = new CallbackDefaultServiceConfiguration(cbInfo);
                it.set(ncfg);
            }
            if (useWsdlLocation) {
                serverFactory.setWsdlLocation(wsdlLocation);
            }
        }
        EndpointImpl endpoint = new EndpointImpl(bus, implementor, serverFactory);
        endpoint.setFeatures(features);
        endpoint.getProperties().put(NULL_MEANS_ONEWAY, Boolean.TRUE);
        if (cbInterfaceName != null) {
            endpoint.setEndpointName(serverFactory.getEndpointName());
            endpoint.setServiceName(serverFactory.getServiceName());
            if (useWsdlLocation) {
                endpoint.setWsdlLocation(wsdlLocation);
            }
        }
        return endpoint;
    }

    private static Feature getEventFeature() {
        return (Feature)samContext.getBean("eventFeature");
    }

    private static URL toWsdlUrl(String wsdlLocation) throws MalformedURLException {
        if (wsdlLocation == null || wsdlLocation.length() == 0) {
            return null;
        }
        if (CallContext.isWsdlUrlString(wsdlLocation)) {
            if (wsdlLocation.startsWith(CLASSPATH_URL_PREFIX)) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    return null;
                }
                int len = wsdlLocation.length();
                for (int ndx = CLASSPATH_URL_PREFIX_LENGTH; ndx < len; ++ndx) {
                    if (wsdlLocation.charAt(ndx) == '/') continue;
                    return cl.getResource(wsdlLocation.substring(ndx));
                }
                return null;
            }
            return new URL(wsdlLocation);
        }
        return new File(wsdlLocation).toURI().toURL();
    }

    private static boolean isWsdlUrlString(String wsdlLocation) {
        if (wsdlLocation == null || wsdlLocation.length() == 0) {
            return false;
        }
        return wsdlLocation.startsWith("file:/") || wsdlLocation.startsWith("http://") || wsdlLocation.startsWith("https://") || wsdlLocation.startsWith(CLASSPATH_URL_PREFIX);
    }

    private static QName validValue(QName value, String defaultNamespaceURI, String defaultLocalNameBase, String defaultSuffix) {
        if (value != null) {
            return value;
        }
        return new QName(defaultNamespaceURI, defaultLocalNameBase + defaultSuffix);
    }

    private static QName validValue(String localValue, String defaultNamespaceURI, String defaultLocalNameBase, String defaultSuffix) {
        if (localValue != null && localValue.length() > 0) {
            return new QName(defaultNamespaceURI, localValue);
        }
        return new QName(defaultNamespaceURI, defaultLocalNameBase + defaultSuffix);
    }

    private static URL integrateCallbackSenderPolicyAlias(URL wsdlURL, String alias) {
        if (EFFECTIVE_POLICY_DISTRIBUTION_MODE == PolicyDistributionMode.SERVICE) {
            return wsdlURL;
        }
        if (wsdlURL == null || alias == null || alias.length() == 0) {
            return wsdlURL;
        }
        String query = wsdlURL.getQuery();
        if (query == null || query.length() == 0) {
            return wsdlURL;
        }
        if (query.indexOf("mergeWithPolicies=true") >= 0 && query.indexOf("participant=consumer") >= 0 && query.indexOf("consumerPolicyAlias=") < 0) {
            try {
                return new URL(wsdlURL.toExternalForm() + "&consumerPolicyAlias=" + alias);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Bad alias String: " + alias + ". ", e);
            }
        }
        return wsdlURL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PolicyDistributionMode effectivePolicyDistributionMode() {
        Properties props = new Properties();
        try (InputStream propertyStream = CallContext.class.getClassLoader().getResourceAsStream(POLICY_DISTRIBUTION_MODE_CONFIG);){
            if (propertyStream == null) {
                PolicyDistributionMode policyDistributionMode = DEFAULT_POLICY_DISTRIBUTION_MODE;
                return policyDistributionMode;
            }
            props.load(propertyStream);
        }
        catch (IOException e) {
            if (!LOGGER.isLoggable(Level.FINER)) return DEFAULT_POLICY_DISTRIBUTION_MODE;
            LOGGER.log(Level.FINER, "Exception caught. ", e);
            return DEFAULT_POLICY_DISTRIBUTION_MODE;
        }
        String modeName = props.getProperty(POLICY_DISTRIBUTION_MODE_PROPERTY);
        if (modeName == null) return DEFAULT_POLICY_DISTRIBUTION_MODE;
        if (modeName.length() == 0) {
            return DEFAULT_POLICY_DISTRIBUTION_MODE;
        }
        if ("exchange".equalsIgnoreCase(modeName)) {
            return PolicyDistributionMode.EXCHANGE;
        }
        if (!"service".equalsIgnoreCase(modeName)) return DEFAULT_POLICY_DISTRIBUTION_MODE;
        return PolicyDistributionMode.SERVICE;
    }

    public static enum PolicyDistributionMode {
        EXCHANGE,
        SERVICE;

    }
}

