/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.impl;

import java.util.Dictionary;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.talend.esb.mep.requestcallback.feature.Configuration;
import org.talend.esb.mep.requestcallback.impl.StandardNamespaceUriEncoder;

public abstract class AbstractConfiguration
implements Configuration {
    private static final Logger LOGGER = LogUtils.getL7dLogger(AbstractConfiguration.class);
    public static final String CONFIG_ID_PREFIX = "org.talend.esb.mep.requestcallback";
    private static NamespaceUriEncoder namespaceUriEncoder = new StandardNamespaceUriEncoder();

    protected AbstractConfiguration() {
    }

    @Override
    public String getProperty(String key) {
        Object raw = this.get(key);
        return raw == null ? null : raw.toString();
    }

    @Override
    public Integer getIntegerProperty(String key) {
        Object raw = this.get(key);
        if (raw == null) {
            return null;
        }
        if (raw instanceof Integer) {
            return (Integer)raw;
        }
        if (raw instanceof Number) {
            return new Integer(((Number)raw).intValue());
        }
        try {
            return Integer.valueOf(raw.toString());
        }
        catch (NumberFormatException e) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Exception caught: ", e);
            }
            return null;
        }
    }

    @Override
    public Long getLongProperty(String key) {
        Object raw = this.get(key);
        if (raw == null) {
            return null;
        }
        if (raw instanceof Long) {
            return (Long)raw;
        }
        if (raw instanceof Number) {
            return new Long(((Number)raw).longValue());
        }
        try {
            return Long.valueOf(raw.toString());
        }
        catch (NumberFormatException e) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Exception caught: ", e);
            }
            return null;
        }
    }

    @Override
    public Boolean getBooleanProperty(String key) {
        Object raw = this.get(key);
        if (raw == null) {
            return null;
        }
        if (raw instanceof Boolean) {
            return (Boolean)raw;
        }
        return Boolean.valueOf(raw.toString());
    }

    @Override
    public Configuration.PidMode getPidModeProperty(String key) {
        Object raw = this.get(key);
        if (raw == null) {
            return null;
        }
        if (raw instanceof Configuration.PidMode) {
            return (Configuration.PidMode)((Object)raw);
        }
        String s = raw.toString();
        if ("fullName".equalsIgnoreCase(s)) {
            return Configuration.PidMode.FULL_NAME;
        }
        if ("localName".equalsIgnoreCase(s)) {
            return Configuration.PidMode.LOCAL_NAME;
        }
        return null;
    }

    @Override
    public String getExpandedProperty(String key) {
        return AbstractConfiguration.expandedValue(this.get(key), this);
    }

    @Override
    public void fillProperties(String prefix, Map<? super String, Object> properties) {
        AbstractConfiguration.transferProperties(prefix, this, properties);
    }

    @Override
    public void fillExpandedProperties(String prefix, Map<? super String, Object> properties) {
        AbstractConfiguration.transferExpandedProperties(prefix, this, properties, this);
    }

    @Override
    public void updateDynamicConfiguration(Map<?, ?> updateMap, boolean replaceCurrent) {
    }

    @Override
    public void updateDynamicConfiguration(Dictionary<?, ?> updateDict, boolean replaceCurrent) {
    }

    @Override
    public void refreshStaticConfiguration() {
    }

    @Override
    public QName getConfigurationName() {
        return null;
    }

    @Override
    public String getConfigurationIdentifier() {
        return null;
    }

    @Override
    public String getAlternateConfigurationIdentifier() {
        return null;
    }

    @Override
    public Configuration.ChangeListener getChangeListener() {
        return null;
    }

    @Override
    public void setChangeListener(Configuration.ChangeListener changeListener) {
    }

    public static String expandedValue(Object rawValue, Map<?, ?> replacements) {
        if (rawValue == null) {
            return null;
        }
        String input = rawValue.toString();
        int varStart = input.indexOf("${");
        if (varStart < 0) {
            return input;
        }
        int strlen = input.length();
        StringBuilder buf = new StringBuilder(input.substring(0, varStart));
        varStart += 2;
        while (varStart < strlen) {
            String varKey;
            Object varValue;
            int varEnd = input.indexOf("}", varStart);
            if (varEnd < 0) {
                varEnd = strlen;
            }
            Object object = varValue = (varKey = input.substring(varStart, varEnd)).length() > 0 ? (Object)replacements.get(varKey) : null;
            if (varValue != null) {
                buf.append(varValue.toString());
            }
            varStart = ++varEnd;
            if (varEnd < strlen) {
                varStart = input.indexOf("${", varEnd);
                if (varStart < 0) {
                    varStart = strlen;
                }
                buf.append(input.substring(varEnd, varStart));
            }
            varStart += 2;
        }
        return buf.toString();
    }

    public static void transferProperties(String prefix, Map<String, Object> source, Map<? super String, Object> target) {
        String fullPrefix;
        String string = fullPrefix = prefix == null ? null : prefix + ".";
        if (fullPrefix == null) {
            target.putAll(source);
            return;
        }
        for (Map.Entry<String, Object> e : source.entrySet()) {
            String key = e.getKey();
            if (!key.startsWith(fullPrefix)) continue;
            target.put(key.substring(fullPrefix.length()), e.getValue());
        }
    }

    public static void transferExpandedProperties(String prefix, Map<String, Object> source, Map<? super String, Object> target, Map<?, ?> replacements) {
        String fullPrefix = prefix == null ? null : prefix + ".";
        for (Map.Entry<String, Object> e : source.entrySet()) {
            String key = e.getKey();
            if (fullPrefix == null) {
                target.put(key, AbstractConfiguration.expandedValue(e.getValue(), replacements));
                continue;
            }
            if (!key.startsWith(fullPrefix)) continue;
            target.put(key.substring(fullPrefix.length()), AbstractConfiguration.expandedValue(e.getValue(), replacements));
        }
    }

    public static String asConfigIdentifier(QName serviceName) {
        String localName;
        if (serviceName == null) {
            return CONFIG_ID_PREFIX;
        }
        StringBuilder buf = new StringBuilder(CONFIG_ID_PREFIX);
        String namespaceName = serviceName.getNamespaceURI();
        if (namespaceName != null && namespaceName.length() > 0) {
            buf.append(".").append(namespaceUriEncoder.encodedNamespaceURI(namespaceName));
        }
        if ((localName = serviceName.getLocalPart()) != null && localName.length() > 0) {
            buf.append(".").append(localName);
        }
        return buf.toString();
    }

    public static String asConfigIdentifier(String serviceLocalName) {
        if (serviceLocalName == null || serviceLocalName.length() == 0) {
            return CONFIG_ID_PREFIX;
        }
        if (serviceLocalName.startsWith("{")) {
            return AbstractConfiguration.asConfigIdentifier(QName.valueOf(serviceLocalName));
        }
        return "org.talend.esb.mep.requestcallback." + serviceLocalName;
    }

    public static NamespaceUriEncoder getNamespaceUriEncoder() {
        return namespaceUriEncoder;
    }

    public static void setNamespaceUriEncoder(NamespaceUriEncoder encoder) {
        namespaceUriEncoder = encoder;
    }

    public static interface NamespaceUriEncoder {
        public String encodedNamespaceURI(String var1);
    }
}

