/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.compression.feature;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Message;
import org.talend.esb.policy.compression.impl.CompressionInInterceptor;
import org.talend.esb.policy.compression.impl.CompressionOutInterceptor;

public class CompressionFeature
extends AbstractFeature {
    private static final Logger LOG = Logger.getLogger(CompressionFeature.class.getName());
    int threshold = -1;

    public void initialize(Client client, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing Compression feature for bus " + bus + " and client " + client);
        }
        this.initializeProvider((InterceptorProvider)client, bus);
    }

    public void initialize(Server server, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing Compression feature for bus " + bus + " and server " + server);
        }
        this.initializeProvider((InterceptorProvider)server.getEndpoint(), bus);
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        CompressionOutInterceptor out = new CompressionOutInterceptor();
        CompressionInInterceptor in = new CompressionInInterceptor();
        out.setThreshold(this.getThreshold());
        this.remove(provider.getOutInterceptors());
        this.remove(provider.getOutFaultInterceptors());
        provider.getOutInterceptors().add(out);
        provider.getOutFaultInterceptors().add(out);
        provider.getInInterceptors().add(in);
    }

    private void remove(List<Interceptor<? extends Message>> outInterceptors) {
        int x = outInterceptors.size();
        while (x > 0) {
            if (!(outInterceptors.get(--x) instanceof CompressionOutInterceptor)) continue;
            outInterceptors.remove(x);
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }
}

