/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.compression.impl.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Scanner;
import java.util.regex.MatchResult;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.helpers.IOUtils;

public class CompressionHelper {
    public static int SOAP_BODY_WRAPPER_INDX = 0;
    public static int SOAP_BODY_INDX = 2;

    public static MatchResult loadSoapBodyContent(OutputStream destination, Scanner scanner, String pattern) throws XMLStreamException {
        try {
            scanner.findWithinHorizon(pattern, 0);
            MatchResult result = scanner.match();
            String bodyContent = result.group(SOAP_BODY_INDX);
            if (bodyContent != null) {
                destination.write(bodyContent.getBytes());
                MatchResult matchResult = result;
                return matchResult;
            }
            try {
                throw new RuntimeException("Compression: Can not find SOAP body");
            }
            catch (IllegalStateException ex) {
                MatchResult matchResult = null;
                return matchResult;
            }
            catch (Exception ex) {
                throw new RuntimeException("Compression: can not read SOAP body content", ex);
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    public static void replaceBodyInSOAP(byte[] originalSoap, MatchResult bodyPosition, InputStream newBody, OutputStream out, String wrapperStartTag, String wrapperEndTag, boolean removeWrapper) throws IOException, XMLStreamException {
        int patternGroupIndex = removeWrapper ? SOAP_BODY_WRAPPER_INDX : SOAP_BODY_INDX;
        int orgBodyStart = bodyPosition.start(patternGroupIndex);
        int orgBodyEnd = bodyPosition.end(patternGroupIndex);
        out.write(originalSoap, 0, orgBodyStart);
        if (wrapperStartTag != null) {
            out.write(wrapperStartTag.getBytes());
        }
        IOUtils.copyAndCloseInput((InputStream)newBody, (OutputStream)out);
        if (wrapperEndTag != null) {
            out.write(wrapperEndTag.getBytes());
        }
        out.write(originalSoap, orgBodyEnd, originalSoap.length - orgBodyEnd);
    }
}

