/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.schemavalidate.interceptors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.xmlschema.LSInputImpl;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.talend.esb.policy.schemavalidate.SchemaValidationPolicy;
import org.talend.esb.policy.schemavalidate.SchemaValidationPolicyBuilder;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public abstract class SchemaValidationPolicyAbstractInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected SchemaValidationPolicy policy = null;

    public SchemaValidationPolicyAbstractInterceptor(String phase) {
        super(phase);
    }

    public SchemaValidationPolicyAbstractInterceptor(String phase, SchemaValidationPolicy policy) {
        super(phase);
        this.policy = policy;
    }

    public void handleMessage(Message message) throws Fault {
        if (this.policy == null) {
            this.handleMessageWithAssertionInfo(message);
        } else {
            this.handleMessageWithoutAssertionInfo(message);
        }
    }

    protected void handleMessageWithAssertionInfo(Message message) throws Fault {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (null == aim) {
            return;
        }
        Collection ais = (Collection)aim.get((Object)SchemaValidationPolicyBuilder.SCHEMA_VALIDATION);
        if (null == ais) {
            return;
        }
        for (AssertionInfo ai : ais) {
            if (ai.getAssertion() instanceof SchemaValidationPolicy) {
                SchemaValidationPolicy vPolicy = (SchemaValidationPolicy)ai.getAssertion();
                SchemaValidationPolicy.ValidationType vldType = vPolicy.getValidationType();
                SchemaValidationPolicy.AppliesToType appliesToType = vPolicy.getApplyToType();
                SchemaValidationPolicy.MessageType msgType = vPolicy.getMessageType();
                String customSchemaPath = vPolicy.getCustomSchemaPath();
                if (vldType != SchemaValidationPolicy.ValidationType.WSDLSchema) {
                    ai.setAsserted(true);
                }
                if (this.shouldSchemaValidate(message, msgType, appliesToType)) {
                    if (vldType == SchemaValidationPolicy.ValidationType.CustomSchema) {
                        try {
                            this.loadCustomSchema(message, customSchemaPath, ((Object)((Object)this)).getClass());
                        }
                        catch (IOException ex) {
                            throw new RuntimeException("Can not load custom schema", ex);
                        }
                    }
                    this.validateBySettingProperty(message);
                }
                ai.setAsserted(true);
            }
            ai.setAsserted(true);
        }
    }

    protected void handleMessageWithoutAssertionInfo(Message message) throws Fault {
        SchemaValidationPolicy.ValidationType vldType = this.policy.getValidationType();
        SchemaValidationPolicy.AppliesToType appliesToType = this.policy.getApplyToType();
        SchemaValidationPolicy.MessageType msgType = this.policy.getMessageType();
        String customSchemaPath = this.policy.getCustomSchemaPath();
        if (this.shouldSchemaValidate(message, msgType, appliesToType)) {
            if (vldType == SchemaValidationPolicy.ValidationType.CustomSchema) {
                try {
                    this.loadCustomSchema(message, customSchemaPath, ((Object)((Object)this)).getClass());
                }
                catch (IOException ex) {
                    throw new RuntimeException("Can not load custom schema", ex);
                }
            }
            this.validateBySettingProperty(message);
        }
    }

    protected void loadCustomSchema(Message message, String customSchemaPath, Class c) throws IOException {
        Schema customSchema;
        if (customSchemaPath == null || customSchemaPath.trim().isEmpty()) {
            throw new IllegalArgumentException("Path to custom schema is not set or empty");
        }
        String absoluteSchemaPath = null;
        CachedOutputStream cos = new CachedOutputStream();
        absoluteSchemaPath = this.loadResource(customSchemaPath, (OutputStream)cos);
        InputStream customSchemaStream = cos.getInputStream();
        SchemaResourceResolver resourceResolver = null;
        try {
            if (customSchemaStream == null) {
                throw new IllegalArgumentException("Cannot load custom schema from path: " + customSchemaPath);
            }
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            resourceResolver = new SchemaResourceResolver(absoluteSchemaPath, customSchemaPath);
            factory.setResourceResolver(resourceResolver);
            StreamSource src = new StreamSource(customSchemaStream);
            customSchema = factory.newSchema(src);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Cannot create custom schema from path: " + customSchemaPath + "\n" + e.getMessage(), e);
        }
        finally {
            try {
                cos.close();
                if (resourceResolver != null) {
                    resourceResolver.cleanupCache();
                }
            }
            catch (IOException iOException) {}
        }
        ((ServiceInfo)message.getExchange().getService().getServiceInfos().get(0)).setProperty(Schema.class.getName(), (Object)customSchema);
    }

    private String loadResource(String path, OutputStream output) throws IOException {
        URL url;
        InputStream resource = null;
        String absolutePath = null;
        try {
            resource = new FileInputStream(path);
            if (resource != null) {
                absolutePath = path;
            }
        }
        catch (FileNotFoundException e) {
            resource = null;
        }
        if (resource == null && (resource = ClassLoaderUtils.getResourceAsStream((String)path, ((Object)((Object)this)).getClass())) != null && (url = ClassLoaderUtils.getResource((String)path, ((Object)((Object)this)).getClass())) != null) {
            absolutePath = url.getPath();
        }
        if (resource == null) {
            try {
                url = new URL(path);
                resource = url.openStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resource != null) {
            IOUtils.copyAndCloseInput((InputStream)resource, (OutputStream)output);
            return absolutePath;
        }
        return null;
    }

    protected boolean shouldSchemaValidate(Message message, SchemaValidationPolicy.MessageType msgType, SchemaValidationPolicy.AppliesToType appliesToType) {
        if (MessageUtils.isRequestor((Message)message)) {
            if (MessageUtils.isOutbound((Message)message)) {
                return !(appliesToType != SchemaValidationPolicy.AppliesToType.consumer && appliesToType != SchemaValidationPolicy.AppliesToType.always || msgType != SchemaValidationPolicy.MessageType.request && msgType != SchemaValidationPolicy.MessageType.all);
            }
            return !(appliesToType != SchemaValidationPolicy.AppliesToType.consumer && appliesToType != SchemaValidationPolicy.AppliesToType.always || msgType != SchemaValidationPolicy.MessageType.response && msgType != SchemaValidationPolicy.MessageType.all);
        }
        if (MessageUtils.isOutbound((Message)message)) {
            return !(appliesToType != SchemaValidationPolicy.AppliesToType.provider && appliesToType != SchemaValidationPolicy.AppliesToType.always || msgType != SchemaValidationPolicy.MessageType.response && msgType != SchemaValidationPolicy.MessageType.all);
        }
        return !(appliesToType != SchemaValidationPolicy.AppliesToType.provider && appliesToType != SchemaValidationPolicy.AppliesToType.always || msgType != SchemaValidationPolicy.MessageType.request && msgType != SchemaValidationPolicy.MessageType.all);
    }

    protected abstract void validateBySettingProperty(Message var1);

    class SchemaResourceResolver
    implements LSResourceResolver {
        List<CachedOutputStream> cacheList = new ArrayList<CachedOutputStream>();
        String parentSchemaAbsolutePath = null;
        String parentSchemaProvidedPath = null;

        public SchemaResourceResolver(String parentSchemaAbsolutePath, String parentSchemaProvidedPath) {
            this.parentSchemaAbsolutePath = parentSchemaAbsolutePath;
            this.parentSchemaProvidedPath = parentSchemaProvidedPath;
        }

        public void cleanupCache() {
            for (CachedOutputStream cache : this.cacheList) {
                try {
                    cache.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            File file;
            boolean isRemoteLocation = systemId != null && (systemId.startsWith("http://") || systemId.startsWith("https://"));
            String parentSchemaDir = "";
            if (this.parentSchemaAbsolutePath != null && !isRemoteLocation && (file = new File(this.parentSchemaAbsolutePath)).exists()) {
                parentSchemaDir = file.getParentFile().getAbsolutePath();
            }
            String resURL = null;
            if (systemId != null) {
                String schemaLocation = "";
                if (baseURI != null) {
                    schemaLocation = baseURI.substring(0, baseURI.lastIndexOf("/") + 1);
                }
                resURL = !isRemoteLocation ? schemaLocation + systemId : systemId;
            } else if (namespaceURI != null) {
                resURL = namespaceURI;
                isRemoteLocation = true;
            }
            CachedOutputStream cache = new CachedOutputStream();
            this.cacheList.add(cache);
            InputStream resourceStream = null;
            String actualSchemaURL = null;
            try {
                actualSchemaURL = resURL;
                SchemaValidationPolicyAbstractInterceptor.this.loadResource(actualSchemaURL, (OutputStream)cache);
                if (cache.size() == 0L && parentSchemaDir != null && !parentSchemaDir.isEmpty() && !isRemoteLocation) {
                    actualSchemaURL = parentSchemaDir + File.separator + resURL;
                    SchemaValidationPolicyAbstractInterceptor.this.loadResource(actualSchemaURL, (OutputStream)cache);
                }
                resourceStream = cache.getInputStream();
            }
            catch (IOException ex) {
                return null;
            }
            if (cache.size() != 0L) {
                LSInputImpl resource = new LSInputImpl();
                resource.setSystemId(actualSchemaURL);
                resource.setPublicId(publicId);
                resource.setByteStream(resourceStream);
                return resource;
            }
            StringBuilder message = new StringBuilder();
            message.append("Schema validation: can not load internal schema with path {");
            if (systemId == null) {
                message.append(resURL);
            } else {
                message.append(systemId);
            }
            message.append("}");
            throw new RuntimeException(message.toString());
        }
    }
}

