/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.endpoint.ClientLifeCycleListener;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.talend.esb.sam.agent.lifecycle.ClientListenerImpl;
import org.talend.esb.sam.agent.lifecycle.ServiceListenerImpl;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.MonitoringException;
import org.talend.esb.sam.common.service.MonitoringService;
import org.talend.esb.sam.common.spi.EventFilter;
import org.talend.esb.sam.common.spi.EventHandler;

public class EventCollector
implements BusLifeCycleListener {
    private static final Logger LOG = Logger.getLogger(EventCollector.class.getName());
    private Bus bus;
    private MonitoringService monitoringServiceClient;
    @Autowired(required=false)
    private List<EventFilter> filters = new ArrayList<EventFilter>();
    private List<EventHandler> handlers = new ArrayList<EventHandler>();
    private Queue<Event> queue;
    private TaskExecutor executor;
    private TaskScheduler scheduler;
    private long defaultInterval = 1000L;
    private int eventsPerMessageCall = 10;
    private boolean sendLifecycleEvent;
    private boolean stopSending;

    public EventCollector() {
        if (this.bus != null) {
            BusLifeCycleManager lm = (BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class);
            if (null != lm) {
                lm.registerLifeCycleListener((BusLifeCycleListener)this);
            }
            if (this.sendLifecycleEvent) {
                ClientLifeCycleManager clcm;
                ServerLifeCycleManager slcm = (ServerLifeCycleManager)this.bus.getExtension(ServerLifeCycleManager.class);
                if (null != slcm) {
                    ServiceListenerImpl svrListener = new ServiceListenerImpl();
                    svrListener.setSendLifecycleEvent(this.sendLifecycleEvent);
                    svrListener.setQueue(this.queue);
                    svrListener.setMonitoringServiceClient(this.monitoringServiceClient);
                    slcm.registerListener((ServerLifeCycleListener)svrListener);
                }
                if (null != (clcm = (ClientLifeCycleManager)this.bus.getExtension(ClientLifeCycleManager.class))) {
                    ClientListenerImpl cltListener = new ClientListenerImpl();
                    cltListener.setSendLifecycleEvent(this.sendLifecycleEvent);
                    cltListener.setQueue(this.queue);
                    cltListener.setMonitoringServiceClient(this.monitoringServiceClient);
                    clcm.registerListener((ClientLifeCycleListener)cltListener);
                }
            }
        }
    }

    public int getEventsPerMessageCall() {
        if (this.eventsPerMessageCall <= 0) {
            LOG.warning("Message package size is not set or is lower then 1. Set package size to 1.");
            return 1;
        }
        return this.eventsPerMessageCall;
    }

    public void setEventsPerMessageCall(int eventsPerMessageCall) {
        this.eventsPerMessageCall = eventsPerMessageCall;
    }

    private long getDefaultInterval() {
        return this.defaultInterval;
    }

    public void setDefaultInterval(long defaultInterval) {
        if (defaultInterval <= 0L) {
            LOG.severe("collector.scheduler.interval must be greater than 0. Recommended value is 500-1000. Current value is " + defaultInterval);
            throw new IllegalArgumentException("collector.scheduler.interval must be greater than 0. Recommended value is 500-1000. Current value is " + defaultInterval);
        }
        this.defaultInterval = defaultInterval;
    }

    public void setSendLifecycleEvent(boolean sendLifecycleEvent) {
        this.sendLifecycleEvent = sendLifecycleEvent;
    }

    public void setScheduler(TaskScheduler scheduler) {
        LOG.info("Scheduler started for sending events to SAM Server");
        this.scheduler = scheduler;
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                EventCollector.this.sendEventsFromQueue();
            }
        }, this.getDefaultInterval());
    }

    public void setExecutor(TaskExecutor executor) {
        this.executor = executor;
    }

    public void setQueue(Queue<Event> queue) {
        this.queue = queue;
    }

    public void setMonitoringServiceClient(MonitoringService monitoringServiceClient) {
        this.monitoringServiceClient = monitoringServiceClient;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public List<EventFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<EventFilter> filters) {
        this.filters = filters;
    }

    public List<EventHandler> getHandlers() {
        return this.handlers;
    }

    @Autowired(required=false)
    public void setHandlers(List<EventHandler> newHandlers) {
        this.handlers.clear();
        for (EventHandler eventHandler : newHandlers) {
            this.handlers.add(eventHandler);
        }
    }

    public void sendEventsFromQueue() {
        if (this.stopSending) {
            return;
        }
        LOG.fine("Scheduler called for sending events");
        int packageSize = this.getEventsPerMessageCall();
        while (!this.queue.isEmpty()) {
            final ArrayList<Event> list = new ArrayList<Event>();
            int i = 0;
            while (i < packageSize && !this.queue.isEmpty()) {
                Event event = this.queue.remove();
                if (event == null || this.filter(event)) continue;
                list.add(event);
                ++i;
            }
            if (list.size() <= 0) continue;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        EventCollector.this.sendEvents(list);
                    }
                    catch (MonitoringException e) {
                        e.logException(Level.SEVERE);
                    }
                }
            });
        }
    }

    private boolean filter(Event event) {
        for (EventFilter filter : this.filters) {
            if (!filter.filter(event)) continue;
            return true;
        }
        return false;
    }

    private void sendEvents(List<Event> events) {
        for (EventHandler current : this.handlers) {
            for (Event event : events) {
                current.handleEvent(event);
            }
        }
        LOG.info("Put events(" + events.size() + ") to Monitoring Server.");
        try {
            this.monitoringServiceClient.putEvents(events);
        }
        catch (MonitoringException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MonitoringException("002", "Unknown error while execute put events to Monitoring Server", (Throwable)e);
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
        LOG.info("Bus is stopping. Stopping sending events to monitoring service.");
        this.stopSending = true;
    }

    public void postShutdown() {
    }
}

