/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.feature;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.ops4j.pax.cdi.api.OsgiServiceProvider;
import org.springframework.beans.factory.annotation.Value;
import org.talend.esb.sam.agent.eventproducer.EventProducerInterceptor;
import org.talend.esb.sam.agent.eventproducer.MessageToEventMapper;
import org.talend.esb.sam.agent.feature.EventFeature;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdProducerIn;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdProducerOut;
import org.talend.esb.sam.agent.queue.EventQueue;
import org.talend.esb.sam.agent.wiretap.WireTapIn;
import org.talend.esb.sam.agent.wiretap.WireTapOut;

@OsgiServiceProvider(classes={EventFeature.class})
@Named(value="eventFeature")
@Singleton
public class EventFeatureImpl
extends AbstractFeature
implements EventFeature {
    private boolean logMessageContent = true;
    private int maxContentLength = -1;
    private boolean enforceMessageIDTransfer;
    private EventProducerInterceptor epi;

    public void initialize(Server server, Bus bus) {
        if (server.getEndpoint().getBinding() instanceof SoapBinding && this.enforceMessageIDTransfer && !this.detectWSAddressingFeature((InterceptorProvider)server.getEndpoint(), bus)) {
            this.addWSAddressingInterceptors((InterceptorProvider)server.getEndpoint());
        }
        this.initializeProvider((InterceptorProvider)server.getEndpoint(), bus);
    }

    public void initialize(Client client, Bus bus) {
        if (client.getEndpoint().getBinding() instanceof SoapBinding && this.enforceMessageIDTransfer && !this.detectWSAddressingFeature((InterceptorProvider)client, bus)) {
            this.addWSAddressingInterceptors((InterceptorProvider)client);
        }
        this.initializeProvider((InterceptorProvider)client, bus);
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        super.initializeProvider(provider, bus);
        FlowIdProducerIn flowIdProducerIn = new FlowIdProducerIn();
        provider.getInInterceptors().add(flowIdProducerIn);
        provider.getInFaultInterceptors().add(flowIdProducerIn);
        FlowIdProducerOut flowIdProducerOut = new FlowIdProducerOut();
        provider.getOutInterceptors().add(flowIdProducerOut);
        provider.getOutFaultInterceptors().add(flowIdProducerOut);
        WireTapIn wireTapIn = new WireTapIn(this.logMessageContent);
        provider.getInInterceptors().add(wireTapIn);
        provider.getInInterceptors().add(this.epi);
        provider.getInFaultInterceptors().add(this.epi);
        WireTapOut wireTapOut = new WireTapOut((Interceptor<Message>)this.epi, this.logMessageContent);
        provider.getOutInterceptors().add(wireTapOut);
        provider.getOutFaultInterceptors().add(wireTapOut);
    }

    @Override
    @Value(value="${log.messageContent}")
    public void setLogMessageContent(boolean logMessageContent) {
        this.logMessageContent = logMessageContent;
    }

    @Override
    @Value(value="${log.maxContentLength}")
    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    @Override
    @Value(value="${log.enforceMessageIDTransfer}")
    public void setEnforceMessageIDTransfer(boolean enforceMessageIDTransfer) {
        this.enforceMessageIDTransfer = enforceMessageIDTransfer;
    }

    @Inject
    public void setQueue(EventQueue queue) {
        if (this.epi == null) {
            MessageToEventMapper mapper = new MessageToEventMapper();
            mapper.setMaxContentLength(this.maxContentLength);
            this.epi = new EventProducerInterceptor(mapper, queue);
        }
    }

    private boolean detectWSAddressingFeature(InterceptorProvider provider, Bus bus) {
        if (bus.getFeatures() != null) {
            for (Feature busFeature : bus.getFeatures()) {
                if (!(busFeature instanceof WSAddressingFeature)) continue;
                return true;
            }
        }
        for (Interceptor ic : provider.getInInterceptors()) {
            if (!(ic instanceof MAPAggregator)) continue;
            return true;
        }
        return false;
    }

    private void addWSAddressingInterceptors(InterceptorProvider provider) {
        MAPAggregator mapAggregator = new MAPAggregator();
        MAPCodec mapCodec = new MAPCodec();
        provider.getInInterceptors().add(mapAggregator);
        provider.getInInterceptors().add(mapCodec);
        provider.getOutInterceptors().add(mapAggregator);
        provider.getOutInterceptors().add(mapCodec);
        provider.getInFaultInterceptors().add(mapAggregator);
        provider.getInFaultInterceptors().add(mapCodec);
        provider.getOutFaultInterceptors().add(mapAggregator);
        provider.getOutFaultInterceptors().add(mapCodec);
    }
}

