/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.lifecycle;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.endpoint.Endpoint;
import org.talend.esb.sam.agent.queue.EventQueue;
import org.talend.esb.sam.agent.util.Converter;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.EventTypeEnum;
import org.talend.esb.sam.common.event.MessageInfo;
import org.talend.esb.sam.common.event.Originator;
import org.talend.esb.sam.common.service.MonitoringService;

public class AbstractListenerImpl {
    private static final Logger LOG = Logger.getLogger(AbstractListenerImpl.class.getName());
    private boolean sendLifecycleEvent;
    private EventQueue queue;
    private MonitoringService monitoringServiceClient;

    public void setSendLifecycleEvent(boolean sendLifecycleEvent) {
        this.sendLifecycleEvent = sendLifecycleEvent;
    }

    public void setQueue(EventQueue queue) {
        this.queue = queue;
    }

    public void setMonitoringServiceClient(MonitoringService monitoringServiceClient) {
        this.monitoringServiceClient = monitoringServiceClient;
    }

    protected void processStart(Endpoint endpoint, EventTypeEnum eventType) {
        if (!this.sendLifecycleEvent) {
            return;
        }
        Event event = this.createEvent(endpoint, eventType);
        this.queue.add(event);
    }

    protected void processStop(Endpoint endpoint, EventTypeEnum eventType) {
        if (!this.sendLifecycleEvent) {
            return;
        }
        Event event = this.createEvent(endpoint, eventType);
        this.monitoringServiceClient.putEvents(Collections.singletonList(event));
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Send " + eventType + " event to SAM Server successful!");
        }
    }

    private Event createEvent(Endpoint endpoint, EventTypeEnum type) {
        SoapBinding soapBinding;
        Event event = new Event();
        MessageInfo messageInfo = new MessageInfo();
        Originator originator = new Originator();
        event.setMessageInfo(messageInfo);
        event.setOriginator(originator);
        Date date = new Date();
        event.setTimestamp(date);
        event.setEventType(type);
        messageInfo.setPortType(endpoint.getBinding().getBindingInfo().getService().getInterface().getName().toString());
        String transportType = null;
        if (endpoint.getBinding() instanceof SoapBinding && (soapBinding = (SoapBinding)endpoint.getBinding()).getBindingInfo() instanceof SoapBindingInfo) {
            SoapBindingInfo soapBindingInfo = (SoapBindingInfo)soapBinding.getBindingInfo();
            transportType = soapBindingInfo.getTransportURI();
        }
        messageInfo.setTransportType(transportType != null ? transportType : "Unknown transport type");
        originator.setProcessId(Converter.getPID());
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            originator.setIp(inetAddress.getHostAddress());
            originator.setHostname(inetAddress.getHostName());
        }
        catch (UnknownHostException e) {
            originator.setHostname("Unknown hostname");
            originator.setIp("Unknown ip address");
        }
        String address = endpoint.getEndpointInfo().getAddress();
        event.getCustomInfo().put("address", address);
        return event;
    }
}

