/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.eventadmin.translator.subject;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.talend.esb.sam.agent.eventadmin.translator.subject.AbstractSubjectExtractorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SubjectExtractor {
    private final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private final SAXParser parser;

    public SubjectExtractor() {
        this.parserFactory.setNamespaceAware(true);
        try {
            this.parser = this.parserFactory.newSAXParser();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubject(String document, AbstractSubjectExtractorHandler handler) throws Exception {
        if (document == null) {
            throw new NullPointerException("Input document cannot be null.");
        }
        if (document.trim().isEmpty()) {
            throw new IllegalArgumentException("Input document cannot be empty.");
        }
        try {
            SAXParser sAXParser = this.parser;
            synchronized (sAXParser) {
                this.parser.parse(new InputSource(new StringReader(document)), (DefaultHandler)handler);
            }
        }
        catch (AbstractSubjectExtractorHandler.SubjectFoundException e) {
            return handler.getSubject();
        }
        catch (SAXParseException e) {
            throw new IllegalArgumentException("Cannot parse input document.", e);
        }
        return null;
    }
}

