/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.eventproducer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.talend.esb.sam.agent.message.CorrelationIdHelper;
import org.talend.esb.sam.agent.message.CustomInfo;
import org.talend.esb.sam.agent.message.FlowIdHelper;
import org.talend.esb.sam.agent.util.Converter;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.EventTypeEnum;
import org.talend.esb.sam.common.event.MessageInfo;
import org.talend.esb.sam.common.event.Originator;

public class MessageToEventMapper {
    private static final Logger LOG = Logger.getLogger(MessageToEventMapper.class.getName());
    private static final String CUT_START_TAG = "<cut><![CDATA[";
    private static final String CUT_END_TAG = "]]></cut>";
    private int maxContentLength = -1;

    public Event mapToEvent(Message message) {
        AuthorizationPolicy authPolicy;
        SecurityContext sc;
        String correlationId;
        String addr;
        Event event = new Event();
        MessageInfo messageInfo = new MessageInfo();
        Originator originator = new Originator();
        boolean isRestMessage = MessageToEventMapper.isRestMessage(message);
        event.setMessageInfo(messageInfo);
        event.setOriginator(originator);
        String content = this.getPayload(message);
        event.setContent(content);
        this.handleContentLength(event);
        event.setEventType(null);
        Date date = new Date();
        event.setTimestamp(date);
        messageInfo.setFlowId(FlowIdHelper.getFlowId(message));
        if (!isRestMessage) {
            SoapBinding soapBinding;
            messageInfo.setMessageId(this.getMessageId(message));
            ServiceInfo serviceInfo = message.getExchange().getBinding().getBindingInfo().getService();
            if (null != serviceInfo) {
                String portTypeName = serviceInfo.getInterface().getName().toString();
                messageInfo.setPortType(portTypeName);
                messageInfo.setOperationName(this.getOperationName(message));
            }
            if ((soapBinding = (SoapBinding)message.getExchange().getBinding()).getBindingInfo() instanceof SoapBindingInfo) {
                SoapBindingInfo soapBindingInfo = (SoapBindingInfo)soapBinding.getBindingInfo();
                messageInfo.setTransportType(soapBindingInfo.getTransportURI());
            }
        } else {
            messageInfo.setTransportType("http://cxf.apache.org/transports/http");
            messageInfo.setPortType(message.getExchange().getEndpoint().getEndpointInfo().getName().toString());
            String opName = this.getRestOperationName(message);
            messageInfo.setOperationName(opName);
        }
        if (messageInfo.getTransportType() == null) {
            messageInfo.setTransportType("Unknown transport type");
        }
        if (null != message.getExchange().getEndpoint().get((Object)"esb.sam.properties")) {
            Map customProp = (Map)message.getExchange().getEndpoint().get((Object)"esb.sam.properties");
            event.getCustomInfo().putAll(customProp);
        }
        if (null != (addr = message.getExchange().getEndpoint().getEndpointInfo().getAddress())) {
            event.getCustomInfo().put("address", addr);
        }
        if (null != (correlationId = CorrelationIdHelper.getCorrelationId(message))) {
            event.getCustomInfo().put("CorrelationID", correlationId);
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            originator.setIp(inetAddress.getHostAddress());
            originator.setHostname(inetAddress.getHostName());
        }
        catch (UnknownHostException e) {
            originator.setHostname("Unknown hostname");
            originator.setIp("Unknown ip address");
        }
        originator.setProcessId(Converter.getPID());
        if (isRestMessage) {
            Integer responseCode;
            String contentType;
            String accept = (String)message.get((Object)"Accept");
            if (null != accept) {
                event.getCustomInfo().put("Accept Type", accept);
            }
            if (null != (contentType = (String)message.get((Object)"Content-Type"))) {
                event.getCustomInfo().put("Content Type", contentType);
            }
            if (null != (responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE))) {
                event.getCustomInfo().put("Response Code", responseCode.toString());
            }
        }
        if ((sc = (SecurityContext)message.get(SecurityContext.class)) != null && sc.getUserPrincipal() != null) {
            originator.setPrincipal(sc.getUserPrincipal().getName());
        }
        if (originator.getPrincipal() == null && (authPolicy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class)) != null) {
            originator.setPrincipal(authPolicy.getUserName());
        }
        EventTypeEnum eventType = this.getEventType(message);
        event.setEventType(eventType);
        CustomInfo customInfo = CustomInfo.getOrCreateCustomInfo(message);
        event.getCustomInfo().putAll(customInfo);
        return event;
    }

    private String getRestOperationName(Message message) {
        boolean isRequestor = MessageUtils.isRequestor((Message)message);
        boolean isOutbound = MessageUtils.isOutbound((Message)message);
        Message effectiveMessage = message;
        if (isRequestor) {
            if (!isOutbound) {
                effectiveMessage = message.getExchange().getOutMessage();
            }
        } else if (isOutbound) {
            effectiveMessage = message.getExchange().getInMessage();
        }
        return MessageToEventMapper.buildRestOperationName(effectiveMessage);
    }

    private static String buildRestOperationName(Message message) {
        if (message.containsKey((Object)"org.apache.cxf.request.method")) {
            int baseUriLength;
            String requestUri;
            String httpMethod = message.get((Object)"org.apache.cxf.request.method").toString();
            String path = "";
            if (message.containsKey((Object)"org.apache.cxf.request.uri") && (path = (requestUri = message.get((Object)"org.apache.cxf.request.uri").toString()).substring(baseUriLength = message.containsKey((Object)Message.BASE_PATH) ? message.get((Object)Message.BASE_PATH).toString().length() : 0)).isEmpty()) {
                path = "/";
            }
            return new StringBuffer().append(httpMethod).append('[').append(path).append(']').toString();
        }
        return "";
    }

    private String getMessageId(Message message) {
        String messageId = null;
        AddressingProperties addrProp = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)MessageUtils.isOutbound((Message)message));
        if (addrProp != null && addrProp.getMessageID() != null) {
            messageId = addrProp.getMessageID().getValue();
        }
        return messageId;
    }

    private EventTypeEnum getEventType(Message message) {
        boolean isRequestor = MessageUtils.isRequestor((Message)message);
        boolean isFault = MessageUtils.isFault((Message)message);
        boolean isOutbound = MessageUtils.isOutbound((Message)message);
        if (!isFault && MessageToEventMapper.isRestMessage(message)) {
            Integer responseCode;
            boolean bl = isFault = message.getExchange().get((Object)"org.apache.cxf.resource.operation.name") == null;
            if (!isFault && null != (responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE))) {
                boolean bl2 = isFault = responseCode >= 400;
            }
        }
        if (isOutbound) {
            if (isFault) {
                return EventTypeEnum.FAULT_OUT;
            }
            return isRequestor ? EventTypeEnum.REQ_OUT : EventTypeEnum.RESP_OUT;
        }
        if (isFault) {
            return EventTypeEnum.FAULT_IN;
        }
        return isRequestor ? EventTypeEnum.RESP_IN : EventTypeEnum.REQ_IN;
    }

    private String getOperationName(Message message) {
        Message reqMsg;
        Message inMsg;
        String operationName = null;
        BindingOperationInfo boi = null;
        boi = message.getExchange().getBindingOperationInfo();
        if (null == boi) {
            boi = this.getOperationFromContent(message);
        }
        if (null == boi && null != (inMsg = message.getExchange().getInMessage()) && null != (reqMsg = inMsg.getExchange().getInMessage())) {
            boi = this.getOperationFromContent(reqMsg);
        }
        if (null != boi) {
            operationName = boi.getName().toString();
        }
        return operationName;
    }

    private BindingOperationInfo getOperationFromContent(Message message) {
        BindingOperationInfo boi = null;
        XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        if (null != xmlReader) {
            QName qName = xmlReader.getName();
            boi = ServiceModelUtil.getOperation((Exchange)message.getExchange(), (QName)qName);
        }
        return boi;
    }

    protected String getPayload(Message message) {
        try {
            CachedOutputStream cos;
            String encoding = (String)message.get((Object)Message.ENCODING);
            if (encoding == null) {
                encoding = "UTF-8";
            }
            if ((cos = (CachedOutputStream)message.getContent(CachedOutputStream.class)) == null) {
                LOG.warning("Could not find CachedOutputStream in message. Continuing without message content");
                return "";
            }
            return new String(cos.getBytes(), encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    private void handleContentLength(Event event) {
        if (event.getContent() == null) {
            return;
        }
        if (this.maxContentLength == -1 || event.getContent().length() <= this.maxContentLength) {
            return;
        }
        if (this.maxContentLength < CUT_START_TAG.length() + CUT_END_TAG.length()) {
            event.setContent("");
            event.setContentCut(true);
            return;
        }
        int contentLength = this.maxContentLength - CUT_START_TAG.length() - CUT_END_TAG.length();
        event.setContent(CUT_START_TAG + event.getContent().substring(0, contentLength) + CUT_END_TAG);
        event.setContentCut(true);
    }

    static boolean isRestMessage(Message message) {
        return !(message.getExchange().getBinding() instanceof SoapBinding);
    }
}

