/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.eventadmin;

import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;
import org.talend.esb.sam.agent.eventadmin.translator.SamEventTranslator;
import org.talend.esb.sam.common.event.Event;

public class EventAdminPublisher {
    public static final String TOPIC = "org/talend/esb/sam/events";
    private static EventAdmin eventAdmin = EventAdminPublisher.getEventAdmin(EventAdmin.class);

    private static boolean isOSGiDeployment() {
        Bundle b = FrameworkUtil.getBundle(EventAdminPublisher.class);
        return b != null;
    }

    private static EventAdmin getEventAdmin(Class<?> serviceClass) {
        ServiceReference ref;
        if (!EventAdminPublisher.isOSGiDeployment()) {
            return null;
        }
        BundleContext context = FrameworkUtil.getBundle(EventAdminPublisher.class).getBundleContext();
        if (context != null && (ref = context.getServiceReference(EventAdmin.class.getName())) != null) {
            return (EventAdmin)context.getService(ref);
        }
        return null;
    }

    public static void publish(List<Event> samEvents) throws Exception {
        if (eventAdmin != null) {
            for (Event samEvent : samEvents) {
                eventAdmin.postEvent(SamEventTranslator.translate(samEvent, TOPIC));
            }
        }
    }
}

