/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.eventadmin.translator;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.talend.esb.sam.agent.eventadmin.translator.subject.SamlTokenSubjectExtractor;
import org.talend.esb.sam.agent.eventadmin.translator.subject.SubjectExtractor;
import org.talend.esb.sam.agent.eventadmin.translator.subject.UsernameTokenSubjectExtractor;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.EventTypeEnum;

public class SamEventTranslator {
    public static final String SAM_EVENT_TYPE = "SAMEvent";
    public static final String ID = "id";
    public static final String EVENT_UUID = "eventUUID";
    public static final String CORRELATION_ID = "correlationId";
    public static final String CATEGORY = "category";
    public static final String EVENT_TYPE = "eventType";
    public static final String SEVERITY = "severity";
    public static final String LOG_MESSAGE = "logMessage";
    public static final String LOG_SOURCE = "logSource";
    public static final String SIGNED_LOG_MESSAGE = "signedLogMessage";
    public static final String LOG_TIMESTAMP = "logTimestamp";
    public static final String AGENT_ID = "agentId";
    public static final String AGENT_TIMESTAMP = "agentTimestamp";
    public static final String SERVER_TIMESTAMP = "serverTimestamp";
    public static final String AUDIT = "audit";
    public static final String AUDIT_SEQUENCE_NO = "auditSequenceNo";
    public static final String PRINCIPAL = "principal";
    public static final String CUSTOM_INFO = "customInfo";
    public static final String LS_HOSTNAME = "host.name";
    public static final String LS_PROCESS_ID = "process.id";
    public static final String LS_HOST_IP = "host.ip";
    public static final String PORT_TYPE = "port.type";
    public static final String TRANSPORT_TYPE = "transport.type";
    public static final String OPERATION_NAME = "operation.name";
    public static final String MESSAGE_ID = "message.id";
    public static final String FLOW_ID = "flow.id";
    public static final String EVENT_TYPE_CUSTOM = "event.type";
    public static final String CONTENT_CUT = "content.cut";

    protected static String getEventType() {
        return SAM_EVENT_TYPE;
    }

    protected static Boolean getAudit() {
        return Boolean.FALSE;
    }

    protected static String getAuditSequenceNo() {
        return "";
    }

    protected static String getCategory() {
        return "";
    }

    protected static String getSignedLogMessage(Event samEvent) {
        return "";
    }

    protected static String getAgentID(Event samEvent) {
        return "";
    }

    protected static boolean isUsernameTokenMappingEnabled() {
        return false;
    }

    protected static boolean isSamlTokenMappingEnabled() {
        return false;
    }

    protected static Map<String, String> getCustomInfo(Event samEvent) {
        HashMap<String, String> customInfo = new HashMap<String, String>();
        customInfo.put(MESSAGE_ID, samEvent.getMessageInfo().getMessageId());
        customInfo.put(FLOW_ID, samEvent.getMessageInfo().getFlowId());
        customInfo.put(OPERATION_NAME, samEvent.getMessageInfo().getOperationName());
        customInfo.put(TRANSPORT_TYPE, samEvent.getMessageInfo().getTransportType());
        customInfo.put(PORT_TYPE, samEvent.getMessageInfo().getPortType());
        customInfo.put(CONTENT_CUT, Boolean.toString(samEvent.isContentCut()));
        customInfo.put(EVENT_TYPE_CUSTOM, samEvent.getEventType().toString());
        Map samCustomInfo = samEvent.getCustomInfo();
        if (null != samCustomInfo) {
            customInfo.putAll(samCustomInfo);
            customInfo.remove(CORRELATION_ID);
        }
        return customInfo;
    }

    protected static String getEventUUID(Event samEvent) throws Exception {
        return UUID.randomUUID().toString();
    }

    public static org.osgi.service.event.Event translate(Event samEvent, String topic) throws Exception {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (samEvent != null && samEvent.getMessageInfo() != null) {
            m.put(EVENT_UUID, SamEventTranslator.getEventUUID(samEvent));
            m.put(CORRELATION_ID, SamEventTranslator.getCorrelationID(samEvent));
            m.put(CATEGORY, SamEventTranslator.getCategory());
            m.put(EVENT_TYPE, SAM_EVENT_TYPE);
            m.put(SEVERITY, SamEventTranslator.getSeverity(samEvent.getEventType()));
            m.put(LOG_MESSAGE, SamEventTranslator.getLogMessage(samEvent));
            m.put(LOG_SOURCE, SamEventTranslator.getLogSource(samEvent));
            m.put(SIGNED_LOG_MESSAGE, SamEventTranslator.getSignedLogMessage(samEvent));
            m.put(LOG_TIMESTAMP, SamEventTranslator.getEventTimestamp(samEvent));
            m.put(AGENT_ID, SamEventTranslator.getAgentID(samEvent));
            m.put(AGENT_TIMESTAMP, SamEventTranslator.getEventTimestamp(samEvent));
            m.put(SERVER_TIMESTAMP, SamEventTranslator.getEventTimestamp(samEvent));
            m.put(AUDIT, SamEventTranslator.getAudit());
            m.put(AUDIT_SEQUENCE_NO, SamEventTranslator.getAuditSequenceNo());
            m.put(PRINCIPAL, SamEventTranslator.getSubject(samEvent));
            m.put(CUSTOM_INFO, SamEventTranslator.getCustomInfo(samEvent));
        }
        return new org.osgi.service.event.Event(topic, m);
    }

    private static String getSeverity(EventTypeEnum eventType) {
        String severity;
        switch (eventType) {
            case FAULT_IN: 
            case FAULT_OUT: {
                severity = "ERROR";
                break;
            }
            case UNKNOWN: {
                severity = "WARN";
                break;
            }
            default: {
                severity = "INFO";
            }
        }
        return severity;
    }

    protected static Map<String, String> getLogSource(Event inputEvent) throws Exception {
        HashMap<String, String> source = new HashMap<String, String>();
        if (inputEvent != null && inputEvent.getOriginator() != null) {
            source.put(LS_HOSTNAME, inputEvent.getOriginator().getHostname());
            source.put(LS_HOST_IP, inputEvent.getOriginator().getIp());
            source.put(LS_PROCESS_ID, inputEvent.getOriginator().getProcessId());
        }
        return source;
    }

    protected static String getLogMessage(Event samEvent) throws Exception {
        return samEvent.getContent();
    }

    protected static String getCorrelationID(Event inputEvent) throws Exception {
        if (inputEvent == null || inputEvent.getCustomInfo() == null) {
            return null;
        }
        return (String)inputEvent.getCustomInfo().get(CORRELATION_ID);
    }

    protected static Long getEventTimestamp(Event inputEvent) throws Exception {
        if (inputEvent == null || inputEvent.getTimestamp() == null) {
            return new Date().getTime();
        }
        return inputEvent.getTimestamp().getTime();
    }

    protected static String getSubject(Event samEvent) throws Exception {
        String msgContent = samEvent.getContent();
        SubjectExtractor subjectExtractor = new SubjectExtractor();
        String answer = null;
        if (answer == null && samEvent.getOriginator() != null) {
            answer = samEvent.getOriginator().getPrincipal();
        }
        if (answer == null && SamEventTranslator.isUsernameTokenMappingEnabled()) {
            answer = subjectExtractor.getSubject(msgContent, new UsernameTokenSubjectExtractor());
        }
        if (answer == null && SamEventTranslator.isSamlTokenMappingEnabled()) {
            answer = subjectExtractor.getSubject(msgContent, new SamlTokenSubjectExtractor());
        }
        return answer;
    }
}

