/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.serviceclient;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.WSPolicyFeature;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.neethi.Policy;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.talend.esb.sam.agent.serviceclient.EsbSecurityConstants;
import org.talend.esb.sam.agent.serviceclient.WSPasswordCallbackHandler;

public class SAMClientSecurityProvider {
    private Client client;
    private String authenticationType;
    private String policyUsernameToken;
    private String policySaml;
    private Object signatureProperties;
    private String signatureUsername;
    private String signaturePassword;
    private String username;
    private String password;
    private String stsWsdlLocation;
    private String stsNamespace;
    private String stsServiceName;
    private String stsEndpointName;
    private String stsTokenUsecert;
    private String encryptionUsername;
    private String isBspCompliant;

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getPolicyUsernameToken() {
        return this.policyUsernameToken;
    }

    public void setPolicyUsernameToken(String policyUsernameToken) {
        this.policyUsernameToken = policyUsernameToken;
    }

    public String getPolicySaml() {
        return this.policySaml;
    }

    public void setPolicySaml(String policySaml) {
        this.policySaml = policySaml;
    }

    public Object getSignatureProperties() {
        return this.signatureProperties;
    }

    public void setSignatureProperties(Object signatureProperties) {
        this.signatureProperties = signatureProperties;
    }

    public String getSignatureUsername() {
        return this.signatureUsername;
    }

    public void setSignatureUsername(String signatureUsername) {
        this.signatureUsername = signatureUsername;
    }

    public String getSignaturePassword() {
        return this.signaturePassword;
    }

    public void setSignaturePassword(String signaturePassword) {
        this.signaturePassword = signaturePassword;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getStsWsdlLocation() {
        return this.stsWsdlLocation;
    }

    public void setStsWsdlLocation(String stsWsdlLocation) {
        this.stsWsdlLocation = stsWsdlLocation;
    }

    public String getStsNamespace() {
        return this.stsNamespace;
    }

    public void setStsNamespace(String stsNamespace) {
        this.stsNamespace = stsNamespace;
    }

    public String getStsServiceName() {
        return this.stsServiceName;
    }

    public void setStsServiceName(String stsServiceName) {
        this.stsServiceName = stsServiceName;
    }

    public String getStsEndpointName() {
        return this.stsEndpointName;
    }

    public void setStsEndpointName(String stsEndpointName) {
        this.stsEndpointName = stsEndpointName;
    }

    public String getStsTokenUsecert() {
        return this.stsTokenUsecert;
    }

    public void setStsTokenUsecert(String stsTokenUsecert) {
        this.stsTokenUsecert = stsTokenUsecert;
    }

    public String getEncryptionUsername() {
        return this.encryptionUsername;
    }

    public void setEncryptionUsername(String encryptionUsername) {
        this.encryptionUsername = encryptionUsername;
    }

    public String getIsBspCompliant() {
        return this.isBspCompliant;
    }

    public void setIsBspCompliant(String isBspCompliant) {
        this.isBspCompliant = isBspCompliant;
    }

    @PostConstruct
    public void init() {
        EsbSecurityConstants esbSecurity = EsbSecurityConstants.fromString(this.authenticationType);
        if (EsbSecurityConstants.NO == esbSecurity) {
            return;
        }
        Bus bus = this.client.getBus();
        ArrayList<Policy> policies = new ArrayList<Policy>();
        WSPolicyFeature policyFeature = new WSPolicyFeature();
        policyFeature.setPolicies(policies);
        HashMap<String, Object> properties = this.client.getRequestContext();
        if (null == properties) {
            properties = new HashMap<String, Object>();
        }
        if (EsbSecurityConstants.BASIC == esbSecurity) {
            AuthorizationPolicy authzPolicy = new AuthorizationPolicy();
            authzPolicy.setUserName(this.username);
            authzPolicy.setPassword(this.password);
            authzPolicy.setAuthorizationType("Basic");
            HTTPConduit conduit = (HTTPConduit)this.client.getConduit();
            conduit.setAuthorization(authzPolicy);
        } else if (EsbSecurityConstants.USERNAMETOKEN == esbSecurity) {
            policies.add(this.loadPolicy(this.policyUsernameToken, bus));
            HashMap<String, Object> wssProps = new HashMap<String, Object>();
            wssProps.put("action", "UsernameToken");
            wssProps.put("user", this.username);
            wssProps.put("passwordType", "PasswordText");
            wssProps.put("passwordCallbackRef", new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    ((WSPasswordCallback)callbacks[0]).setPassword(SAMClientSecurityProvider.this.password);
                }
            });
            this.client.getEndpoint().getOutInterceptors().add(new WSS4JOutInterceptor(wssProps));
            this.client.getRequestContext().put("security.username", this.username);
            this.client.getRequestContext().put("security.password", this.password);
        } else if (EsbSecurityConstants.SAML == esbSecurity) {
            policies.add(this.loadPolicy(this.policySaml, bus));
            properties.put("security.signature.properties", SAMClientSecurityProvider.processFileURI(this.getSignatureProperties()));
            properties.put("security.signature.username", this.getSignatureUsername());
            properties.put("security.signature.password", this.getSignaturePassword());
            properties.put("security.callback-handler", new WSPasswordCallbackHandler(this.getSignatureUsername(), this.getSignaturePassword()));
            STSClient stsClient = new STSClient(bus);
            stsClient.setWsdlLocation(this.stsWsdlLocation);
            stsClient.setServiceQName(new QName(this.stsNamespace, this.stsServiceName));
            stsClient.setEndpointQName(new QName(this.stsNamespace, this.stsEndpointName));
            HashMap<String, Object> stsProperties = new HashMap<String, Object>();
            stsProperties.put("security.username", this.username);
            stsProperties.put("security.password", this.password);
            stsProperties.put("security.callback-handler", new WSPasswordCallbackHandler(this.username, this.password));
            stsProperties.put("security.sts.token.properties", SAMClientSecurityProvider.processFileURI(this.getSignatureProperties()));
            stsProperties.put("security.sts.token.username", this.signatureUsername);
            stsProperties.put("security.sts.token.usecert", this.stsTokenUsecert);
            stsProperties.put("security.encryption.properties", SAMClientSecurityProvider.processFileURI(this.getSignatureProperties()));
            stsProperties.put("security.encryption.username", this.encryptionUsername);
            stsProperties.put("ws-security.is-bsp-compliant", this.isBspCompliant);
            stsClient.setProperties(stsProperties);
            properties.put("security.sts.client", stsClient);
        }
        this.client.getEndpoint().getActiveFeatures().add(policyFeature);
        policyFeature.initialize(this.client, bus);
    }

    private Policy loadPolicy(String location, Bus cxf) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(location);
            Policy policy = ((PolicyBuilder)cxf.getExtension(PolicyBuilder.class)).getPolicy((InputStream)is);
            return policy;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load policy", e);
        }
        finally {
            if (null != is) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Object processFileURI(Object fileURI) {
        String fileURIName;
        if (fileURI instanceof String && (fileURIName = (String)fileURI).startsWith("file:")) {
            try {
                return new URL(fileURIName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return fileURI;
    }
}

