/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.wiretap;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.talend.esb.sam.agent.wiretap.CacheAndWriteTapOutputStream;
import org.talend.esb.sam.agent.wiretap.WireTapHelper;
import org.talend.esb.sam.agent.wiretap.WriterOutputStream;

public class WireTapOut
extends AbstractPhaseInterceptor<Message> {
    private Interceptor<Message> wireTap;
    private boolean logMessageContent;
    private boolean logMessageContentOverride;

    public WireTapOut(Interceptor<Message> wireTap, boolean logMessageContent, boolean logMessageContentOverride) {
        super("pre-stream");
        this.wireTap = wireTap;
        this.logMessageContent = logMessageContent;
        this.logMessageContentOverride = logMessageContentOverride;
    }

    public void handleMessage(Message message) throws Fault {
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        if (null == os) {
            Writer writer;
            String encoding = (String)message.get((Object)Message.ENCODING);
            if (encoding == null) {
                encoding = "UTF-8";
            }
            if (null != (writer = (Writer)message.getContent(Writer.class))) {
                os = new WriterOutputStream(writer, encoding);
                message.setContent(Writer.class, null);
            }
        }
        if (null != os) {
            CacheAndWriteTapOutputStream newOut = new CacheAndWriteTapOutputStream(os);
            message.setContent(OutputStream.class, (Object)newOut);
            if (WireTapHelper.isMessageContentToBeLogged(message, this.logMessageContent, this.logMessageContentOverride)) {
                message.setContent(CachedOutputStream.class, (Object)newOut);
            } else {
                try {
                    CachedOutputStream cos = new CachedOutputStream();
                    cos.write("[CONTENT LOGGING IS DISABLED]".getBytes(Charset.forName("UTF-8")));
                    message.setContent(CachedOutputStream.class, (Object)cos);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.wireTap != null) {
                newOut.registerCallback(new CallBack(message));
            }
        }
    }

    private final class CallBack
    implements CachedOutputStreamCallback {
        private final Message message;

        private CallBack(Message message) {
            this.message = message;
        }

        public void onFlush(CachedOutputStream os) {
        }

        public void onClose(CachedOutputStream os) {
            WireTapOut.this.wireTap.handleMessage(this.message);
        }
    }
}

