/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.common.filter.impl;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.spi.EventFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JxPathFilter
implements EventFilter {
    private String expression;
    private JAXBContext context = JxPathFilter.initJAXBContext();
    private DocumentBuilder builder = JxPathFilter.initDocumentBuilder();
    private XPathFactory xpathfactory = JxPathFilter.initXPathFactory();

    public JxPathFilter() {
    }

    public JxPathFilter(String expression) {
        this.expression = expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public boolean filter(Event event) {
        try {
            Marshaller msh = this.initMarshaller();
            Document doc = this.initDocument();
            msh.marshal((Object)event, (Node)doc);
            Element node = doc.getDocumentElement();
            XPath xpath = this.initXPath();
            Boolean result = (Boolean)xpath.evaluate(this.expression, node, XPathConstants.BOOLEAN);
            return result == null ? false : result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught during XPath filter evaluation: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Marshaller initMarshaller() throws JAXBException {
        JAXBContext jAXBContext = this.context;
        synchronized (jAXBContext) {
            return this.context.createMarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document initDocument() {
        DocumentBuilder documentBuilder = this.builder;
        synchronized (documentBuilder) {
            return this.builder.newDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPath initXPath() {
        XPathFactory xPathFactory = this.xpathfactory;
        synchronized (xPathFactory) {
            return this.xpathfactory.newXPath();
        }
    }

    private static JAXBContext initJAXBContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{Event.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Exception caught initializing JAXB context for Event class. ", e);
        }
    }

    private static DocumentBuilder initDocumentBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Exception caught setting up document builder. ", e);
        }
    }

    private static XPathFactory initXPathFactory() {
        return XPathFactory.newInstance();
    }
}

