/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.persistence.criterias;

import org.talend.esb.sam.server.persistence.criterias.Criteria;

public class PatternCriteria
extends Criteria {
    private String pattern;
    private String condition;

    public PatternCriteria(String name, String colunmName) {
        super(name, colunmName);
    }

    public PatternCriteria(String name, String columnName, String condition) {
        super(name, columnName);
        this.condition = condition;
    }

    @Override
    public Criteria[] parseValue(String attribute) {
        PatternCriteria result = new PatternCriteria(this.name, this.columnName, this.condition);
        result.pattern = this.toSQLPattern(attribute);
        return new Criteria[]{result};
    }

    @Override
    public Object getValue() {
        return this.pattern;
    }

    @Override
    public StringBuilder getFilterClause() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.columnName);
        builder.append(" LIKE ");
        builder.append(':').append(this.name);
        if (this.condition != null) {
            builder.append(" AND ");
            builder.append(this.condition);
        }
        return builder;
    }

    private String toSQLPattern(String attribute) {
        Object pattern = attribute.replace("*", "%");
        if (!((String)pattern).startsWith("%")) {
            pattern = "%" + (String)pattern;
        }
        if (!((String)pattern).endsWith("%")) {
            pattern = ((String)pattern).concat("%");
        }
        return pattern;
    }
}

