/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.service.security;

import java.util.HashMap;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.security.JAASAuthenticationFilter;
import org.apache.cxf.rs.security.saml.SamlHeaderInHandler;
import org.apache.cxf.service.model.EndpointInfo;
import org.talend.esb.sam.service.security.EsbSecurityConstants;
import org.talend.esb.sam.service.security.WSPasswordCallbackHandler;

@NoJSR250Annotations(unlessNull={"bus"})
public class SAMServiceSecurityProvider {
    private JAXRSServerFactoryBean server;
    private String serviceAutentication;
    private String signatureProperties;
    private String signatureUsername;
    private String signaturePassword;
    private static final String ENDPOINT_SIGNATURE_PASSWORD = "security.signature.password";

    public JAXRSServerFactoryBean getMonitoringEndpoint() {
        return this.server;
    }

    public void setMonitoringEndpoint(JAXRSServerFactoryBean server) {
        this.server = server;
    }

    public String getServiceAutentication() {
        return this.serviceAutentication;
    }

    public void setServiceAutentication(String serviceAutentication) {
        this.serviceAutentication = serviceAutentication;
    }

    public String getSignatureProperties() {
        return this.signatureProperties;
    }

    public void setSignatureProperties(String signatureProperties) {
        this.signatureProperties = signatureProperties;
    }

    public String getSignatureUsername() {
        return this.signatureUsername;
    }

    public void setSignatureUsername(String signatureUsername) {
        this.signatureUsername = signatureUsername;
    }

    public String getSignaturePassword() {
        return this.signaturePassword;
    }

    public void setSignaturePassword(String signaturePassword) {
        this.signaturePassword = signaturePassword;
    }

    public void init() {
        EsbSecurityConstants esbSecurity = EsbSecurityConstants.fromString(this.serviceAutentication);
        if (EsbSecurityConstants.NO == esbSecurity) {
            return;
        }
        Bus serverBus = this.server.getBus();
        ServerRegistry registry = (ServerRegistry)serverBus.getExtension(ServerRegistry.class);
        List servers = registry.getServers();
        for (Server sr : servers) {
            EndpointInfo ei = sr.getEndpoint().getEndpointInfo();
            if (null == ei || !ei.getAddress().endsWith(this.server.getAddress())) continue;
            registry.unregister(sr);
            sr.destroy();
        }
        List providers = this.server.getProviders();
        HashMap<String, Object> endpointProperties = new HashMap<String, Object>();
        if (EsbSecurityConstants.BASIC == esbSecurity) {
            JAASAuthenticationFilter authenticationFilter = new JAASAuthenticationFilter();
            authenticationFilter.setContextName("karaf");
            providers.add(authenticationFilter);
            this.server.setProviders(providers);
        } else if (EsbSecurityConstants.SAML == esbSecurity) {
            endpointProperties.put("security.signature.properties", this.getSignatureProperties());
            endpointProperties.put("security.signature.username", this.getSignatureUsername());
            endpointProperties.put(ENDPOINT_SIGNATURE_PASSWORD, this.getSignaturePassword());
            endpointProperties.put("security.callback-handler", new WSPasswordCallbackHandler(this.getSignatureUsername(), this.getSignaturePassword()));
            HashMap properties = this.server.getProperties();
            if (null == properties) {
                properties = new HashMap();
            }
            properties.putAll(endpointProperties);
            this.server.setProperties(properties);
            SamlHeaderInHandler samlHandler = new SamlHeaderInHandler();
            providers.add(samlHandler);
            this.server.setProviders(providers);
        }
        this.server.create();
    }
}

