/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.security.saml;

import java.io.IOException;
import java.security.Provider;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSPasswordCallbackHandler
implements CallbackHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(WSPasswordCallbackHandler.class);
    private static final String ALGORITHM = "PBEWITHSHA256AND128BITAES-CBC-BC";
    private static final String PASSWORD_ENV_NAME = "TESB_ENV_PASSWORD";
    private static final String PROVIDER_NAME = "BC";
    private final String user;
    private final String pass;

    public WSPasswordCallbackHandler(String username, String password) {
        if (PropertyValueEncryptionUtils.isEncryptedValue((String)password)) {
            StandardPBEStringEncryptor enc = new StandardPBEStringEncryptor();
            EnvironmentStringPBEConfig env = new EnvironmentStringPBEConfig();
            env.setProvider((Provider)new BouncyCastleProvider());
            env.setProviderName(PROVIDER_NAME);
            env.setAlgorithm(ALGORITHM);
            env.setPasswordEnvName(PASSWORD_ENV_NAME);
            enc.setConfig((PBEConfig)env);
            this.pass = PropertyValueEncryptionUtils.decrypt((String)password, (StringEncryptor)enc);
        } else {
            this.pass = password;
        }
        this.user = username;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (this.user == null) {
            LOG.debug("No user was specified in the WSPasswordCallbackHandler");
            return;
        }
        for (Callback callback : callbacks) {
            WSPasswordCallback pc;
            if (!(callback instanceof WSPasswordCallback) || !this.user.equals((pc = (WSPasswordCallback)callback).getIdentifier())) continue;
            pc.setPassword(this.pass);
            break;
        }
    }
}

