/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.security.logging;

import java.util.Collection;
import org.apache.cxf.Bus;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.ext.logging.LoggingInInterceptor;
import org.apache.cxf.ext.logging.LoggingOutInterceptor;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveLoggingFeatureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SensitiveLoggingFeatureUtils.class);
    private static LoggingFeature CXF_LOGGING_FEATURE = null;

    public static void setMessageLogging(boolean logMessages, Bus bus) {
        SensitiveLoggingFeatureUtils.setMessageLogging(logMessages, (InterceptorProvider)bus, bus);
    }

    public static void setMessageLogging(boolean logMessages, InterceptorProvider provider, Bus bus) {
        if (provider != null && bus != null) {
            if (logMessages) {
                if (!SensitiveLoggingFeatureUtils.hasLoggingFeature(bus)) {
                    SensitiveLoggingFeatureUtils.addMessageLogging(provider, bus);
                }
            } else if (SensitiveLoggingFeatureUtils.hasLoggingFeature(bus)) {
                SensitiveLoggingFeatureUtils.removeMessageLogging(provider, bus);
            }
        }
    }

    static void setLoggingFeature(LoggingFeature loggingFeature) {
        CXF_LOGGING_FEATURE = loggingFeature;
    }

    private static boolean hasLoggingFeature(Bus bus) {
        Collection features = bus.getFeatures();
        if (features != null) {
            for (Feature feature : features) {
                if (!(feature instanceof LoggingFeature)) continue;
                return true;
            }
        }
        return false;
    }

    private static void addMessageLogging(InterceptorProvider provider, Bus bus) {
        LoggingFeature logFeature = CXF_LOGGING_FEATURE;
        if (logFeature == null) {
            LOG.warn("Common CXF LoggingFeature not available, using new one");
            logFeature = new LoggingFeature();
        }
        logFeature.initialize(provider, bus);
        bus.getFeatures().add(logFeature);
    }

    private static void removeMessageLogging(InterceptorProvider provider, Bus bus) {
        Collection features = bus.getFeatures();
        Feature logFeature = null;
        Interceptor inLogInterceptor = null;
        Interceptor outLogInterceptor = null;
        for (Feature feature : features) {
            if (!(feature instanceof LoggingFeature)) continue;
            logFeature = feature;
            break;
        }
        if (logFeature != null) {
            features.remove(logFeature);
        }
        for (Interceptor interceptor : provider.getInInterceptors()) {
            if (!(interceptor instanceof LoggingInInterceptor)) continue;
            inLogInterceptor = interceptor;
            break;
        }
        for (Interceptor interceptor : provider.getOutInterceptors()) {
            if (!(interceptor instanceof LoggingOutInterceptor)) continue;
            outLogInterceptor = interceptor;
            break;
        }
        if (inLogInterceptor != null) {
            provider.getInInterceptors().remove(inLogInterceptor);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Remove in Interceptor = {}", (Object)inLogInterceptor.getClass().getName());
            }
        }
        if (outLogInterceptor != null) {
            provider.getOutInterceptors().remove(outLogInterceptor);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Remove out Interceptor = {}", (Object)outLogInterceptor.getClass().getName());
            }
        }
    }
}

