/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sts.war.handler;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;

public class PropertyFileCallbackHandler
implements Validator {
    private static Log log = LogFactory.getLog(PropertyFileCallbackHandler.class);

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getUsernametoken() == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCredential");
        }
        String user = null;
        String password = null;
        UsernameToken usernameToken = credential.getUsernametoken();
        user = usernameToken.getName();
        String pwType = usernameToken.getPasswordType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("UsernameToken user " + usernameToken.getName()));
            log.debug((Object)("UsernameToken password type " + pwType));
        }
        if (usernameToken.isHashed()) {
            log.warn((Object)"Authentication failed as hashed username token not supported");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        password = usernameToken.getPassword();
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(pwType)) {
            log.warn((Object)("Password type " + pwType + " not supported"));
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        if (user == null || user.length() <= 0 || password == null || password.length() <= 0) {
            log.warn((Object)"User or password empty");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        try {
            InputStream stream = PropertyFileCallbackHandler.class.getClassLoader().getResourceAsStream("user.properties");
            Properties properties = new Properties();
            properties.load(stream);
            String propertyPwd = (String)properties.get(user);
            if (propertyPwd == null || !propertyPwd.equalsIgnoreCase(password)) {
                log.info((Object)"Authentication failed");
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
            }
        }
        catch (Exception ex) {
            log.info((Object)"Authentication failed", (Throwable)ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        return credential;
    }
}

