/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.encryptor;

import java.security.Provider;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.properties.PropertyValueEncryptionUtils;

@Command(scope="tesb", name="encrypt-text", description="Encrypt text using Jasypt with BouncyCastle provider")
@Service
public class TextEncryptor
implements Action {
    private static final String ALGORITHM = "PBEWITHSHA256AND256BITAES-CBC-BC";
    private static final String ALGORITHM_ENV_NAME = "TESB_ENV_ALGORITHM";
    private static final String PASSWORD_ENV_NAME = "TESB_ENV_PASSWORD";
    private static final String PROVIDER_NAME = "BC";
    @Argument(index=0, name="TextToEncrypt", description="Text, that need to be encrypted", required=true, multiValued=false)
    String textToEncrypt;
    @Argument(index=1, name="EncryptionPassword", description="Password that will be used for encryption", required=false, multiValued=false)
    String encryptionPassword;

    public Object execute() throws Exception {
        StandardPBEStringEncryptor enc = new StandardPBEStringEncryptor();
        EnvironmentStringPBEConfig env = new EnvironmentStringPBEConfig();
        env.setProvider((Provider)new BouncyCastleProvider());
        env.setProviderName(PROVIDER_NAME);
        env.setAlgorithmEnvName(ALGORITHM_ENV_NAME);
        if (env.getAlgorithm() == null) {
            env.setAlgorithm(ALGORITHM);
        }
        if (this.encryptionPassword != null) {
            env.setPassword(this.encryptionPassword);
            System.out.println("Specified password for decryption should be set to TESB_ENV_PASSWORD env variable");
        } else if (System.getenv(PASSWORD_ENV_NAME) != null) {
            env.setPasswordEnvName(PASSWORD_ENV_NAME);
        } else {
            System.out.println("TESB_ENV_PASSWORD system variable is not specified. ");
            System.out.println("Second parameter should be used to specify password.");
            return null;
        }
        enc.setConfig((PBEConfig)env);
        System.out.println(PropertyValueEncryptionUtils.encrypt((String)this.textToEncrypt, (StringEncryptor)enc));
        return null;
    }
}

